//
//  http_interface.h
//  GaeaInterface
//
//  Created by Herb on 2019/2/21.
//  Copyright © 2019年 DingTalk. All rights reserved.
//

#ifndef GAEA_SERVICE_HTTP_INTERFACE_H_
#define GAEA_SERVICE_HTTP_INTERFACE_H_

#include <functional>

#include "gaea/interface/http/http_request.h"
#include "gaea/interface/http/http_response.h"
#include "gaea/interface/base_interface.h"
#include "gaea/interface/task/url_task.h"
#include "gaea/base/error_result.h"

namespace gaea {
namespace service {

class HttpInterface : public BaseInterface {
 public:
  HttpInterface() {}
  virtual ~HttpInterface() {}
  virtual void Start() {};

  // =========== async func ============= //
  /**
   * @function Get
   * @param url 预下载的 URL 地址
   * @param on_success 执行成功的回调接口, 只要服务端不管什么错误码，都会通过on_success返回，
   *        回调返回 http 下载的(payload)数据信息
   * @param on_failure 执行失败的回调接口，当且晋档是本地各种错误，非服务端返回的错误。
   *        回调返回具体的错误码，以 ErrorResult 对象返回
   */
  virtual void Get(const std::string& url,
                   std::function<void(const std::string&)> on_success,
                   std::function<void(const gaea::base::ErrorResult&)> on_failure) {}
  
  virtual void Post(const std::string& url,
                    const std::string& content_type,
                    const std::string& payload,
                    std::function<void(const std::string&)> on_success,
                    std::function<void(const gaea::base::ErrorResult&)> on_failure) {}
  
  virtual void Query(HttpRequestPtr request,
                     std::function<void(HttpRequestPtr, HttpResponsePtr)> on_success,
                     std::function<void(const gaea::base::ErrorResult&)> on_failure) {}
  
  virtual void Send(UrlTaskPtr url_task,
                    std::function<void(HttpRequestPtr, HttpResponsePtr)> on_success,
                    std::function<void(const gaea::base::ErrorResult&)> on_failure) {}
};

} // end of namespace service
} // end of namespace gaea

#endif /* GAEA_SERVICE_HTTP_INTERFACE_H_ */
