//
//  http_response.h
//  HttpResponse
//
//  Created by jinxi on 22/09/2016.
//  Copyright © 2016 jinxi. All rights reserved.
//

#ifndef GAEA_INTERFACE_HTTP_RESPONSE_H_
#define GAEA_INTERFACE_HTTP_RESPONSE_H_

#include <memory>
#include <string>

#include "gaea/interface/http/http_header.h"

namespace gaea {
namespace service {

class HttpResponse {
 public:
  HttpResponse() : status_(0) {}
  
  HttpResponse(const HttpResponse& other) {
    this->status_ = other.status_;
    this->reason_ = other.reason_;
    this->payload_ = other.payload_;
    this->header_ = other.header_;
    this->trailer_ = other.trailer_;
  }
  
  virtual ~HttpResponse() {}
  
  int status() const { return status_; }
  void set_status(int status) { status_ = status; }

  const std::string& reason() const { return reason_; }
  void set_reason(const std::string& reason) { reason_ = reason; }

  HttpHeader* mutable_header() { return &header_; }
  const HttpHeader& header() const { return header_; }
  void set_header(const HttpHeader& header) { header_ = header; }

  const std::string& payload() const { return payload_; }
  void set_payload(const std::string& payload) { payload_ = payload; }
  
  HttpHeader* mutable_trailer() { return &trailer_; }
  const HttpHeader& trailer() const { return trailer_; }
  void set_trailer(const HttpHeader& trailer) { trailer_ = trailer; }

  HttpResponse& operator=(const HttpResponse& other) {
    this->status_ = other.status_;
    this->reason_ = other.reason_;
    this->payload_ = other.payload_;
    this->header_ = other.header_;
    this->trailer_ = other.trailer_;
    return *this;
  }
  
  std::string const ToString();
  
 private:
  int status_;
  std::string reason_;
  HttpHeader header_;
  HttpHeader trailer_;
  std::string payload_;
};
typedef std::shared_ptr<HttpResponse> HttpResponsePtr;

} // end of namespace service
} // end of namespace gaea

#endif /* GAEA_INTERFACE_HTTP_RESPONSE_H_ */
