  //
  //  push_ack_status.hpp
  //  gaea_interface
  //
  //  Created by guodi.ggd on 2021/1/25.
  //  Copyright © 2021 DingTalk. All rights reserved.
  //

#ifndef GAEA_INTERFACE_PUSH_ACK_STATUS_H_
#define GAEA_INTERFACE_PUSH_ACK_STATUS_H_

#include <cstdio>
#include <functional>
#include <memory>

#include "gaea/interface/macros.h"

namespace gaea {
namespace service {

class GAEA_INTERFACE_DECL PushAckStatus {
public:
  PushAckStatus();
  virtual ~PushAckStatus();
  
  virtual void AckSuccess() = 0;
  virtual void AckInvalid() = 0;
  virtual void AckException() = 0;
  virtual void AckStatus(int32_t code) = 0;
};

using PushAckStatusPtr = std::shared_ptr<PushAckStatus>;
using PushAckStatusWeakPtr = std::weak_ptr<PushAckStatus>;

}
}
#endif /* GAEA_INTERFACE_PUSH_ACK_STATUS_H_ */

