//
//  push_handler.hpp
//  gaea_interface
//
//  Created by guodi.ggd on 2021/1/25.
//  Copyright © 2021 DingTalk. All rights reserved.
//

#ifndef GAEA_INTERFACE_PUSH_HANDLER_H_
#define GAEA_INTERFACE_PUSH_HANDLER_H_

#include <cstdio>
#include <memory>
#include <string>

#include "gaea/interface/macros.h"

namespace gaea {
namespace service {

class PushAckStatus;
class RpcRequest;

using PushRequest = RpcRequest;
class GAEA_INTERFACE_DECL PushHandler {
public:
  PushHandler() {}
  virtual ~PushHandler();
  
  virtual void OnRecv(const PushRequest& push_request,
                      const std::shared_ptr<PushAckStatus>& ack) = 0;
  
};

using PushHandlerPtr = std::shared_ptr<PushHandler>;
using PushHandlerWeakPtr = std::weak_ptr<PushHandler>;

}
}
#endif /* GAEA_INTERFACE_PUSH_HANDLER_H_ */
