  //
  //  rpc_context.hpp
  //  gaea_interface
  //
  //  Created by guodi.ggd on 2021/1/21.
  //  Copyright © 2021 DingTalk. All rights reserved.
  //

#ifndef GAEA_INTERFACE_RPC_CONTEXT_H_
#define GAEA_INTERFACE_RPC_CONTEXT_H_

#include <cstdio>
#include <functional>
#include <utility>

#include "gaea/base/error_result.h"
#include "gaea/interface/macros.h"
#include "gaea/interface/rpc/rpc_response.h"

namespace gaea {
namespace service {

class GAEA_INTERFACE_DECL RpcContext {
public:
  typedef std::function<void(RpcResponsePtr response)> SuccessCallback;
  typedef std::function<void(RpcResponsePtr response, const gaea::base::ErrorResult& error)> FailureCallback;
  
  RpcContext() {}
  virtual ~RpcContext();
  
  void set_success(SuccessCallback on_success) {
    on_success_ = std::move(on_success);
  }
  
  void set_failure(FailureCallback on_failure) {
    on_failure_ = std::move(on_failure);
  }

  SuccessCallback on_success() const { return on_success_; }
  FailureCallback on_failure() const { return on_failure_; }
private:
  SuccessCallback on_success_;
  FailureCallback on_failure_;
};
using RpcContextPtr = std::shared_ptr<RpcContext>;
using RpcContextWeakPtr = std::weak_ptr<RpcContext>;

}
}


#endif /* rpc_context_hpp */

