//
//  base_message.hpp
//  gaea_interface
//
//  Created by guodi.ggd on 2021/1/21.
//  Copyright © 2021 DingTalk. All rights reserved.
//

#ifndef GAEA_INTERFACE_BASE_MESSAGE_H_
#define GAEA_INTERFACE_BASE_MESSAGE_H_

#include <cstdio>
#include <map>
#include <memory>
#include <set>
#include <string>
#include <vector>

#include "gaea/interface/macros.h"

namespace gaea {
namespace service {

class GAEA_INTERFACE_DECL RpcMessage {
public:
    typedef std::multimap<std::string, std::string> Headers;

    RpcMessage() {}
    virtual ~RpcMessage();
    
    virtual const std::string& startline() const { return start_line_; }
    virtual void set_startline(const std::string& start_line) { start_line_ = start_line; }
    
    const std::string& body() const;
    void set_body(const std::string& body) { body_ = body; }
    
    virtual bool ContainsHeader(const std::string& name) const;
    virtual std::string GetHeader(const std::string& name) const;
    
    virtual void AddHeader(const std::string& name, const std::string& value);
    virtual void SetHeader(const std::string& name, const std::string& value);
    virtual void RemoveHeader(const std::string& name);
    
    virtual std::set<std::string> GetHeaderNames() const;
    virtual std::vector<std::string> GetHeaderValues(const std::string& name) const;
    
    virtual const std::multimap<std::string, std::string>& headers() const { return headers_; }
    virtual void set_headers(const std::multimap<std::string, std::string>& headers) { headers_ = headers; }
    
protected:
    std::string start_line_;
    Headers headers_;
    std::string body_;
};
typedef std::shared_ptr<RpcMessage> RpcMessagePtr;
typedef std::weak_ptr<RpcMessage> RpcMessageWeakPtr;

}
}

#endif /* GAEA_INTERFACE_BASE_MESSAGE_H_ */
