//
//  base_request.hpp
//  gaea_interface
//
//  Created by guodi.ggd on 2021/1/21.
//  Copyright © 2021 DingTalk. All rights reserved.
//

#ifndef GAEA_INTERFACE_RPC_REQUEST_H_
#define GAEA_INTERFACE_RPC_REQUEST_H_

#include <cstdio>
#include <memory>

#include "gaea/interface/macros.h"
#include "gaea/interface/rpc/rpc_message.h"

namespace gaea {
namespace service {

class GAEA_INTERFACE_DECL RpcRequest : public RpcMessage {
public:
    RpcRequest();
    ~RpcRequest();

    virtual std::string uri() const { return uri_; }
    virtual void set_uri(const std::string &uri) { uri_ = uri; }

protected:
    std::string uri_;
};

typedef std::shared_ptr<RpcRequest> RpcRequestPtr;
typedef std::weak_ptr<RpcRequest> RpcRequestWeakPtr;
}  // namespace service
}  // namespace gaea
#endif /* GAEA_INTERFACE_RPC_REQUEST_H_ */
