//
//  rpc_response.h
//  gaea_interface
//
//  Created by guodi.ggd on 2021/1/21.
//  Copyright © 2021 DingTalk. All rights reserved.
//

#ifndef GAEA_INTERFACE_RPC_RESPONSE_H_
#define GAEA_INTERFACE_RPC_RESPONSE_H_

#include <cstdio>
#include <memory>

#include "gaea/base/error_result.h"
#include "gaea/interface/macros.h"
#include "gaea/interface/rpc/rpc_request.h"

namespace gaea {
namespace service {

class GAEA_INTERFACE_DECL RpcResponse : public RpcMessage {
public:
    RpcResponse();
    virtual ~RpcResponse();

    int code() const { return code_; }
    void set_code(int code) { code_ = code; }

    void set_local_error_result(const gaea::base::ErrorResult& er) { local_error_result_ = er; }
    gaea::base::ErrorResult& local_error_result() { return local_error_result_; }
protected:
    int code_;
    gaea::base::ErrorResult local_error_result_;
};

typedef std::shared_ptr<RpcResponse> RpcResponsePtr;
typedef std::weak_ptr<RpcResponse> RpcResponseWeakPtr;
}
}
#endif /* GAEA_INTERFACE_RPC_RESPONSE_H_ */
