//
//  rpc_service.hpp
//  gaea_interface
//
//  Created by guodi.ggd on 2021/1/21.
//  Copyright © 2021 DingTalk. All rights reserved.
//

#ifndef GAEA_INTERFACE_RPC_SERVICE_H_
#define GAEA_INTERFACE_RPC_SERVICE_H_

#include <cstdio>

#include "gaea/base/error_result.h"
#include "gaea/interface/base_interface.h"
#include "gaea/interface/macros.h"
#include "gaea/interface/rpc/rpc_context.h"
#include "gaea/interface/rpc/rpc_request.h"

namespace gaea {
namespace service {

class GAEA_INTERFACE_DECL RpcServiceInterface : public BaseInterface {
public:
    RpcServiceInterface() {}
    virtual ~RpcServiceInterface();
    
    virtual void SendRequest(RpcRequestPtr request, RpcContextPtr context) = 0;
    virtual void SendResponse(RpcResponsePtr response) = 0;
};

}
}
#endif /* GAEA_INTERFACE_RPC_SERVICE_H_ */
