//
//  base_task.hpp
//  gaea_interface
//
//  Created by guodi.ggd on 2020/9/13.
//

#ifndef GAEA_INTERFACE_TASK_URL_TASK_H_
#define GAEA_INTERFACE_TASK_URL_TASK_H_

#include <memory>
#include <string>
#include "gaea/interface/http/http_request.h"

namespace gaea {
namespace service {

enum MultiChannelType {
  kMultiChannelDefault = 0,   // use current interface
  kMultiChannelCellularOnly = 1,   // force use cellular, search valid interface begin with "pdp_ip"
};
  
class UrlTaskContext {
 public:
  UrlTaskContext() : channel_type_(kMultiChannelDefault), timeout_(30 * 1000) {}
  virtual ~UrlTaskContext() {}
  void set_channel_type(MultiChannelType channel_type) { channel_type_ = channel_type; }
  MultiChannelType channel_type() const { return channel_type_; }
  
  void set_timeout(int64_t timeout) { timeout_ = timeout; }
  int64_t timeout() const { return timeout_; }
  
 private:
  MultiChannelType channel_type_;
  int64_t timeout_;
};

class UrlTask {
 public:
  UrlTask();
  virtual ~UrlTask();
  const std::string& task_id() const { return task_id_; }
  void set_task_id(const std::string& task_id) { task_id_ = task_id; }
  
  const HttpRequestPtr http_request() const { return http_request_; }
  void set_http_request(const HttpRequestPtr http_request) { http_request_ = http_request; }

  const UrlTaskContext& url_task_context() { return url_task_context_; }
  void set_url_task_context(const UrlTaskContext &url_task_context) { url_task_context_ = url_task_context; }
private:
  const std::string GenerateTaskId() const;
  
 private:
  std::string task_id_;
  HttpRequestPtr http_request_;
  UrlTaskContext url_task_context_;
};

typedef std::shared_ptr<UrlTask> UrlTaskPtr;
typedef std::weak_ptr<UrlTask> UrlTaskWeakPtr;

}
}
#endif /* GAEA_INTERFACE_TASK_URL_TASK_H_ */
