//
//  useragent_interface.hpp
//  gaea_interface
//
//  Created by Herb on 2020/4/20.
//  Copyright © 2020 DingTalk. All rights reserved.
//

#ifndef GAEA_SERVICE_USERAGENT_INTERFACE_H_
#define GAEA_SERVICE_USERAGENT_INTERFACE_H_

#include "gaea/interface/base_interface.h"
#include "gaea/interface/rpc/rpc_context.h"
#include "gaea/interface/rpc/rpc_message.h"

namespace gaea {
namespace service {

class BaseMessage {
 public:
  BaseMessage() = default;
  virtual ~BaseMessage();
};

using BaseMessagePtr = std::shared_ptr<BaseMessage>;
using BaseMessageWeakPtr = std::weak_ptr<BaseMessage>;

class BaseContext {
 public:
  BaseContext() {}
  virtual ~BaseContext();
};
typedef std::shared_ptr<BaseContext> BaseContextPtr;
typedef std::weak_ptr<BaseContext> BaseContextWeakPtr;


class UserAgentInterface : public BaseInterface {
 public:
  UserAgentInterface() {}
  virtual ~UserAgentInterface();
  
  virtual void SendRequest(BaseMessagePtr request, BaseContextPtr context) = 0;
  virtual void SendResponse(BaseMessagePtr , BaseMessagePtr response) = 0;
};
typedef std::shared_ptr<UserAgentInterface> UserAgentInterfacePtr;
typedef std::weak_ptr<UserAgentInterface> UserAgentInterfaceWeakPtr;


}
}

#endif /* GAEA_SERVICE_USERAGENT_INTERFACE_H_ */
