//
//  Address.hpp
//  Atlas
//
//  Created by jinxi on 4/23/16.
//  Copyright © 2016 jinxi. All rights reserved.
//

#ifndef GAEA_LWP_COMMON_ADDRESS_H_
#define GAEA_LWP_COMMON_ADDRESS_H_

#include "gaea/base/uri.h"
#include "gaea/lwp/gaea_define.h"

GAEA_LWP_NAMESPACE_BEGIN

class Address : public gaea::base::Uri {
public:
  enum { kUnknown = 0, kTcp, kUdp };
  enum { kPlain = 0, kLws, kTls }; // LWS v3 only

public:
  Address();
  Address(const std::string& endpoint);

public:
  bool ParseAddress(const std::string& endpoint);

  bool Legal() const { return legal_; }

  int Protocol() const { return protocol_; }

  const std::string& Sni() const { return sni_; }
  bool IsTestSni() const;

  int Codec() const { return codec_; }

  const std::string& TlsSni() const { return tls_sni_; }
  
public:
  bool legal_;
  int protocol_;
  int codec_;
  std::string sni_;
  std::string tls_sni_;
};

GAEA_LWP_NAMESPACE_END

#endif /* GAEA_LWP_COMMON_ADDRESS_H_ */
