//
//  disaster_strategy.h
//  GaeaLwp
//
//  Created by Herb on 2020/2/21.
//  Copyright © 2020 DingTalk. All rights reserved.
//

#ifndef GAEA_LWP_DISASTER_STRATEGY_H_
#define GAEA_LWP_DISASTER_STRATEGY_H_

#include "gaea/base/singleton.h"
#include "gaea/lwp/gaea_define.h"

GAEA_LWP_NAMESPACE_BEGIN

class DisasterStrategy : public gaea::base::Singleton<DisasterStrategy> {
 public:
  DisasterStrategy();
  virtual ~DisasterStrategy();

  bool enable_heartbeat() const { return enable_heartbeat_; }
  void set_enable_heartbeat(bool enable) { enable_heartbeat_ = enable; }
 
  void set_interval_of_heartbeat(int64_t interval) { interval_of_heartbeat_ = interval; }
  int64_t interval_of_heartbeat() const { return interval_of_heartbeat_; }

  static const std::string gaea_module() { return gaea_module_; }
  static const std::string heartbeat_switch_key() { return heartbeat_switch_key_; }
  static const std::string interval_of_heartbeat_key() { return interval_of_heartbeat_key_; }
  
 private:
  static const char* gaea_module_;
  static const char* heartbeat_switch_key_;
  static const char* interval_of_heartbeat_key_;
  
  bool enable_heartbeat_;
  int64_t interval_of_heartbeat_;
};

GAEA_LWP_NAMESPACE_END

extern void GaeaNetworkDisacterStrategySetEnableHeartbeat(bool enable);
extern void GaeaNetworkDisacterStrategySetIntervalOfHeartbeat(int64_t interval);

#endif /* GAEA_LWP_DISASTER_STRATEGY_H_ */
