//
//  file_download_result.h
//  gaea_lwp
//
//  Created by guodi.ggd on 2019/11/14.
//  Copyright © 2019 DingTalk. All rights reserved.
//

#ifndef file_download_result_h
#define file_download_result_h

#include <fstream>

#include "gaea/lwp/gaea_define.h"

#if defined(UTEST_PREPROCESS_MODULE)
  class FileDownloadResultTest;
#endif

GAEA_LWP_NAMESPACE_BEGIN

class FileDownloadTask;

class FileDownloadResult {
#if defined(UTEST_PREPROCESS_MODULE)
  friend FileDownloadResultTest;
#endif
  
  friend FileDownloadTask;
 public:
  FileDownloadResult();
  virtual ~FileDownloadResult() {}
    // TODO: 支持文件路径
  const std::string path() const { return path_; }
  void set_path(const std::string& path) { path_ = path; }
  
  const std::string& data() const { return data_; }
  int64_t data_size() const { return data_size_; }
  
 private:
  bool OpenExportHandler();
  bool ExportData(int64_t start, const std::string& data);
  bool CloseExportHandler();
  int64_t ExportMemoryBuffer(int64_t start, const std::string& body);
  
 private:
  int64_t data_size_;
  std::string path_;
  std::string data_;
  std::shared_ptr<std::ofstream> export_data_hander_;
};

GAEA_LWP_NAMESPACE_END
#endif /* file_download_result_h */
