//
//  file_download_task.h
//  gaea_lwp
//
//  Created by guodi.ggd on 2019/11/14.
//  Copyright © 2019 DingTalk. All rights reserved.
//

#ifndef file_download_task_h
#define file_download_task_h

#include <stdio.h>
#include <chrono>
#include <memory>
#include <string>
#include <map>

#include "gaea/lwp/gaea_define.h"
#include "file_download_result.h"

GAEA_LWP_NAMESPACE_BEGIN

class FileDownloadTask {
 public:
  FileDownloadTask();
  virtual ~FileDownloadTask() {}

  // media_id
  const std::string& media_id() const { return media_id_; }
  void set_media_id(const std::string& media_id) { media_id_ = media_id; }
  
  /** 下载存储路径 */
  const std::string path() const { return download_result_.path(); }
  void set_path(const std::string& path) { download_result_.set_path(path); }
  
  const std::string& download_url() { return download_url_; }
  void set_download_url(const std::string& download_url) { download_url_ = download_url; }

  const std::string& data() const { return data_; }
  void set_data(const std::string& data) { data_ = data; }

  const std::string& biz_type() const { return biz_type_; }
  void set_biz_type(const std::string& biz_type) { biz_type_ = biz_type; }
  
  const std::string& auth_token() const { return auth_token_; }
  void set_auth_token(const std::string& auth_token) { auth_token_ = auth_token; }

  std::map<std::string, std::string>& headers() { return headers_; }
  void set_map(std::map<std::string, std::string>& headers) { headers_ = headers; }

  void set_dtn_task_id(int32_t dtn_task_id) { dtn_task_id_ = dtn_task_id; }
  int32_t dtn_task_id() { return dtn_task_id_; }
  
  const std::string& task_id() { return task_id_; }
  void set_task_id(const std::string& task_id) { task_id_ = task_id; }

  const FileDownloadResult& download_result() const { return download_result_; }

  const std::map<std::string, std::string> biz_entity() const { return biz_entity_; }
  void set_biz_entity(const std::map<std::string, std::string> biz_entity) { biz_entity_ = biz_entity; }
  
  const std::map<std::string, std::string> auth_info() const { return auth_info_; }
  void set_auth_info(const std::map<std::string, std::string> auth_info) { auth_info_ = auth_info; }
 
//  bool need_quick_transfor() const { return need_quick_transfor_; }
//  void set_need_quick_transfor(bool enable) { need_quick_transfor_ = enable; }
 
  bool PrepareExportData();
  bool ExportData(int64_t start, const std::string& data);
  bool CloseExportData();
  
 private:
  std::string media_id_;
  std::string download_url_;
  std::string data_;
  std::string biz_type_;
  std::string auth_token_;
  
  std::chrono::time_point<std::chrono::steady_clock> beginTime_;
  std::map<std::string, std::string> headers_;
  std::map<std::string, std::string> biz_entity_;
  std::map<std::string, std::string> auth_info_;
  std::string task_id_;
  int32_t dtn_task_id_; // map dtn task to lwp
  FileDownloadResult download_result_;
//  bool need_quick_transfor_;
};

typedef std::shared_ptr<FileDownloadTask> FileDownloadTaskPtr;

GAEA_LWP_NAMESPACE_END


#endif /* file_download_task_h */
