//
//  lwp_manager.h
//  gaeaLwp
//
//  Created by guodi.ggd on 2019/10/27.
//  Copyright © 2019 DingTalk. All rights reserved.
//

#ifndef lwp_manager_h
#define lwp_manager_h

#include <stdio.h>
#include <memory>

#include "gaea/base/logging.h"
#include "gaea/base/properties.h"
#include "gaea/extension/accs/taobao_accs_manager.h"
#include "gaea/lwp/gaea_define.h"
#include "gaea/lwp/gaea_config.h"
#include "gaea/lwp/runtime_center.h"
#include "gaea/lwp/setting.h"
#include "gaea/net/network_service.h"
#include "gaea/service/auth_service.h"

GAEA_LWP_NAMESPACE_BEGIN

class AladdinService;
typedef std::shared_ptr<AladdinService> AladdinServicePtr;

extern void NotifyNetworkChange(bool network_is_available);

class LwpManager : public gaea::base::Singleton<LwpManager> {
 public:
  gaea::lwp::Setting* GetSetting();
  gaea::lwp::NetworkService* GetNetworkService();
  gaea::lwp::TaobaoAccsManager* GetTaobaoAccsManager();
  gaea::lwp::RunTimeCenter* GetRuntimeCenter();
  gaea::base::Properties* GetSingletonProperties();
  gaea::lwp::GaeaConfig* GetConfig();
  gaea::base::LoggerFactory* GetLoggerFactory();
  gaea::lwp::AladdinServicePtr GetAladdinService();
  gaea::lwp::AuthService* GetAuthService();

 private:
  AladdinServicePtr global_aladdin_;
};
GAEA_LWP_NAMESPACE_END

#endif /* lwp_manager_h */
