//
//  mid.h
//  Atlas
//
//  Created by 金喜 on 4/24/16.
//  Copyright © 2016 金喜. All rights reserved.
//

#ifndef GAEA_LWP_MID_H_
#define GAEA_LWP_MID_H_

#include <string>
#include "gaea/lwp/gaea_define.h"

GAEA_LWP_NAMESPACE_BEGIN

class Mid {
 public:
  Mid();
  Mid(const std::string& mid, int seq);
  Mid(const Mid& mid);
  ~Mid();

  const std::string& mid() const { return mid_; }
  void set_mid(const std::string& mid) { mid_ = mid; }

  int seq() const { return seq_; }
  void set_seq(int seq) { seq_ = seq; }
  
  void IncSeq() { seq_++; }

  bool Loads(const std::string& line);
  std::string Dumps() const;
  void GenerateMid();
  Mid& operator=(const Mid& mid);
  
 private:
  std::string mid_;
  int seq_;
};

GAEA_LWP_NAMESPACE_END

#endif /* GAEA_LWP_MID_H_ */
