//
//  request_context.h
//  gaea
//
//  Created by guodi.ggd on 2019/1/7.
//  Copyright © 2019 DingTalk. All rights reserved.
//

#ifndef GAEA_LWP_REQUEST_CONTEXT_H_
#define GAEA_LWP_REQUEST_CONTEXT_H_

#include <chrono>
#include <memory>
#include "gaea/base/logging.h"
#include "gaea/base/trace_context.h"
#include "gaea/interface/useragent/useragent_interface.h"
#include "gaea/lwp/gaea_define.h"
#include "gaea/lwp/message.h"
#include "gaea/lwp/request.h"
#include "gaea/lwp/response.h"

GAEA_LWP_NAMESPACE_BEGIN

class BridgeAdaptor;

class RequestContext : public gaea::service::BaseContext {
  friend class BridgeAdaptor;

 public:
  enum RequestHandlerErrorType {
    kIdlUnpackError = -1,
    kNoError = 0,
  };
  
 public:
  RequestContext();
  virtual ~RequestContext();
  
  void set_timeout(std::chrono::milliseconds timeout) { timeout_ = timeout; }
  std::chrono::milliseconds timeout() const { return timeout_; }
  
  SiteType site_id() const { return site_id_; }
  void set_site_id(SiteType siteId) { site_id_ = siteId; }
  
  Message::ConnectionId connection_id() const { return connection_id_; }
  void set_connection_id(Message::ConnectionId connection_id) { connection_id_ = connection_id; }

  void set_trace_id(const std::string& trace_id) { trace_context_.set_trace_id(trace_id); }
  void set_trace_context(const gaea::base::TraceContext& context) { trace_context_ = context; }
  gaea::base::TraceContext& trace_context() { return trace_context_; }
  
  bool need_auth() { return need_auth_; }
  void set_need_auth(bool need_auth) {
    need_auth_ = need_auth;
  }
  
  bool enable_retry() { return enable_retry_; }
  void set_enable_retry(bool enable_retry) { enable_retry_ = enable_retry; }
  
  void set_timeout_auth_status(int status) { timeout_auth_status_ = status; }
  int timeout_auth_status() const { return timeout_auth_status_; }
  
  void set_disable_compress(bool val) { disable_compress_ = val; }
  bool disable_compress() const { return disable_compress_; }

  int64_t unpack_cost() const { return unpack_cost_; }
  void set_unpack_cost(int64_t unpack_cost) { unpack_cost_ = unpack_cost; }
  
  int unpack_status() const { return unpack_status_; }
  void set_unpack_status(int unpack_status) { unpack_status_ = unpack_status; }
  
  virtual void OnSuccess(RequestPtr request, ResponsePtr response) {}
  virtual void OnPartialSuccess(RequestPtr request, ResponsePtr response) {}
  virtual void OnFailure(RequestPtr request, ResponsePtr response) {}
  
  int64_t biz_callback_cost() const { return biz_callback_cost_; }
  void set_biz_callback_cost(int64_t cost_time) { biz_callback_cost_ = cost_time; }

  bool allow_empty_body() { return allow_empty_body_; }
  void set_allow_empty_body(bool allow_empty_body) { allow_empty_body_ = allow_empty_body; }
  
  void SetRequestHeader(const std::string& name, const std::string& value) { lwp_headers_[name] = value; }
  const std::map<std::string, std::string>& lwp_headers() const { return lwp_headers_; }
  
  void SetPendingBeginTime();
  void SetTryingBeginTime();
  void SetProcessingBeginTime();
  void SetCallbackBeginTime();
  void SetCallbackEndTime();
  
  int64_t PendingCostTime();
  int64_t TryingCostTime();
  int64_t ProcessingCostTime();
  int64_t CallbackCostTime();
  int64_t TotalCostTime();

  void set_unique_mark(const std::string& mark);
  bool is_missing_fields() const { return is_missing_fields_; }
  void set_is_missing_fields(bool missing_fields) { is_missing_fields_ = missing_fields; }

  void set_biz_error_result(const gaea::base::ErrorResult& error) { biz_error_result_ = error; }
  const gaea::base::ErrorResult biz_error_result() { return biz_error_result_; }

protected:
  void BeforeUnpack();
  void AfterUnpack();

private:
  void set_inner_callback(bool enbale_inner_callabck) { inner_callback_ = enbale_inner_callabck; }
  bool inner_callback() { return inner_callback_; }
  
protected:
  gaea::base::Logger logger_;
  std::string unique_mark_;
  bool is_missing_fields_;

private:
  std::chrono::milliseconds timeout_;
  
  std::chrono::time_point<std::chrono::steady_clock> unpack_start_time_;
  int64_t unpack_cost_;
  int unpack_status_;
  
  SiteType site_id_;
  int connection_id_;
  bool need_auth_;
  int timeout_auth_status_;
  bool enable_retry_;
  bool allow_empty_body_;
  bool disable_compress_;
  
  std::chrono::time_point<std::chrono::steady_clock> pending_begin_time_;
  std::chrono::time_point<std::chrono::steady_clock> trying_begin_time_;
  std::chrono::time_point<std::chrono::steady_clock> processing_begin_time_;
  std::chrono::time_point<std::chrono::steady_clock> callback_begin_time_;
  std::chrono::time_point<std::chrono::steady_clock> callback_end_time_;
  int64_t biz_callback_cost_;
  
  gaea::base::TraceContext trace_context_;
  bool inner_callback_;
  std::map<std::string, std::string> lwp_headers_;
  gaea::base::ErrorResult biz_error_result_;
};

typedef std::shared_ptr<RequestContext> RequestContextPtr;

GAEA_LWP_NAMESPACE_END

#endif /* GAEA_LWP_REQUEST_CONTEXT_H_ */
