//
//  response.h
//  gaea
//
//  Created by guodi.ggd on 2019/1/7.
//  Copyright © 2019 DingTalk. All rights reserved.
//

#ifndef GAEA_LWP_RESPONSE_H_
#define GAEA_LWP_RESPONSE_H_

#include "gaea/lwp/message.h"
#include "gaea/base/error_result.h"
#include "gaea/lwp/error_result_helper.h"

GAEA_LWP_NAMESPACE_BEGIN
  
class Response : public Message {
 public:
  Response();
  Response(int code);
  ~Response();

  int code() const { return code_; }
  void set_code(int code) { code_ = code; }
  
  int64_t cost_time() const { return cost_time_; }
  void set_cost_time(int64_t cost_time) { cost_time_ = cost_time; }
  
  void set_local_error_result(const gaea::base::ErrorResult& er) { local_error_result_ = er; }
  gaea::base::ErrorResult& local_error_result() { return local_error_result_; }
  std::string ToString() override;
 protected:
  virtual const std::string StartLine() override;

 private:
  int code_;
  int64_t cost_time_;
  gaea::base::ErrorResult local_error_result_;
};
  
typedef std::shared_ptr<Response> ResponsePtr;
class ResponseHelper {
public:
  static ResponsePtr BuildLocalResponse(const Mid& mid,
                                        const MessageStatus& status,
                                        const ErrorCode& error_code) {
    ResponsePtr response(new Response(status));
    response->set_mid(mid);
    gaea::base::ErrorResult err = ErrorResultHelper::BuildLocalError(error_code);
    err.set_status(status);
    response->set_local_error_result(err);
    return response;
  }
  
  static ResponsePtr BuildLocalResponse(const Mid& mid,
                                        const MessageStatus& status,
                                        const gaea::base::ErrorResult& err) {
    ResponsePtr response(new Response(status));
    response->set_mid(mid);
    response->set_local_error_result(err);
    return response;
  }
  
};

GAEA_LWP_NAMESPACE_END

#endif /* GAEA_LWP_RESPONSE_H_ */
