//
//  session_delegate.hpp
//  GaeaLwp
//
//  Created by guodi.ggd on 2019/4/18.
//  Copyright © 2019 DingTalk. All rights reserved.
//

#ifndef Gaea_Lwp_Session_Delegate_h
#define Gaea_Lwp_Session_Delegate_h

#include <string>
#include <functional>
#include "gaea/lwp/gaea_define.h"
#include "gaea/lwp/rpc_reg_model.h"

GAEA_LWP_NAMESPACE_BEGIN

class SessionDelegate {
public:
  SessionDelegate() {}
  virtual ~SessionDelegate() {}
  
  virtual RpcRegModel GetRpcRegModelOnSessionForAutoSubscribe() { return RpcRegModel(); }
  virtual std::string TokenRequiredOnSession() { return ""; }
  virtual std::map<std::string, std::string> GetRegHeaders() {
    std::map<std::string, std::string> headers;
    return headers;
  }

  virtual void AsyncTokenRequiredOnSession(const gaea::base::ErrorResult& error) {}
  virtual void DidConnectionChanged(LwpConnectionStatus status) {}
  // 底层完成建立连接后通知上层
  virtual void AuthedOnSession() {}
  virtual bool IsUserLogin() = 0;
  virtual void ConnectedOnSession() = 0;
  virtual void ConnectFailedOnSession(const gaea::base::ErrorResult& err_result) = 0;
  virtual void DisconnectOnSession(const gaea::base::ErrorResult& err_result) = 0;
  // temporary return true to ignore error log
  virtual bool SetMainServerCookieOnSession(const std::string& cookie) { return true; }
  virtual const gaea::base::StringMap& GetCacheHeader() = 0;
  virtual void OnIncomingRequest(RequestPtr request) = 0;
};
  
GAEA_LWP_NAMESPACE_END
#endif /* Gaea_Lwp_Session_Delegate_h */
