//
//  setting.h
//  gaeaLwp
//
//  Created by Herb on 2019/1/20.
//  Copyright © 2019年 DingTalk. All rights reserved.
//

#ifndef GAEA_LWP_SETTING_H_
#define GAEA_LWP_SETTING_H_

#include <functional>
#include <list>
#include <map>
#include <memory>
#include <mutex>
#include <string>

#include "gaea/base/singleton.h"
#include "gaea/lwp/gaea_define.h"
#include "gaea/interface/trace/trace_interface.h"

GAEA_LWP_NAMESPACE_BEGIN

class FileServiceInterface;

class VirtualSocket;
typedef std::shared_ptr<VirtualSocket> VirtualSocketPtr;

class AbstractConnection;
typedef std::shared_ptr<AbstractConnection> AbstractConnectionPtr;

class UserContext;
typedef std::shared_ptr<UserContext> UserContextPtr;

class EventLoop;
typedef std::shared_ptr<EventLoop> EventLoopPtr;
typedef std::function<VirtualSocketPtr (gaea::lwp::EventLoopPtr)> VirtualSocketFactory;
typedef std::function<FileServiceInterfacePtr (UserContextPtr)> FileServiceFactory;
typedef std::function<AbstractConnectionPtr (gaea::lwp::EventLoopPtr, gaea::lwp::EventLoopPtr, SiteType)> ConnectionFactory;

class UserAgentSetting {
public:
  const std::string device_id() {
    std::lock_guard<std::mutex> lock(mutex_);
    return device_id_;
  };
  void set_device_id(const std::string& device_id) {
    std::lock_guard<std::mutex> lock(mutex_);
    device_id_ = device_id;
  }
private:
  std::string device_id_;
  std::mutex  mutex_;
};

typedef std::shared_ptr<UserAgentSetting> UserAgentSettingPtr;
class Setting : public gaea::base::Singleton<Setting> {
 public:
  Setting();
  virtual ~Setting() {}
  
  const std::string& app_key() const { return app_key_; }
  void set_app_key(const std::string& app_key) { app_key_ = app_key; }
  
  const std::string& device_id() const { return device_id_; }
  void set_device_id(const std::string& device_id) { device_id_ = device_id; }
  
  // follow api will be deprecated, (support in c++14)
  const std::string& default_server() const { return default_server_; }
  void set_default_server(const std::string& default_server) { default_server_ = default_server; }
  // follow api will be deprecated, (support in c++14)
  const std::string& short_server() const { return short_server_; }
  void set_short_server(const std::string& short_server) { short_server_ = short_server; }

  const std::string& file_server() const { return file_server_; }
  void set_file_server(const std::string& file_server);
  
  const std::list<std::string>& callback_white_list() const { return callback_white_list_; }
  
  /**
   * @func SetCacheHeader 设置 key 对应的 value 值
   * @param key 关键字
   * @param value 键值
   */
  void SetCacheHeader(const std::string& key, const std::string& value) { cache_header_[key] = value; }
  
  /**
   * @func cache_header 通过特定的 key 关键字返回对应的值
   * @param key 关键字
   * @return 返回映射表中关键字对应的值，
   *         key无效或者为空，返回空值
   */
  const std::string GetCacheHeaderValueByName(const std::string& key) const;
  
  /**
   * @func GetCacheHeaderMap 获取头域关键字-值映射表
   * @return 映射表
   */
  const std::map<std::string, std::string>& cache_header() const { return cache_header_; }
  void ClearCacheHeader() { cache_header_.clear(); }
  
  void set_master_connection_type(ConnectionPlugType type);
  ConnectionPlugType master_connection_type() { return master_connection_type_; }
  
  void set_file_connection_type(ConnectionPlugType type);
  ConnectionPlugType file_connection_type() { return file_connection_type_; }
  
  void set_conn_factory(ConnectionPlugType plug_type, ConnectionFactory factory);
  ConnectionFactory conn_factory(ConnectionPlugType plug_type);
  
  void set_socket_factory(VirtualSocketFactory factory) { socket_factory_ = factory; }
  VirtualSocketFactory& socket_factory() { return socket_factory_; }

  void set_file_service_factory(ConnectionPlugType plug_type, FileServiceFactory factory);
  FileServiceFactory file_service_factory(ConnectionPlugType plug_type);

  const std::string& root_path();
  void set_root_path(const std::string& path);
  
  void set_longlink_server(const std::vector<std::string>& services);
  const std::vector<std::string>& longlink_server() { return longlink_servers_; }
  
  void set_ca_certificate_file(const std::string& server) { ca_certificate_file_ = server; }
  std::string ca_certificate_file() { return ca_certificate_file_; }
  
  void set_trace_service(service::TraceInterfacePtr trace_service);
  const gaea::service::TraceInterfacePtr trace_service() {
    return trace_service_;
  };
  
  void set_tls_verify_host(const std::string& host) { tls_verify_host_ = host; }
  const std::string& tls_verify_host() { return tls_verify_host_; }
  
  void set_ssl_verify_disabled(bool value) { ssl_verify_disabled_ = value; }
  bool ssl_verify_disabled() const { return ssl_verify_disabled_; }
  
  void set_ipv6_enabled(bool enable) { ipv6_enabled_ = enable; }
  bool ipv6_enabled() const { return ipv6_enabled_; }
  
  void set_aladdin_enabled(bool enable) { aladdin_enabled_ = enable; }
  bool aladdin_enabled() const { return aladdin_enabled_; }

  void set_disable_master_connection(bool disable_master_connection) { disable_master_connection_ = disable_master_connection; }
  bool disable_master_connection() const { return disable_master_connection_; }
  
 private:
  gaea::base::Logger logger_;
  std::mutex mutex_;
  std::vector<std::string> longlink_servers_;
  std::string ca_certificate_file_;
  std::string app_key_;
  std::string device_id_;
  std::string tls_verify_host_;
  bool ssl_verify_disabled_;
  bool ipv6_enabled_;
  bool aladdin_enabled_;
  bool disable_master_connection_;

  std::string default_server_;
  std::string short_server_;
  std::string file_server_;
  std::string root_path_;
  
  /** 提供外部自定义配置 键-值 表对 */
  std::map<std::string, std::string> cache_header_;
  
  std::list<std::string> callback_white_list_;
  
  /** 外部创建链接对象接口实现 */
  std::map<ConnectionPlugType, ConnectionFactory> conn_factory_map_;
  std::map<ConnectionPlugType, FileServiceFactory> file_service_factory_map_;
  
  /** 外部创建链接对象接口实现 */
  VirtualSocketFactory socket_factory_;
  ConnectionPlugType master_connection_type_;
  ConnectionPlugType file_connection_type_;
  gaea::service::TraceInterfacePtr trace_service_;
};

GAEA_LWP_NAMESPACE_END

#endif /* GAEA_LWP_SETTING_H_ */
