//
// Created by 司沐 on 2019-08-07.
//

#ifndef GAEA_MEDIA_MEDIA_ID_H
#define GAEA_MEDIA_MEDIA_ID_H

#include <stdint.h>
#include <string>
#include "gaea/media_id/media_id_type_collection.h"
#include "gaea/media_id/media_id_info.h"

namespace gaea {
namespace media {

class MediaId {
 public:
  MediaId();
  virtual ~MediaId() = default;
  virtual bool ToUrl(const std::string &media_id, std::string *target_url) = 0;
  virtual bool Load(const std::string &media_id, MediaIdInfo *media_id_info) = 0;

  const MediaIdFileType media_id_type() const { return media_id_type_; }
  void set_media_id_type(MediaIdFileType media_id_type) { media_id_type_ = media_id_type; }

  int64_t sequence() const { return sequence_; }
  void set_sequence(int64_t sequence) { sequence_ = sequence; }

  int height() const { return height_; }
  void set_height(int height) { height_ = height; }

  int width() const { return width_; }
  void set_width(int width) { width_ = width; }

  int angle() const { return angle_; }
  void set_angle(int angle) { angle_ = angle; }

  const std::string &host() const { return host_; }
  void set_host(const std::string &host) { host_ = host; }

  const std::string &media_id_filtered() const { return filtered_media_id_; }
  void set_media_id_filtered(const std::string &filtered_media_id) { filtered_media_id_ = filtered_media_id; }

  std::string FilterMediaIdDomain(const std::string &media_id, const std::string &piece);

 protected:
  bool burn() const { return burn_; }
  void set_burn(bool burn) { burn_ = burn; }
 private:
  MediaIdFileType media_id_type_;
  int64_t sequence_;
  bool burn_;
  int height_;
  int width_;
  int angle_;
  std::string host_;
  std::string filtered_media_id_;
};

} // end of namespace media
} // end of namespace gaea

#endif //GAEA_MEDIA_MEDIA_ID_H
