//
// Created by 司沐 on 2019-06-12.
//
//

/*
 * url图片缩放
 *
 * width    > 0
 * height   > 0
 * quality  90/95/80/75/60/50/30
 * rotation true/false
 * extension .jpg/.png
 * webp_extension _.webp
 *
 */

#ifndef GAEA_MEDIA_MEDIA_ID_URL_H
#define GAEA_MEDIA_MEDIA_ID_URL_H

#include <string>
#include <map>
#include <memory>
#include "gaea/media_id/media_id.h"
#include "gaea/media_id/media_id_info.h"
#include "gaea/media_id/media_id_type_collection.h"

namespace gaea {
namespace media {

class MediaIdManager {
 public:
  MediaIdManager();
  virtual ~MediaIdManager();
  
  /**
   * @brief                         Transfer media id To url
   * @param     media_id            media_id v1/v2
   * @param     size_type           ImageSize
   * @param     kv_map              Properties to add
   * @param     webp_extension      Webp or not
   * @return                        Url
   */
  std::string TransferToImageUrl(const std::string &media_id,
                                 const ImageSize &size_type,
                                 const std::map<std::string, std::string> &kv_map,
                                 bool webp_extension = false);
  /**
   * @brief                         Transfer media id To url
   * @param     media_id            media_id v1/v2
   * @param     size_type           ImageSize
   * @param     webp_extension      Webp or not
   * @param     image_extension     Suffix of image
   * @return                        Url
   */
  std::string TransferToImageUrl(const std::string &media_id,
                                 const ImageSize &size_type = kOriginImage,
                                 bool webp_extension = false,
                                 const ImageExtension *image_extension = nullptr,
                                 const std::map<std::string, std::string> *kv_map = nullptr);

  std::string TransferToCommonFileUrl(const std::string &media_id);
  
  bool TransferToObject(const std::string &media_id, gaea::media::MediaIdInfo *media_id_info);

  /**
   * @brief                         Append image properites to url
   * @param     original_url        Original url
   * @param     size_type           ImageSize
   * @param     webp_extension      Webp or not
   * @param     image_extension     Suffix of image
   * @return                        Url with properties
   */
  static std::string AppendPropertiesToUrl(const std::string &original_url,
                                           const ImageSize &size_type = kOriginImage,
                                           bool webp_extension = false,
                                           const ImageExtension *image_extension = nullptr,
                                           const std::map<std::string, std::string> *kv_map = nullptr);

  void SetHost(HostType host_type, const std::string &host);
  
  /**
   * @brief pick the constant part of url string
   * @param url source url
   * @return string of the url's constant part
   */
  const std::string GetUrlConstantPart(const std::string& url);
  
  /**
   * @brief append kv onurl
   * @param url source url
   * @param kv_map  append kv map, both key and value will be Url Encoded and append to url.
   * @return string of the url's constant part
   */
  static std::string AppendKeyValueProperties(const std::string &url,
                                              const std::map<std::string, std::string> &kv_map);
 private:
  static std::string AppendImageProperties(const std::string &original_url,
                                           const ImageSize &image_size = kOriginImage,
                                           bool webp_extension = false,
                                           const ImageExtension *image_extension = nullptr);
  
  std::shared_ptr<MediaId> Create(const std::string &media_id);
  bool IsV1MediaId(const std::string &media_id);
  bool IsV2MediaId(const std::string &media_id);
private:
  std::string media_id_v1_host_;
  std::string media_id_v2_host_;
  std::string media_id_v2_cdn_host_;
};

} // end of namespace media
} // end of namespace gaea

#endif //GAEA_MEDIA_MEDIA_ID_URL_H
