//
// Created by 司沐 on 2019-06-13.
//

#ifndef GAEA_MEDIA_MEDIA_ID_URL_TYPE_H
#define GAEA_MEDIA_MEDIA_ID_URL_TYPE_H

#include <stdint.h>
#include <string>

namespace gaea {
namespace media {

enum MediaIdFileType {
  kDefaultType = -1,
  kImageJpg = 0,
  kImageGif = 1,
  kImagePng = 2,
  kImageBmp = 3,
  kAudioAmr = 4,
  kAudioMp3 = 5,
  kVideoMp4 = 6,
  kAudioWav = 7,
  kNormalFile = 8,
  kOfficeDoc = 9,
  kOfficeDocx = 10,
  kOfficeXls = 11,
  kOfficeXlsx = 12,
  kOfficePpt = 13,
  kOfficePptx = 14,
  kNormalZip = 15,
  kNormalPdf = 16,
  kNormalRar = 17,
  kNormalPsd = 18,
  kNormalAi = 19,
  kNormalTxt = 20,
  kVideoAvi = 21,
  kVideoRmvb = 22,
  kVideoRm = 23,
  kVideoMpg = 24,
  kVideoWmv = 25,
  kVideoMkv = 26,
  kVideoVob = 27,
  kNormalTfsprivate = 28,
  kImageWebp = 29,
  kAudioOpus = 30,
  kAudioOgg = 31,
  kImageJpeg = 32,
};

enum MediaIdAuthType {
  kMediaIdNoAuth,
  kMediaIdStrictAuth,
  kMediaIdOnlyLoginAuth,
  kMediaIdOnlyInternalAuth,
  kMediaIdTempAuth,
  kMediaIdOnlyServiceAuth,
  kMediaIdCdnOnly,
};

struct ImageSizeWidthHeight {
  int width;
  int height;
};

enum ImageSize : int16_t {
  kDefaultImageSize     = -1,
  kOriginImage          = 0,
  kFuzzyImage           = 1,
  kThumbImage           = 2,
  kBigImage             = 3,

  kImageSize_120x120    = 100,
  kImageSize_200x200    = 101,
  kImageSize_1200x1200  = 102,
  kImageSize_250x10000  = 103,
  kImageSize_480x480    = 104,
  kImageSize_640x640    = 105,
};

enum ImageQuality : int16_t {
  kDefaultImageQuality = -1,
  kSixty = 60,
  kSeventyFive = 75,
  kEighty = 80,
  kNinety = 90,
  kNinetyFive = 95,
};

enum ImageType {
  kDefaultImageType = -1,
  kJpg = 0,
  kGif = 1,
  kPng = 2,
  kBmp = 3,
  kWebp = 4,
  kJpeg = 5,
};

enum HostType {
  kNewMediaIdCdnHost = 0,
  kNewMediaIdHost = 1,
  kMediaIdV1Host = 2,
};


struct ImageExtension {
  ImageQuality image_quality = kDefaultImageQuality;
  bool image_rotation = false;
  ImageType image_type = kDefaultImageType;
};

} // end of media
} // end of gaea

#endif //GAEA_MEDIA_MEDIA_ID_URL_TYPE_H
