//
//  auth_service.h
//  GaeaLwp
//
//  Created by Herb on 2019/5/8.
//  Copyright © 2019年 DingTalk. All rights reserved.
//

#ifndef GAEA_LWP_AUTH_SERVICE_H_
#define GAEA_LWP_AUTH_SERVICE_H_

#include <stdio.h>

#include "gaea/lwp/gaea_define.h"
#include <gaea/base/singleton.h>

GAEA_LWP_NAMESPACE_BEGIN

class UserAgent;
class OAuthModel;

class AuthService : public gaea::base::Singleton<AuthService> {
public:
  AuthService();
  virtual ~AuthService() {}
  
  /**
   * @function RefreshToken
   * @brief 刷新 token
   */
  void RefreshToken(UserAgent& user_agent,
                    const std::string& refresh_token,
                    std::function<void(const gaea::lwp::OAuthModel&)> onRefreshToken,
                    std::function<void()> onExpired,
                    std::function<void(const gaea::base::ErrorResult&)> onFailure);
private:
  bool NeedLogoutOnError(const gaea::base::ErrorResult& error) const;
  
private:
  gaea::base::Logger logger_;
};

GAEA_LWP_NAMESPACE_END

#endif /* GAEA_LWP_AUTH_SERVICE_H_ */
