; (function () {
    if (window.LDJsBridge) {
        return;
    }

    if (!window.onerror) {
        window.onerror = function (msg, url, line) {
            console.log("LDJsBridge: ERROR:" + msg + "@" + url + ":" + line);
        }
    }
    window.LDJsBridge = {
        sendMessageQueue: [],
        messageHandlers: {},
        jsHybridNotes: [],
        responseCallbacks: {},
        uniqueId: 1,
        registerHandler: registerHandler,
        callHandler: callHandler,
        _fetchQueue: _fetchQueue,
        _handleMessageFromAndroid: _handleMessageFromAndroid,
        _addJsHybridNote: _addJsHybridNote,
        _getHandlerNames: _getHandlerNames
    };

//    var sendMessageQueue = [];
//    var messageHandlers = {};
//    //绑定的jsNode的数组
//    var jsHybridNotes = [];
//
//    var responseCallbacks = {};
//    var uniqueId = 1;

    function registerHandler(handlerName, handler) {
        console.log("注册了一个JS方法" + handlerName);
        window.LDJsBridge.messageHandlers[handlerName] = handler;
    }

    function callHandler(handlerName, data, responseCallback) {
        if (arguments.length == 2 && typeof data == 'function') {
            responseCallback = data;
            data = null;
        }
        _doSend({ handlerName: handlerName, data: data }, responseCallback);
    }

    function _doSend(message, responseCallback) {
        if (responseCallback) {
            var callbackID = 'cb_' + (window.LDJsBridge.uniqueId++) + '_' + new Date().getTime();
            window.LDJsBridge.responseCallbacks[callbackID] = responseCallback;
            message['callbackID'] = callbackID;
        }

        var handlerName = message.handlerName;
        var nodeName = "";
        var handlerNames = _getHandlerNames();

        nodeName = handlerNames.find(function (name, index) {
            try {
                console.log("handlerName ---" + handlerName);
                var tmpFn = eval('window.' + name + '.' + handlerName);
                console.log("fn ---" + tmpFn);
                if (typeof tmpFn === 'function') {
                    return true
                } else {
                    return false;
                }
            } catch (e) {
                console.log(e);
                return false;
            }
        });

        if (nodeName == null) {
            nodeName = 'android';
        }

        try {
            console.log("handlerName ---" + handlerName);
            var fn = eval('window.' + nodeName + '.' + handlerName);
            console.log("fn ---" + fn);
        } catch (e) {
            console.log(e);
        }

        if (typeof fn === 'function') {
            console.log("开始执行方法" + fn);
            console.log("传递的参数-" + JSON.stringify(message));
            var responseData = fn && (window[nodeName][handlerName])(JSON.stringify(message));
            if (responseData) {
                console.log('response message: ' + responseData);
                responseCallback = window.LDJsBridge.responseCallbacks[callbackId];
                if (!responseCallback) {
                    return;
                }
                responseCallback(responseData);
                delete window.LDJsBridge.responseCallbacks[callbackId];
            }
        }
    }

    function _fetchQueue() {
        var messageQueueString = JSON.stringify(window.LDJsBridge.sendMessageQueue);
        window.LDJsBridge.sendMessageQueue = [];
        return messageQueueString;
    }

    // 获取所有的处理器名称
    function _getHandlerNames(){
        console.log("_getHandlerNames" + _getHandlerNames);
        var handlerNamesJson = window.android.getHandlerNames("");
        console.log("handlerNamesJson" + handlerNamesJson);
        return JSON.parse( handlerNamesJson );
    }

    function _dispatchMessageFromAndroid(messageJSON) {
        var message = JSON.parse(messageJSON);
        var messageHandler;
        var responseCallback;
        console.log("收到原生的调用消息" + messageJSON);
        if (message.responseID) {
            console.log("收到原生的回调" + message.responseID);
            console.log("所有的回调的数组 -- " + window.LDJsBridge.responseCallbacks);
            responseCallback = window.LDJsBridge.responseCallbacks[message.responseID];
            console.log("找到的回调的方法 -- " + responseCallback);
            if (!responseCallback) {
                return;
            }
            responseCallback(message.responseData);
            delete window.LDJsBridge.responseCallbacks[message.responseID];
        } else {
            if (message.callbackID) {
                var callbackResponseId = message.callbackID;
                responseCallback = function (responseData) {
                    _doSend({ handlerName: "response", responseID: callbackResponseId, responseData: responseData });
                };
            }

            var handler = window.LDJsBridge.messageHandlers[message.handlerName];
            if (!handler) {
                console.log("LDJsBridge: WARNING: no handler for message from Android:", message);
            } else {
                handler(message.data, responseCallback);
            }
        }
    }

    function _handleMessageFromAndroid(messageJSON) {
        _dispatchMessageFromAndroid(messageJSON);
    }

    function _addJsHybridNote(nodeName) {
        if (nodeName && window.LDJsBridge.jsHybridNotes.includes(nodeName)) {
            return;
        }
        window.LDJsBridge.jsHybridNotes.push(nodeName);
    }

    if (filez.initFilezCallBack) {
        filez.initFilezCallBack(filez);
        filez.initFilezCallBack = null;
    }

})();