
precision lowp float;

uniform sampler2D EarthDay;

varying vec3 light;
varying vec3 ObjectNormal;
varying vec2 TextureCoordOut;
varying vec2 TextureCoordNight;
varying vec3 AtmosColor;
varying mat4 rotMatrix;
varying float alpha;

void main(void)
{

    float df = max(dot(ObjectNormal, light), 0.0);
    df = min(1.0, df * 5.0);

    vec4 day = texture2D(EarthDay, TextureCoordOut) + vec4(AtmosColor, 1.0) * AtmosColor.b * 1.4;
    gl_FragColor = texture2D(EarthDay, TextureCoordNight) * (1.0 - sqrt(df))  + day * df;
   
    
    gl_FragColor.a = alpha;
}



