attribute vec4 a_position;
attribute vec3 a_normal;
attribute vec2 a_texCoord;

uniform mat4 Projection;
uniform mat4 Modelview;
uniform mat4 RotationMatrix;
uniform mat4 u_mvpMatrix;
uniform vec3 LightPosition;
uniform vec3 RotatedLightPosition;
uniform float CameraHeight;

varying vec2 TextureCoordOut;
varying vec2 TextureCoordNight;
varying vec3 ObjectNormal;
varying vec3 AtmosColor;
varying vec3 light;
varying mat4 rotMatrix;
varying float alpha;

float scale(float fCos)
{
	float x = 1.0 - fCos;
    float fScaleDepth = 0.32;
	float res = fScaleDepth * exp(-0.00287 + x*(0.459 + x*(3.83 + x*(-6.80 + x*5.25))));
	return res;
}

void main(void)
{	
    vec3  Wavelength = vec3(0.650,0.570,0.475);
    vec3  v3InvWavelength = 1.0 / vec3( Wavelength.x * Wavelength.x * Wavelength.x * Wavelength.x,
                                       Wavelength.y * Wavelength.y * Wavelength.y * Wavelength.y,
                                       Wavelength.z * Wavelength.z * Wavelength.z * Wavelength.z);

    float fInnerRadius = 1.0;
    float fOuterRadius = fInnerRadius * 1.33;
    float fOuterRadius2 = fOuterRadius * fOuterRadius;	// fOuterRadius^2

    float Kr = 0.025;
    float Km = 0.015;
    float ESun = 10.0;

    float fKrESun = Kr * ESun;
    float fKmESun = Km * ESun;
    float fKr4PI = Kr * 4.0 * 3.1415;
    float fKm4PI = Km * 4.0 * 3.1415;
    float fScale = 1.0 / (fOuterRadius - fInnerRadius);
    float fScaleDepth = 0.32;		// The scale depth (i.e. the altitude at which the atmosphere's average density is found)
    float fScaleOverScaleDepth = fScale / fScaleDepth;
    float fCameraHeight = CameraHeight;

    vec3 v3CameraPos = vec3(0.0, 0.0, fCameraHeight);
    float fCameraHeight2 = fCameraHeight * fCameraHeight;


    light = LightPosition;
    
    vec3 lp = RotatedLightPosition;
    
//    camPos = v3CameraPos;
    
	// Get the ray from the camera to the vertex and its length (which is the far point of the ray passing through the atmosphere)
	vec3 v3Pos = (RotationMatrix * a_position).xyz;
	vec3 v3Ray = v3Pos - v3CameraPos;
	float fFar = length(v3Ray);
	v3Ray /= fFar;

	// Calculate the closest intersection of the ray with the outer atmosphere (which is the near point of the ray passing through the atmosphere)
	float B = 2.0 * dot(v3CameraPos, v3Ray);
	float C = fCameraHeight2 - fOuterRadius2;
	float fDet = max(0.0, B*B - 4.0 * C);
	float fNear = 0.5 * (-B - sqrt(fDet));
    
	// Calculate the ray's starting position, then calculate its scattering offset
	vec3 v3Start = v3CameraPos + v3Ray * fNear;
	fFar -= fNear;
	float fDepth = exp((fInnerRadius - fOuterRadius) / fScaleDepth);
	float fCameraAngle = dot(-v3Ray, v3Pos) / length(v3Pos);
	float fLightAngle = dot(lp, v3Pos) / length(v3Pos);
	float fCameraScale = scale(fCameraAngle);
	float fLightScale = scale(fLightAngle);
	float fCameraOffset = fDepth*fCameraScale;
	float fTemp = (fLightScale + fCameraScale);
    
	// Initialize the scattering loop variables
	float fSampleLength = fFar / 2.0;
	float fScaledLength = fSampleLength * fScale;
	vec3 v3SampleRay = v3Ray * fSampleLength;
	vec3 v3SamplePoint = v3Start + v3SampleRay * 0.5;
    
	// Now loop through the sample rays
	vec3 v3FrontColor = vec3(0.0, 0.0, 0.0);
	vec3 v3Attenuate;
    
	float fHeight = length(v3SamplePoint);
	fDepth = exp(fScaleOverScaleDepth * (fInnerRadius - fHeight));
	float fScatter = fDepth*fTemp - fCameraOffset;
	v3Attenuate = exp(-fScatter * (v3InvWavelength * fKr4PI + fKm4PI));
	v3FrontColor += v3Attenuate * (fDepth * fScaledLength);
	v3SamplePoint += v3SampleRay;
	
	// unroll loop once
	fHeight = length(v3SamplePoint);
	fDepth = exp(fScaleOverScaleDepth * (fInnerRadius - fHeight));
	fScatter = fDepth*fTemp - fCameraOffset;
	v3Attenuate = exp(-fScatter * (v3InvWavelength * fKr4PI + fKm4PI));
	v3FrontColor += v3Attenuate * (fDepth * fScaledLength);
	v3SamplePoint += v3SampleRay;
	
	AtmosColor = (v3FrontColor * (v3InvWavelength * fKrESun + fKmESun) + 0.25 *v3Attenuate) * 0.3;
    TextureCoordOut = a_texCoord;
    TextureCoordOut.y *= 0.5;
//    TextureCoordOut.y += 0.5;

//    TextureCoordDay = a_texCoord;
//    TextureCoordDay.y = TextureCoordDay.y * 0.5;
    
    
    TextureCoordNight = a_texCoord;
    TextureCoordNight.y *= 0.5;
    TextureCoordNight.y += 0.5;

//    TextureCoordNext = a_texCoord;
//    TextureCoordNext.y *= 0.5;
    
	ObjectNormal = a_normal;
	
//	gl_Position = Projection * Modelview * RotationMatrix * a_position;
	gl_Position = u_mvpMatrix * a_position;
    rotMatrix = RotationMatrix;
    
    vec3 norm = (vec4(0.0, 0.0, 1.0, 0.0) * RotationMatrix).xyz;

    alpha  = max(dot(a_normal, norm), 0.0);
    
    alpha *= 2.5;
    alpha = pow(alpha, 7.0);


    
}


