#ifndef GL_FRAGMENT_PRECISION_HIGH
precision mediump float;
precision mediump int;

varying vec3 v3FrontColor;
varying vec3 v3InvWavelength;
varying vec3 mieColor;
varying float fKrESun;
varying float miePhase;

void main(void)
 {
    gl_FragColor.rgb = v3FrontColor * (v3InvWavelength * fKrESun) + miePhase * mieColor;
    gl_FragColor.a = 1.0;//gl_FragColor.b;
}
#else
precision highp float;
precision highp int;

varying vec3 v3Pos;
varying vec3 light;
uniform mat4 RotationMatrix;
uniform float CameraHeight;

float getNearIntersection(vec3 v3Pos, vec3 v3Ray, float C) {
    float B = 2.0 * dot(v3Pos, v3Ray);
    float fDet = max(0.0, B*B - 4.0 * C);
    float res = (-B - sqrt(fDet));
    return 0.5 * res;
}

float scale(float fCos) {
    float a1 = -6.80 + fCos*5.25;
    float a2 = 3.83 + fCos*(a1);
    float a3 = 0.459 + fCos*(a2);
    float a4 = -0.00287 + fCos*(a3);
    float a5 = exp(a4);
    float res = 0.32 * a5;
    return res;
}

void main(void)
 {
    float g = -0.95;
    float g2 = 0.9025;
    float fInnerRadius = 0.8;
    float fOuterRadius = 0.832;
    vec3  Wavelength = vec3(0.650,0.570,0.475);
    vec3  v3InvWavelength = vec3( 5.602, 9.473, 19.644);
    float fOuterRadius2 = 0.6922;
    float Kr = 0.0025;
    float Km = 0.0015;
    float ESun = 15.0;
    float fKrESun = Kr * ESun;
    float fKmESun = Km * ESun;
    float fKr4PI = Kr * 4.0 * 3.1415;
    float fKm4PI = Km * 4.0 * 3.1415;
    float fScale = 31.25;
    float fScaleDepth = 0.32;
    float fScaleOverScaleDepth = 97.65625;
    float fSamples = 3.0;
    vec3 v3CameraPos = vec3(0.0, 0.0, CameraHeight);
    float fCameraHeight = length(v3CameraPos);
    float fCameraHeight2 = fCameraHeight * fCameraHeight;
    float C = fCameraHeight2 - fOuterRadius2;
    vec3 v3Ray = (v3Pos - v3CameraPos);
    float fFar = length (v3Ray);
    v3Ray = (v3Ray / fFar);
    float fNear = getNearIntersection(v3CameraPos, v3Ray, C);
    vec3 v3Start = (v3CameraPos + (v3Ray * fNear));
    vec3 RotatedLightPosition = (RotationMatrix * vec4(light, 1.0)).xyz;
    fFar -= fNear;
    float fStartAngle = (1.0 - (dot (v3Ray, v3Start) / fOuterRadius));
    float fStartDepth = exp ((-1.0 / fScaleDepth));
    float fStartOffset = fStartDepth*scale(fStartAngle);
    float fSampleLength = fFar * 0.5;
    float fScaledLength = fSampleLength * fScale;
    vec3 v3SampleRay = (v3Ray * fSampleLength);
    vec3 v3SamplePoint = (v3Start + (v3SampleRay * 0.5));
    float fHeight = length (v3SamplePoint);
    float fDepth = exp ((fScaleOverScaleDepth * (fInnerRadius - fHeight)));
    float fLightAngle = (1.0 - (dot (RotatedLightPosition, v3SamplePoint) / fHeight));
    float fCameraAngle = (1.0 - (dot (v3Ray, v3SamplePoint) / fHeight));
    vec3 v3FrontColor = ((exp ((-((fStartOffset + (fDepth * (scale(fLightAngle) - scale(fCameraAngle))))) * ((v3InvWavelength * fKr4PI) + fKm4PI))) * (fDepth * fScaledLength)));
    vec3 v3Direction = (v3CameraPos - v3Pos);
    float fCos = (dot (RotatedLightPosition, v3Direction) / length (v3Direction));
    vec3 mieColor = (v3FrontColor * fKmESun);
    float miePhase = 1.5 * ((1.0 - g2) / (2.0 + g2)) * (1.0 + fCos * fCos) / pow (1.0 + g2 - 2.0 * g * fCos, 1.5);
    gl_FragColor.rgb = v3FrontColor * (v3InvWavelength * fKrESun) + miePhase * mieColor;
    gl_FragColor.a = gl_FragColor.b;
}
#endif