--push lib--
--g_OSType : 0 Android 1 IOS 2WinPhone

if not G_Push then
	G_Push = {}
end

local G_Push = G_Push

G_Push.enOSAndroid 	   = 0
G_Push.enOSIOS 		       = 1
G_Push.defBreatheInterval = 60
G_Push.defOffsetInterval    = 180
G_Push.defMinInterval	    = 360

function G_Push:Id2String( nId )
	if not self.pStringRes then
		return ''
	end
	
	return self.pStringRes:GetStr( nId + 2 , 2 )
end

function G_Push:DBGetStr( szSec , szKey , szDefault )
	if not G_Push.pPushDB then
		return ''
	end
	return self.pPushDB:GetStr( szSec , szKey , szDefault  ) 
end

function G_Push:DBGetInt( szSec , szKey , nDef )
	if not G_Push.pPushDB then
		return nDef
	end
	return self.pPushDB:GetInt( szSec , szKey , nDef  ) 
end

function G_Push:DBSetVal( szSec , szKey , szVal )
	if not G_Push.pPushDB then
		return
	end
	return self.pPushDB:WriteVal( szSec , szKey , szVal  ) 
end

function G_Push:ClockPerDayArrange( nClock ,  szTitle , szContent , nMinitue  )

    if not nMinitue then
    	nMinitue = 0
    end
    
	local tCurTime =  SGetTime( )
	local tCurData = G_Push.DataUtil[1]
	SToDataTime( tCurTime, tCurData )
	
	local tChkData = G_Push.DataUtil[2]
	if tCurData.Hour > nClock or ( tCurData.Hour == nClock and tCurData.Minute >= nMinitue + 4 ) then 
		local tChkTime = tCurTime + 24 * 3600
		SToDataTime( tChkTime, tChkData )
	else
		 tChkData 		  = tCurData
	end
	
	tChkData.Hour     = nClock
	tChkData.Minute  = nMinitue
	tChkData.Second = 0
	
	local tToTriggerTime = SFromDataTime( tChkData ) 	
	self:Arrange( szTitle , szContent , tToTriggerTime , 0 , 24 * 3600  )
end

function G_Push:ClockPerWeekArrange( nBeginWDay, nEndWDay, nClock, nMinute, szTitle, szContent )
	if nBeginWDay > nEndWDay then
		local nTmp = nBeginWDay
		nBeginWDay = nEndWDay
		nEndWDay = nTmp
	end

	local tCurTime = SGetTime( )
	local tCurDate= G_Push.DataUtil[1]
	SToDataTime( tCurTime, tCurDate )
	for nDay = nBeginWDay, nEndWDay do
		local tDstDate = G_Push.DataUtil[2]
		SToDataTime( tCurTime, tDstDate )
		tDstDate.Day		= tCurDate.Day - tCurDate.WeekDay + nDay
		tDstDate.Hour		= nClock
		tDstDate.Minute		= nMinute
		tDstDate.Second		= 0
		local nDstTime		= SFromDataTime( tDstDate )
		if nDstTime + 240 < tCurTime then
			tDstDate.Day		= tCurDate.Day - tCurDate.WeekDay + 7 + nDay
			nDstTime = SFromDataTime( tDstDate )
		end

		self:Arrange( szTitle, szContent, nDstTime, 0, 24 * 3600 * 7 )
	end
end

function G_Push:ClockPerMonthArrange( nBeginMDay, nEndMDay, nClock, nMinute, szTitle, szContent )
	if nBeginMDay > nEndMDay then
		local nTmp = nBeginMDay
		nBeginMDay = nEndMDay
		nEndMDay = nTmp
	end

	local tCurTime = SGetTime( )
	local tCurDate= G_Push.DataUtil[1]
	SToDataTime( tCurTime, tCurDate )
	for nDay = nBeginMDay, nEndMDay do
		local tDstDate = G_Push.DataUtil[2]
		SToDataTime( tCurTime, tDstDate )
		tDstDate.Day		= tCurDate.Day - tCurDate.Day + nDay
		tDstDate.Hour		= nClock
		tDstDate.Minute		= nMinute
		tDstDate.Second		= 0
		local nDstTime		= SFromDataTime( tDstDate )
		if nDstTime + 240 < tCurTime then
			tDstDate.Month	= tDstDate.Month + 1
			nDstTime		= SFromDataTime( tDstDate )
		end

		self:Arrange( szTitle, szContent, nDstTime, 0, 0 )
	end
end

function G_Push:SpecialTimeTriggerCalc( nBaseTime ,  nCompClock , nTriggerClock , nOffsetDay , nCompMinite , nTriggerMinitue  )
	
	if not nCompMinite then
		nCompMinite = 0
	end
	
	if not nTriggerMinitue then
		nTriggerMinitue = 0
	end
    
	local tCurTime =  nBaseTime
	local tCurData = G_Push.DataUtil[1]
	SToDataTime( tCurTime, tCurData )
	
	local tChkData = G_Push.DataUtil[2]
	if tCurData.Hour > nCompClock or ( tCurData.Hour == nCompClock and tCurData.Minute >= nCompMinite + 4 )  then 
		nOffsetDay      = nOffsetDay + 1
	end
	
	local tChkTime = tCurTime + nOffsetDay * 24 * 3600
	SToDataTime( tChkTime, tChkData )
	
	tChkData.Hour     = nTriggerClock
	tChkData.Minute  = nTriggerMinitue
	tChkData.Second = 0
	
	local tToTriggerTime = SFromDataTime( tChkData ) 	
	return tToTriggerTime
end

function G_Push:DesignerSchedule( )
	--жܿأĿǰֻжIOS豸
	if g_OSType == G_Push.enOSIOS then
		if G_Push:UserGetInt( 'Player', 'IsOpen', 0 ) == 0 and G_Push:UserGetStr( 'Player', 'Name', '' ) == '' then
			print( 'G_Push-->DesignerSchedule-->ios is close' )
			return 
		end  
	end 
	
	--ݽԶ庯滻
	--------------------------------------------------------------------------------------------------------------------

	if G_Push:UserGetInt('Player','PushSwitch',0) == 0  then  
		local radnum=math.random(4) - 1 

		if ( 120 - G_Push:UserGetInt('Player','Fatigue',0)  ) > 0  then  

			if G_Push:UserGetInt('Player','FTime',0) <= 0  then  
			else
				if radnum == 0  then  
					G_Push:Arrange(G_Push:Id2String(1),G_Push:Id2String(2),G_Push:UserGetInt('Player','FTime',0) + ( 360 * ( 120 - G_Push:UserGetInt('Player','Fatigue',0)  )  ),0,0) 
				else
					if radnum == 1  then  
						G_Push:Arrange(G_Push:Id2String(3),G_Push:Id2String(4),G_Push:UserGetInt('Player','FTime',0) + ( 360 * ( 120 - G_Push:UserGetInt('Player','Fatigue',0)  )  ),0,0) 
					else
						if radnum == 2  then  
							G_Push:Arrange(G_Push:Id2String(5),G_Push:Id2String(6),G_Push:UserGetInt('Player','FTime',0) + ( 360 * ( 120 - G_Push:UserGetInt('Player','Fatigue',0)  )  ),0,0) 
						else
							if radnum == 3  then  
								G_Push:Arrange(G_Push:Id2String(1),G_Push:Id2String(2),G_Push:UserGetInt('Player','FTime',0) + ( 360 * ( 120 - G_Push:UserGetInt('Player','Fatigue',0)  )  ),0,0) 
							else
							end
						end
					end
				end
			end
		else
		end
		if G_Push:UserGetInt('Player','Lv',0) >= 30  then  
			if G_Push:UserGetInt('Player','FarmRipeTime',0) ~= 0   then  
				if radnum <= 1  then  
					G_Push:Arrange(G_Push:Id2String(47),G_Push:Id2String(48),G_Push:UserGetInt('Player','FarmRipeTime',0),0,0) 
				else
					G_Push:Arrange(G_Push:Id2String(49),G_Push:Id2String(50),G_Push:UserGetInt('Player','FarmRipeTime',0),0,0) 
				end
			else
			end
			if G_Push:UserGetInt('Player','FarmAllFishTime',0) ~= 0   then  
				if radnum <= 1  then  
					G_Push:Arrange(G_Push:Id2String(51),G_Push:Id2String(52),G_Push:UserGetInt('Player','FarmAllFishTime',0),0,0) 
				else
					G_Push:Arrange(G_Push:Id2String(53),G_Push:Id2String(54),G_Push:UserGetInt('Player','FarmAllFishTime',0),0,0) 
				end
			else
			end
		else
		end
		if G_Push:UserGetInt('Player','Lv',0) >= 11  then  
			G_Push:ClockPerDayArrange(12,G_Push:Id2String(7),G_Push:Id2String(8),0) 
			G_Push:ClockPerDayArrange(18,G_Push:Id2String(9),G_Push:Id2String(10),0) 
			G_Push:ClockPerDayArrange(21,G_Push:Id2String(11),G_Push:Id2String(12),0) 
		else
		end
		if G_Push:UserGetInt('Player','Lv',0) >= 4  then  
			G_Push:ClockPerDayArrange(12,G_Push:Id2String(27),G_Push:Id2String(28),0) 
			G_Push:ClockPerDayArrange(18,G_Push:Id2String(33),G_Push:Id2String(34),0) 
			G_Push:ClockPerDayArrange(21,G_Push:Id2String(31),G_Push:Id2String(32),0) 
		else
		end
		if G_Push:UserGetInt('Player','LastEnter',0) <= G_Push:SpecialTimeTriggerCalc(G_Push:UserGetInt('Player','LastEnter',0),5,20,7,0,40)  then  
			G_Push:Arrange(G_Push:Id2String(13),G_Push:Id2String(14),G_Push:SpecialTimeTriggerCalc(G_Push:UserGetInt('Player','LastEnter',0),5,12,1,0,25),0,0) 
			G_Push:Arrange(G_Push:Id2String(13),G_Push:Id2String(14),G_Push:SpecialTimeTriggerCalc(G_Push:UserGetInt('Player','LastEnter',0),5,20,1,0,40),0,0) 
			G_Push:Arrange(G_Push:Id2String(15),G_Push:Id2String(16),G_Push:SpecialTimeTriggerCalc(G_Push:UserGetInt('Player','LastEnter',0),5,12,2,0,25),0,0) 
			G_Push:Arrange(G_Push:Id2String(15),G_Push:Id2String(16),G_Push:SpecialTimeTriggerCalc(G_Push:UserGetInt('Player','LastEnter',0),5,20,2,0,40),0,0) 
			G_Push:Arrange(G_Push:Id2String(17),G_Push:Id2String(18),G_Push:SpecialTimeTriggerCalc(G_Push:UserGetInt('Player','LastEnter',0),5,12,3,0,25),0,0) 
			G_Push:Arrange(G_Push:Id2String(17),G_Push:Id2String(18),G_Push:SpecialTimeTriggerCalc(G_Push:UserGetInt('Player','LastEnter',0),5,20,3,0,40),0,0) 
			G_Push:Arrange(G_Push:Id2String(19),G_Push:Id2String(20),G_Push:SpecialTimeTriggerCalc(G_Push:UserGetInt('Player','LastEnter',0),5,12,4,0,25),0,0) 
			G_Push:Arrange(G_Push:Id2String(19),G_Push:Id2String(20),G_Push:SpecialTimeTriggerCalc(G_Push:UserGetInt('Player','LastEnter',0),5,20,4,0,40),0,0) 
			G_Push:Arrange(G_Push:Id2String(21),G_Push:Id2String(22),G_Push:SpecialTimeTriggerCalc(G_Push:UserGetInt('Player','LastEnter',0),5,12,5,0,25),0,0) 
			G_Push:Arrange(G_Push:Id2String(21),G_Push:Id2String(22),G_Push:SpecialTimeTriggerCalc(G_Push:UserGetInt('Player','LastEnter',0),5,20,5,0,40),0,0) 
			G_Push:Arrange(G_Push:Id2String(23),G_Push:Id2String(24),G_Push:SpecialTimeTriggerCalc(G_Push:UserGetInt('Player','LastEnter',0),5,12,6,0,25),0,0) 
			G_Push:Arrange(G_Push:Id2String(23),G_Push:Id2String(24),G_Push:SpecialTimeTriggerCalc(G_Push:UserGetInt('Player','LastEnter',0),5,20,6,0,40),0,0) 
			G_Push:Arrange(G_Push:Id2String(25),G_Push:Id2String(26),G_Push:SpecialTimeTriggerCalc(G_Push:UserGetInt('Player','LastEnter',0),5,12,7,0,25),0,0) 
			G_Push:Arrange(G_Push:Id2String(25),G_Push:Id2String(26),G_Push:SpecialTimeTriggerCalc(G_Push:UserGetInt('Player','LastEnter',0),5,20,7,0,40),0,0) 
		else
		end
		if SGetTime() < G_Push:UserGetInt('Player','PreRegister',0)  then  
			if G_Push:UserGetInt('Player','LastCreate',0) > 0  then  
			else
				G_Push:Arrange(G_Push:Id2String(35),G_Push:Id2String(36),G_Push:UserGetInt('Player','PreRegister',0),0,0) 
			end
		else
		end
		if G_Push:UserGetInt('Player','Lv',0) >= 47  then  
			G_Push:ClockPerWeekArrange(0,0,19,30,G_Push:Id2String(37),G_Push:Id2String(38)) 
			G_Push:ClockPerWeekArrange(6,6,19,30,G_Push:Id2String(37),G_Push:Id2String(38)) 
		else
		end
		if G_Push:UserGetInt('Player','Lv',0) >= 44  then  
			G_Push:ClockPerWeekArrange(5,5,11,0,G_Push:Id2String(39),G_Push:Id2String(40)) 
			G_Push:ClockPerWeekArrange(6,6,11,0,G_Push:Id2String(39),G_Push:Id2String(40)) 
			G_Push:ClockPerWeekArrange(0,0,11,0,G_Push:Id2String(39),G_Push:Id2String(40)) 
		else
		end
		if G_Push:UserGetInt('Player','CookMatchOpen',0) > SGetTime()  then  
			G_Push:Arrange(G_Push:Id2String(43),G_Push:Id2String(44),G_Push:UserGetInt('Player','CookMatchOpen',0),0,0) 
		else
		end
		if G_Push:UserGetInt('Player','MonsterHunterOpen',0) > SGetTime()  then  
			G_Push:Arrange(G_Push:Id2String(45),G_Push:Id2String(46),G_Push:UserGetInt('Player','MonsterHunterOpen',0),0,0) 
		else
		end
		if G_Push:UserGetInt('Player','IsInLeague',0) == 1  then  
			G_Push:ClockPerWeekArrange(1,1,10,0,G_Push:Id2String(55),G_Push:Id2String(56)) 
			G_Push:ClockPerWeekArrange(2,3,10,0,G_Push:Id2String(57),G_Push:Id2String(58)) 
		else
		end
	else
	end
end

function G_Push:Schedule( )

	--clear first
	self.ScheduleRec = {	}
	self:ClearNotify( )
	
	--user data
	self:ReloadUser( )
	
	--user strategy
	self:DesignerSchedule( )
	
end

function G_Push:Breathe( )
	local tbToClear = {	}
	for i , v in pairs( G_Push.ScheduleRec ) do 
		local tbNotify    = v
		local uTimeCur = SGetTime( )
		if uTimeCur >= tbNotify. firetime then
			if uTimeCur < tbNotify. firetime + G_Push.defOffsetInterval and uTimeCur > self:DBGetInt(  "System" , "LastTrigger" , 0 ) + self.defMinInterval  then
			    print( 'Push:'..tbNotify.content )
				self:TriggerNotify( tbNotify.title , tbNotify.content , tbNotify.firetime , 0 , 0 )
				
				if self.pPushDB then
					self.pPushDB:WriteVal( "System" , "LastTrigger" , SGetTime( ) )
					self.pPushDB:Save( "./push/pushdb.ini" )
				end
			end
			
			if tbNotify.repeatInterval == 0 then
				table.insert( tbToClear , i )
			else
				tbNotify.firetime = tbNotify.firetime + tbNotify.repeatInterval
			end
			
		end
	end
	
	--Clear
	for i , v in pairs( tbToClear ) do 
		local tbKeyToClear   = v
		G_Push.ScheduleRec[ tbKeyToClear ] = nil
	end
end

function G_Push:UserGetStr( szSec , szKey , szDefault )
	if not G_Push.pUserCfg then
		return ''
	end
	return self.pUserCfg:GetStr( szSec , szKey , szDefault  ) 
end

function G_Push:UserGetInt( szSec , szKey , nDef )
	if not G_Push.pUserCfg then
		return nDef
	end
	return self.pUserCfg:GetInt( szSec , szKey , nDef  ) 
end

function G_Push:UserSetStr( szSec, szKey, szString )
	if not G_Push.pUserCfg then
		return
	end
	G_Push.pUserCfg:WriteVal( szSec, szKey, szString )
	G_Push.pUserCfg:Save( "./users/pushinfo.ini" )
end 

function G_Push:UserSetInt( szSec, szKey, nNumber )
	if not G_Push.pUserCfg then
		return
	end
	G_Push.pUserCfg:WriteVal( szSec, szKey, tostring( nNumber ) )	
	G_Push.pUserCfg:Save( "./users/pushinfo.ini" )
end 

function G_Push:ClearPriority( )
	G_Push.Priorities = {}
end

function G_Push:PushPriorytiy( szTitle , szContent , nFireTime , szKey, nWeight )
    if nFireTime == 0 then
    	nFireTime = SGetTime( )
    end
	local push = {  }
	push.title = szTitle
	push.content = szContent
	push.firetime = nFireTime
	push.weight  = nWeight
	push.key		= szKey
	table.insert( G_Push.Priorities , push  )
end

function G_Push:Arrange( szTitle , szContent , nFireTime , nRepeatCnt , nRepeatInterval )

    if nFireTime == 0 then
    	nFireTime = SGetTime( )
    end
    
    print( 'To Trigger:' .. nFireTime .. 'Times:' .. nRepeatInterval ..'RepeatCnt'..nRepeatCnt )
    
	if g_OSType == G_Push.enOSAndroid then
		local push = {  }
		push.title = szTitle
		push.content = szContent
		push.firetime = nFireTime
		push.repeatcnt = nRepeatCnt
		push.repeatInterval = nRepeatInterval		
		
		table.insert( G_Push.ScheduleRec , push  )
	else
		
		--Ͳ
    	if SGetTime( ) > nFireTime + G_Push.defOffsetInterval then
    		return
    	end
    
		self:TriggerNotify( szTitle , szContent , nFireTime , nRepeatCnt , nRepeatInterval )
	end
end

function G_Push:FirePriority( )

	local function SortWeight( tbLeft, tbRight )
		return tbLeft.weight < tbRight.weight
	end
	
	table.sort( G_Push.Priorities , SortWeight  )
	
	local tbToFire = G_Push.Priorities[1]
	if tbToFire then
		self:TriggerNotify(  tbToFire.title ,  tbToFire.content , tbToFire.firetime )
	end
end

function G_Push:ReloadUser( )
	if G_Push.pUserCfg then
		G_Push.pUserCfg:delete( )
		G_Push.pUserCfg = nil
	end

	G_Push.pUserCfg = SIniFile:new( )
	G_Push.pUserCfg:Load( "./users/pushinfo.ini" )
end

-- Reload-------------------------------------------
--StringRes
if G_Push.pStringRes then
	G_Push.pStringRes:delete( )
	G_Push.pStringRes = nil
end
G_Push.pStringRes = STabFile:new( )
G_Push.pStringRes:Load( "./push/pushstring.txt" )

--Data base
if G_Push.pPushDB then
	G_Push.pPushDB:delete( )
	G_Push.pPushDB = nil
end

G_Push.pPushDB = SIniFile:new( )
G_Push.pPushDB:Load( "./push/pushdb.ini" )

--User info
G_Push:ReloadUser( )

--Tools --------------------------------------
G_Push.Priorities = {}
if not G_Push.DataUtil  then
	G_Push.DataUtil = {}
	for i = 1,4,1 do 
		G_Push.DataUtil[i] = SDATETIME:new( )
	end
end

--Schedule ----------------------
G_Push.ScheduleRec = {}

--ȡǰϵͳʱ
function G_Push:SaveCurTime( )
	local tCurTime =  SGetTime( )
	local tCurData = G_Push.DataUtil[1]
	SToDataTime( tCurTime, tCurData )
end

function G_Push:SaveSpecTime( uTime )
	local tCurData = G_Push.DataUtil[1]
	SToDataTime( uTime, tCurData )
end

--ȡ
function G_Push:GetYear( uTime  )
	G_Push:SaveSpecTime( uTime )
	return G_Push.DataUtil[1].Year
end

--ȡ
function G_Push:GetMonth( uTime )
	G_Push:SaveSpecTime( uTime )
	return G_Push.DataUtil[1].Month
end

--ȡ
function G_Push:GetDay( uTime )
	G_Push:SaveSpecTime( uTime )
	return G_Push.DataUtil[1].Day
end

--ȡܼ
function G_Push:GetWeekDay( uTime )
	G_Push:SaveSpecTime( uTime )
	return G_Push.DataUtil[1].WeekDay
end

--ȡСʱ
function G_Push:GetHour( uTime )
	G_Push:SaveSpecTime( uTime )
	return G_Push.DataUtil[1].Hour
end

--ȡ
function G_Push:GetMinute( uTime )
	G_Push:SaveSpecTime( uTime )
	return G_Push.DataUtil[1].Minute
end

--ȡ
function G_Push:GetSecond( uTime )
	G_Push:SaveSpecTime( uTime )
	return G_Push.DataUtil[1].Second
end


--Fireout------------------------------------------------
--ȷдִУĳЩϴlogᵼ崻
G_Push:TimeStartup( G_Push.defBreatheInterval )

