--简单DOM解析器
document={}
document["DATA"]=""
document.getVersion=function()
  local ver="1.2"
  print(ver)
  return ver
end
document.luaTypeEscape=function(content)
  if content:find("^%d+$") then
    content=tonumber(content)
  end
  if content=="true" then
    content=true
  end
  if content=="false" then
    content=false
  end
  return content
end
document.htmlEscape=function(content)
  local content=content:gsub("amp;","") or content;
  local content=content:gsub("&nbsp;"," ") or content;
  local content=content:gsub("&lt;","<") or content;
  local content=content:gsub("&gt;",">") or content;
  local content=content:gsub("&amp;","&") or content;
  local content=content:gsub("&quot;",'"') or content;
  local content=content:gsub("&#39;","'") or content;
  local content=content:gsub("&#47","/") or content;
  local content=content:gsub("#x27","\\") or content;
  local content=content:gsub("&#x60","`") or content;
  local content=content:gsub("&copy","©") or content;
  return content
end
document.help=function()
  local help=[[
这个是一个用于简单解析HTML样式的库，只支持简单HTML的DOM获取(复杂的不支持，即嵌套语法和转义语法不支持)，一般用于简单dom一些自定义标签的内容获取。目的是优雅得获取数据。数据会默认转义数字和布尔值。
引入：import"SimpleDocument"
首先设置数据：document.setData(字符串数据)
如果数据存在需要html转义的，可以通过：document.htmlEscape(字符串数据)转义
获取<标签名>xxx</标签名>形式的内容：document.getElementsByTagName(标签名)
获取【标签名】xxx【标签名】形式的内容：document.getElementsByChineseBracketsName(标签名)
获取【标签名：xxx】形式的内容：document.getElementsByChineseBracketsVer2Name(标签名)
获取<标签名 id="xx">xxx</标签名>形式的内容：document.getElementsById(ID名)
获取<标签名 class="xx">xxx</标签名>形式的内容(支持其中一个参数符合就可以)：document.getElementsByClassName(class名)
获取<标签名 style="xx">xxx</标签名>形式的内容(支持其中一个参数符合就可以)：document.getElementsByStyleName(style名)
获取<标签名 x="xx">xxx</标签名>形式的内容：document.getElementsByAttr(attr_key,attr_value)
解析标签(Tag 标签内容,TagType 标签始末属性,TagName 标签名,attrString attr原字符串,attr attr数据表)：document.parseTag(字符串，不填写默认使用document.setData的数据)
这个设计目的是为了轻量级使用解析设计的，如果你要专业解析，请使用java库：Rhino(1.27mb)
]]
  print(help)
  return help
end
document.setData=function(s)
  document["DATA"]=s
end
document.getElementsByTagName=function(TAG)
  local 表={}
  local __S,n
  __S=document["DATA"]:gmatch("< ?"..TAG..".->(.-)</ ?"..TAG..".->")
  for v in __S do
    n=#表+1
    表[n]={}
    v=document.luaTypeEscape(v)
    表[n]=v
  end
  return 表
end
document.getElementsByChineseBracketsName=function(TAG)
  local 表={}
  local __S,n
  __S=document["DATA"]:gmatch("【 ?"..TAG.." ?】(.-)【 ?"..TAG.." ?】")
  for v in __S do
    n=#表+1
    表[n]={}
    v=document.luaTypeEscape(v)
    表[n]=v
  end
  return 表
end
document.getElementsByChineseBracketsVer2Name=function(TAG)
  local 表={}
  local __S,n
  __S=document["DATA"]:gmatch("【 ?"..TAG.." ?：(.-)】")
  for v in __S do
    n=#表+1
    表[n]={}
    v=document.luaTypeEscape(v)
    表[n]=v
  end
  return 表
end
document.getElementsById=function(id)
  local 表={}
  local __S,n
  __S=document["DATA"]:gmatch("<.- ?id=[\"']?"..id.."[\"']?.->(.-)</.->")
  for v in __S do
    n=#表+1
    表[n]={}
    v=document.luaTypeEscape(v)
    表[n]=v
  end
  return 表
end
document.getElementsByClassName=function(class)
  local 表={}
  local __S,n
  __S=document["DATA"]:gmatch("<.- ?class=[\"']?.- ?"..class.." ?.-[\"']?.->(.-)</.->")
  for v in __S do
    n=#表+1
    表[n]={}
    v=document.luaTypeEscape(v)
    表[n]=v
  end
  return 表
end
document.getElementsByStyleName=function(style)
  local 表={}
  local __S,n
  __S=document["DATA"]:gmatch("<.- ?style=[\"']?.- ?"..style.." ?.-[\"']?.->(.-)</.->")
  for v in __S do
    n=#表+1
    表[n]={}
    v=document.luaTypeEscape(v)
    表[n]=v
  end
  return 表
end
document.getElementsByAttr=function(attr,v)
  local 表={}
  local __S,n
  __S=document["DATA"]:gmatch("<.- ?"..attr.."=[\"']?"..v.."[\"']?.->(.-)</.->")
  for v in __S do
    n=#表+1
    表[n]={}
    v=document.luaTypeEscape(v)
    表[n]=v
  end
  return 表
end
document.parseTag=function(str)--标签解析
  if not str then
    str=document["DATA"]
  end
  local 表,tmp_表_1,tmp_数据迭代器_2={},{},{}
  local 数据="<"..str:match("<(.+)>")..">"
  local tmp_数据=数据
  local tmp_数据迭代器_1,n,tag
  tmp_数据迭代器_1=tmp_数据:gmatch("<(.-)>")
  for v in tmp_数据迭代器_1 do
    n=#tmp_表_1+1
    tmp_表_1[n]={}
    tmp_表_1[n]["Tag"]=v
    --是否是开始或者结束
    if v:find("^/") then
      tmp_表_1[n]["TagType"]="end"
     else
      if v:find(" /$") then
        tmp_表_1[n]["TagType"]="start|end"
       elseif v:find("^!--") then
        tmp_表_1[n]["TagType"]="notes"
       elseif v:find("^!") then
        tmp_表_1[n]["TagType"]="DOCTYPE"
       else
        tmp_表_1[n]["TagType"]="start"
      end
    end
    --标签名判断
    if v:find(" ") then
      local tag=v:match("/?(.-) .+")
      if tag=="" then
        tmp_表_1[n]["TagName"]=v:match(" +(.-) .+")
       else
        tmp_表_1[n]["TagName"]=tag
      end
     elseif tmp_表_1[n]["TagType"]=="end" then
      tmp_表_1[n]["TagName"]=v:sub(2)
     else
      tmp_表_1[n]["TagName"]=v
    end
    --attr内容字符串
    if tmp_表_1[n]["TagType"]=="notes" or tmp_表_1[n]["TagType"]=="DOCTYPE" or tmp_表_1[n]["TagType"]=="end" then
      --注释，DOCTYPE，/结尾标签你就别知道是啥了。我懒得处理了。
     elseif tmp_表_1[n]["TagType"]=="start|end" then
      tmp_表_1[n]["attrString"]=v:match(tmp_表_1[n]["TagName"].." ?(.+)/")
     else--tmp_表_1[n]["TagType"]="start"
      tmp_表_1[n]["attrString"]=v:match(tmp_表_1[n]["TagName"].." ?(.+)")
    end
    --attr解析
    if tmp_表_1[n]["attrString"] then
      tmp_表_1[n]["attr"]={}
      tmp_数据迭代器_2=tostring(tmp_表_1[n]["attrString"].." "):gmatch("(.-) ")
      for v2 in tmp_数据迭代器_2 do
        local key=v2:match("(.-)=") or ""
        local value=v2:match(".-=(.+)") or ""
        if key~="" and value~="" then
          if value:find("^[\"']") then
            tmp_表_1[n]["attr"][key]=document.luaTypeEscape(value:gsub([["']],""))
           else
            tmp_表_1[n]["attr"][key]=document.luaTypeEscape(value)
          end
        end
      end
    end
  end
  表=tmp_表_1
  return 表
end
