﻿/**
 * 拼接完整路径
 */
function populateUrl(URL)
{
    if(URL && URL.indexOf("http") != 0)
    {
        return document.location.protocol + '//' + document.location.host + URL;
    }
    else
    {
        return URL;
    }
}

/**
 * 转义jsonvalue中的反斜杠和单引号 
 */
function  escapeJsonValue(value)
{
    value = value.toString();
    value = value.replace(/\\/g, '\\\\');
    return value.replace(/\"/g, '\\"');
}

/**
 * 将一个object生成jsonstring 
 */
function toJsonString(obj)
{
    var jsonArray = [];
    for ( var i in obj)
    {
        jsonArray.push(i.toString() + ":" + "\"" + escapeJsonValue(obj[i]) + "\"");
    }
    return "{" + jsonArray.join(",") + "}";
}

/* ==========B2C方法========== */

/* 2.1.1 登录 */
function authenticate(successAction, background, token)
{
    var action = 'authenticate';
    var jsonStr = null;
    if (successAction.indexOf('javascript:') != 0)
    {
        successAction = populateUrl(successAction);
    }
    /* 以下为连接字符串，用本方法传进来的两个参数拼接jsonStr */
    if (successAction != null)
    {
        jsonStr = '{"successAction":"' + successAction;
    }
    if (background != null)
    {
        if (jsonStr != null)
        {
            jsonStr = jsonStr + '", "background":"' + background;
        }
        else
        {
            jsonStr = '{"background":"' + background;
        }
    }

    if (jsonStr != null)
    {
        jsonStr += '"}';
    }

    cmread.callBackClient(action, jsonStr, token);
}

/* 2.1.2 频道跳转 */
function jumpCatalog(jumpURL, ChannelID, CatalogID, token)
{
    if (jumpURL == null)
    {
        alert('第一个参数是必填参数');
        return;
    }

    if (ChannelID == null)
    {
        alert('第二个参数是必填参数');
        return;
    }

    var action = 'jumpCatalog';
    var jsonStr = null;
    jumpURL = populateUrl(jumpURL);

    /* 以下为连接字符串，用本方法传进来的两个参数拼接jsonStr */
    jsonStr = '{"jumpURL":"' + jumpURL + '", "ChannelID":"' + ChannelID;

    if (CatalogID != null)
    {
        jsonStr = jsonStr + '", "CatalogID":"' + CatalogID;
    }

    jsonStr += '"}';

    cmread.callBackClient(action, jsonStr, token);
}

/* 2.1.3 下载 */
function downloadContent(URL, contentID, contentType, contentName, chapterID,
        chapterName, chargeMode, bigLogo, authorName, speakerName, description, token)
{
    if (URL == null)
    {
        alert('第一个参数是必填参数');
        return;
    }

    if (contentID == null)
    {
        alert('第二个参数是必填参数');
        return;
    }

    if (contentType == null)
    {
        alert('第三个参数是必填参数');
        return;
    }

    if (contentName == null)
    {
        alert('第四个参数是必填参数');
        return;
    }
    if (chargeMode == null)
    {
        alert('第七个参数是必填参数');
        return;
    }
    if (bigLogo == null)
    {
        alert('第八个参数是必填参数');
        return;
    }
    var action = 'download';
    var jsonStr = null;
    URL = populateUrl(URL);
    bigLogo = populateUrl(bigLogo);

    /* 以下为连接字符串，用本方法传进来的两个参数拼接jsonStr */
    jsonStr = '{"URL":"' + URL + '", "contentID":"' + contentID
            + '", "contentType":"' + contentType + '", "contentName":"'
            + contentName + '", "chargeMode":"' + chargeMode + '", "bigLogo":"'
            + bigLogo;

    if (chapterID != null)
    {
        jsonStr = jsonStr + '", "chapterID":"' + chapterID;
    }
    if (chapterName != null)
    {
        jsonStr = jsonStr + '", "chapterName":"' + chapterName;
    }
    if (authorName != null)
    {
        jsonStr = jsonStr + '", "authorName":"' + authorName;
    }
    if (speakerName != null)
    {
        jsonStr = jsonStr + '", "speakerName":"' + speakerName;
    }
    if (description != null)
    {
        jsonStr = jsonStr + '", "description":"' + description;
    }
    jsonStr += '"}';

    cmread.callBackClient(action, jsonStr, token);
}

/* 2.1.4 关闭页面 */
function closePage(token)
{
    var action = 'closePage';
    var jsonStr = '{}';

    cmread.callBackClient(action, jsonStr, token);
}

/* 2.1.5 后退 */
function goBack(token)
{
    var action = 'goBack';
    var jsonStr = '{"close": true}';

    cmread.callBackClient(action, jsonStr, token);
}

/* 2.1.6 刷新 */
function viewRefresh(token)
{
    var action = 'viewRefresh';
    var jsonStr = '{}';
    cmread.callBackClient(action, jsonStr, token);
}

/* 2.1.7 弹出Toast */
function notifyResultToast(responseInfo, closeSelf, token)
{
    if (responseInfo == null)
    {
        alert('第一个参数是必填参数');
        return;
    }

    var action = 'notifyResultToast';
    /* 以下为连接字符串，用本方法传进来的两个参数拼接jsonStr */
    var jsonStr = '{"responseInfo":"' + responseInfo;
    if (closeSelf != null)
    {
        jsonStr = jsonStr + '", "closeSelf":"' + closeSelf + '"}';
    } else
    {
        jsonStr += '"}';
    }
    cmread.callBackClient(action, jsonStr, token);
}

/* 2.1.8 批量下载图书分册 */
function batchDownloadFascicle(contentID, contentName, chargeMode, bigLogo, authorName, token)
{
    if (contentID == null)
    {
        alert('第一个参数是必填参数');
        return;
    }
    if (contentName == null)
    {
        alert('第二个参数是必填参数');
        return;
    }
    if (chargeMode == null)
    {
        alert('第三个参数是必填参数');
        return;
    }
    if (bigLogo == null)
    {
        alert('第四个参数是必填参数');
        return;
    }
    var action = 'batchDownloadFascicle';
    var jsonStr = null;
    bigLogo = populateUrl(bigLogo);

    /* 以下为连接字符串，用本方法传进来的两个参数拼接jsonStr */
    jsonStr = '{"contentID":"' + contentID + '", "contentName":"' + contentName 
            + '", "chargeMode":"' + chargeMode + '", "bigLogo":"' + bigLogo;

    if (authorName != null)
    {
        jsonStr = jsonStr + '", "authorName":"' + authorName;
    }
    jsonStr += '"}';

    cmread.callBackClient(action, jsonStr, token);
}

/* 2.1.9 注销 */
function logout(token)
{
    var action = 'logout';
    var jsonStr = '{}';

    cmread.callBackClient(action, jsonStr, token);
}


/* 2.1.11 B页面应用防火墙 */
function startIEForDownload(jumpURL, token)
{
    if (jumpURL == null)
    {
        alert('第一个参数是必填参数');
        return;
    }

    var action = 'startIEForDownload';
    var jsonStr = null;
    jumpURL = populateUrl(jumpURL);

    jsonStr = '{"URL":"' + jumpURL + '"}';

    cmread.callBackClient(action, jsonStr, token);
}

/* 2.1.14 加入书架*/
function addToBookshelf(contentType, contentID, contentName, bigLogo, chapterID, chapterName, token)
{
	if(contentType == null){
	 	alert('contentType是必填参数');
        return;
	}
	
	if (contentID == null)
    {
        alert('contentID是必填参数');
        return;
    }
	
	 if (contentName == null)
    {
        alert('contentName是必填参数');
        return;
    }
	
	if (chapterID == null)
	{
		alert('chapterID是必填参数');
        return;
	}
	
	var action = 'addToBookshelf';
    var jsonStr = null;
	
	 jsonStr = '{"contentType":"' + contentType;
			
	 jsonStr = jsonStr + '", "contentID":"' + contentID;
			
			
	 jsonStr = jsonStr + '", "contentName":"' + contentName;
	 
	 if (bigLogo != null)
    {
        jsonStr = jsonStr + '", "bigLogo":"' + bigLogo;
    }
    
     jsonStr = jsonStr + '", "chapterID":"' + chapterID;
     
     if(chapterName !=null){
     	jsonStr = jsonStr + '", "chapterName":"' + chapterName;
     }
	
	 jsonStr += '"}';
	
	 cmread.callBackClient(action, jsonStr, token);

}

/* 2.1.15 分享*/
function shareContent(title, URL, bigLogo, description, type, token)
{
	if(title == null){
	 	alert('title是必填参数');
        return;
	}
	
	if (URL == null)
    {
        alert('URL是必填参数');
        return;
    }
	
	if (description == null)
	{
		alert('description是必填参数');
        return;
	}
	
	if (type == null)
	{
		alert('type是必填参数');
        return;
	}
	
	var action = 'shareContent';
    var jsonStr = null;
	
	 jsonStr = '{"title":"' + title;
			
	 jsonStr = jsonStr + '", "URL":"' + URL;
			
	if (bigLogo != null)
    {
        jsonStr = jsonStr + '", "bigLogo":"' + bigLogo;
    }
			
	 jsonStr = jsonStr + '", "description":"' + description;
	 
	
    
     jsonStr = jsonStr + '", "type":"' + type;
     
	
	 jsonStr += '"}';
	
	 cmread.callBackClient(action, jsonStr, token);
}

/* 2.2.1 启动阅读中国等页面 */
function startExPage(URL, token)
{
    if (URL == null)
    {
        alert('第一个参数是必填参数');
        return;
    }
    var action = 'startExPage';
    var jsonStr = null;
    if (URL != null)
    {
        jsonStr = '{"URL":"' + populateUrl(URL) + '"}';
    }
    
    cmread.callBackClient(action, jsonStr, token);
}

/* 2.2.2 启动绑定页面 */
function startBindPaymentNumber(token)
{
    var action = 'startBindPaymentNumber';
    var jsonStr = '{}';

    cmread.callBackClient(action, jsonStr, token);
}

/* 2.2.3 启动修改密码页面 */
function startChangePassword(token)
{
    var action = 'startChangePassword';
    var jsonStr = '{}';

    cmread.callBackClient(action, jsonStr, token);
}

/* 2.2.4 启动设置密保页面 */
function startSetSecurityQuestion(token)
{
    var action = 'startSetSecurityQuestion';
    var jsonStr = '{}';

    cmread.callBackClient(action, jsonStr, token);
}

/* 2.2.5 解除支付绑定 */
function startUnbindPaymentNumber(token)
{
    var action = 'startUnbindPaymentNumber';
    var jsonStr = '{}';

    cmread.callBackClient(action, jsonStr, token);
}

/* 2.2.6 启动摇一摇结果详情页 */
function startShakeResultDetailPage(URL, token)
{
    if (URL == null)
    {
        alert('第一个参数是必填参数');
        return;
    }
    var action = 'startShakeResultDetailPage';
    var jsonStr = null;
    if (URL != null)
    {
        jsonStr = '{"URL":"' + populateUrl(URL) + '"}';
    }
    
    cmread.callBackClient(action, jsonStr, token);
}

/* 3.2.2 启动个人笔记 */
function startUserNotes(token)
{
    var action = 'startUserNotes';
    var jsonStr = '{}';

    cmread.callBackClient(action, jsonStr, token);
}

/* 2.3.1启动图书/漫画/杂志/听书阅读页 */
function startCommonReader(contentID, chapterID, contentType, offset,
        contentName, bigLogo, token)
{
    if (contentID == null)
    {
        alert('第一个参数是必填参数');
        return;
    }
    if (chapterID == null)
    {
        alert('第二个参数是必填参数');
        return;
    }
    if (contentType == null)
    {
        alert('第三个参数是必填参数');
        return;
    }
    if (offset == null)
    {
        alert('第四个参数是必填参数');
        return;
    }
    if (contentName == null)
    {
        alert('第五个参数是必填参数');
        return;
    }
    if (bigLogo == null)
    {
        alert('第六个参数是必填参数');
        return;
    }
    bigLogo = populateUrl(bigLogo);
    var action = 'startCommonReader';
    var jsonStr = null;
    jsonStr = '{"contentID":"' + contentID + '","chapterID":"' + chapterID
            + '","contentType":"' + contentType + '","offset":"' + offset
            + '","contentName":"' + contentName + '","bigLogo":"' + bigLogo
            + '"}';
            
    cmread.callBackClient(action, jsonStr, token);
}

/* 2.3.2 启动目录页 */
function startChapterList(contentID, contentType, contentName, chargeMode, 
    bigLogo, authorName, speakerName, description, token)
{
    if (contentID == null)
    {
        alert('第一个参数是必填参数');
        return;
    }
    if (contentType == null)
    {
        alert('第二个参数是必填参数');
        return;
    }
    if (contentName == null)
    {
        alert('第三个参数是必填参数');
        return;
    }
    if (chargeMode == null)
    {
        alert('第四个参数是必填参数');
        return;
    }
    if (bigLogo == null)
    {
        alert('第五个参数是必填参数');
        return;
    }
    var action = 'startChapterList';
    var jsonStr = null;
    bigLogo = populateUrl(bigLogo);

    /* 以下为连接字符串，用本方法传进来的两个参数拼接jsonStr */
    jsonStr = '{"contentID":"' + contentID
            + '", "contentType":"' + contentType + '", "contentName":"'
            + contentName + '", "chargeMode":"' + chargeMode + '", "bigLogo":"'
            + bigLogo;

    if (authorName != null)
    {
        jsonStr = jsonStr + '", "authorName":"' + authorName;
    }
    if (speakerName != null)
    {
        jsonStr = jsonStr + '", "speakerName":"' + speakerName;
    }
    if (description != null)
    {
        jsonStr = jsonStr + '", "description":"' + description;
    }
    jsonStr += '"}';

    cmread.callBackClient(action, jsonStr, token);
}

/* 2.4.1 设置会员专享封页 */
function setMemberOnlyCover(URL, token)
{
    if (URL == null)
    {
        alert('第一个参数是必填参数');
        return;
    }
    var action = 'setMemberOnlyCover';
    var jsonStr = null;
    if (URL != null)
    {
        jsonStr = '{"URL":"' + populateUrl(URL) + '"}';
    }
    
    cmread.callBackClient(action, jsonStr, token);
}

/* 2.4.1 启动摇一摇 */
function startShakepage (dURL, rURL, pURL, sURL,token){
    if (dURL == null)
    {
        alert('第一个参数是必填参数');
        return;
    }
    if (rURL == null)
    {
        alert('第二个参数是必填参数');
        return;
    }
    if (pURL == null)
    {
        alert('第三个参数是必填参数');
        return;
    }
    if (sURL == null)
    {
        alert('第四个参数是必填参数');
        return;
    }
    var action = 'startShakepage';
    var jsonStr = null;
    dURL = populateUrl(dURL);
    rURL = populateUrl(rURL);
    jsonStr = '{"dURL":"' + dURL + '", "rURL":"' + rURL + '", "pURL":"' + pURL + '", "sURL":"' + sURL;
    if (dURL != null)
    {
        jsonStr = jsonStr + '", "dURL":"' + dURL;
    }
    if (rURL != null)
    {
        jsonStr = jsonStr + '", "rURL":"' + rURL;
    }
    if (pURL != null)
    {
        jsonStr = jsonStr + '", "pURL":"' + pURL;
    }
    if (sURL != null)
    {
        jsonStr = jsonStr + '", "sURL":"' + sURL;
    }
    jsonStr += '"}';
    cmread.callBackClient(action, jsonStr, token);
} 

/* 关闭摇一摇结果框 */
function closeShakeResultDialog(token)
{
    var action = 'closeShakeResultDialog';
    var jsonStr = '{}';

    cmread.callBackClient(action, jsonStr, token);
}

/* 一键充值+订购或投票 */
function sendSMSForChargeAck(receiver, content, token)
{
    if (receiver == null)
    {
        alert('第一个参数是必填参数');
        return;
    }
    if (content == null)
    {
        alert('第二个参数是必填参数');
        return;
    }
    var action = 'sendSMSForChargeAck';
    var jsonStr = null;
    jsonStr = '{"receiver":"' + receiver+ '", "content":"' + content + '"}';
    cmread.callBackClient(action, jsonStr, token);
}

/* 启动语音搜索 */
function startVoiceSearchpage (URL, token){
    var action = 'startVoiceSearchpage';
    jsonStr = '{}';
    if (URL != null) 
    {
        jsonStr = '{"URL":"' + populateUrl(URL) + '"}';
    }
    
    cmread.callBackClient(action, jsonStr, token);
} 

/* 一键充值+订购或投票 */
function continueTasksAfterCharge(token)
{
    var action = 'continueTasksAfterCharge';
    var jsonStr = '{}';

    cmread.callBackClient(action, jsonStr, token);
}

/* shijing for the third part login*/
function startTpLogin(tokenid1)
{
    var action = 'startTpLogin';
    var jsonStr = '{}';

    cmread.callBackClient(action, jsonStr, tokenid1);
}

/* 启动二级页面 */
function startSimplePage(URL, token)
{
    if (URL == null)
    {
        alert('第一个参数是必填参数');
        return;
    }
    var action = 'startSimplePage';
    var jsonStr = null;
    if (URL != null)
    {
        jsonStr = '{"URL":"' + populateUrl(URL) + '"}';
    }
    
    cmread.callBackClient(action, jsonStr, token);
}


/* 启动充值页*/
function startRechargePage(URL, token)
{
    if (URL == null)
    {
        alert('第一个参数是必填参数');
        return;
    }
    
    var action = 'startRechargePage';
    var jsonStr = null;
    if (URL != null)
    {
        jsonStr = '{"URL":"' + populateUrl(URL) + '"}';
    }
    
    cmread.callBackClient(action, jsonStr, token);
}

/* 关闭充值页并刷新启充值页之前的页面--个人中心或包月详情页*/
function closeRechargePage(fsrc, token)
{
    if (fsrc == null)
    {
        alert('第一个参数是必填参数，个人中心传--0，包月详情页传--2');
        return;
    }
    var action = 'closeRechargePage';
    var jsonStr = null;
    jsonStr = '{"fsrc":"' + fsrc + '"}';
    cmread.callBackClient(action, jsonStr, token);
}

/* recommend this client application */
function startRecommendApp(token)
{
    var action = 'startRecommendApp';
    var jsonStr = '{}';

    cmread.callBackClient(action, jsonStr, token);
}

/* start RecentlyReadMoreActivity */
function startRecentlyReadMoreActivity(token)
{
    var action = 'startRecentlyReadMoreActivity';
    var jsonStr = '{}';

    cmread.callBackClient(action, jsonStr, token);
}

/* 客户端增加短信发送能力发送通用短信*/
function sendCommonSMS(receiver, content, token)
{
    if (receiver == null)
    {
        alert('第一个参数是必填参数');
        return;
    }
    if (content == null)
    {
        alert('第二个参数是必填参数');
        return;
    }
    var action = 'sendCommonSMS';
    var jsonStr = null;
    jsonStr = '{"receiver":"' + receiver+ '", "content":"' + content + '"}';
    cmread.callBackClient(action, jsonStr, token);
}


    

