/* 编辑时屏蔽警告用，使用时需注掉 */
//function $(t, k){}
//var cmread = {};
var token = null;
    
/**
 * 动态加载样式表文件
 */
function addStyle(url)
{
    var _head = document.getElementsByTagName("head")[0];
    var _link = document.createElement("link");
    _link.rel = "stylesheet";
    _link.media = "screen and (-webkit-device-pixel-ratio:"
        + window.devicePixelRatio + ")";
    _link.type = "text/css";
    _link.href = url;
    _head.appendChild(_link);
}

/**
 * 相对路径to绝对路径
 */
function populateUrl(URL)
{
    return document.location.protocol + '//' + document.location.host + URL;
}

/**
 * 切换视频清晰度选项
 */
function changeRadio(videoId, a, b)
{
    for ( var i = 1; i < b; i++)
    {
        if (i == a)
        {
            document.getElementById(videoId + "radio_" + i).className = "checked";
        } else
        {
            document.getElementById(videoId + "radio_" + i).className = "";
        }
    }
}

/**
 * 切换不同清晰度视频URL
 */
function changeUrl(videoId, url)
{
    document.getElementById(videoId).href = "javascript:startNewsVideoPlayer('"
            + url + "',token)";
}
    
/* ==========B2C方法========== */
/**
 * 调用Client方法进入或退出缩放模式(B2C)
 */
function zoom(isZoom)
{
    var action = isZoom ? "zoom" : "noZoom";
    var jsonStr = '{}';
    cmread.callBackClient(action, jsonStr, null);
}

/**
 * 调用Clinet方法进行后退(B2C)
 */
function goBack(token)
{
    var action = 'goBack';
    var jsonStr = '{"close": true}';
    cmread.callBackClient(action, jsonStr, token);
}

/**
 * 启动视频播放页(B2C)
 */
function startVideoPlayer(URL, token)
{
    if (URL == null)
    {
        alert('第一个参数是必填参数');
        return;
    }
    /* URL = populateUrl(URL); */
    var action = 'startVideoPlayer';
    var isLocal = 'yes';
    var jsonStr = '{"URL":"' + URL;
    jsonStr = jsonStr + '", "isLocal":"' + isLocal;
    jsonStr += '"}';

    cmread.callBackClient(action, jsonStr, token);
}

/**
 * 启动读图页面(本地阅读专用)(B2C)
 */
function startLocalPicReader(imgSource, token, isLocal)
{
	//alert(imgSource);
    if (imgSource == null)
    {
        alert('第一个参数是必填参数');
        return;
    }
    var action = 'startPicReader';
    var jsonStr = null;

    /* 以下为连接字符串，用本方法传进来的两个参数拼接jsonStr */
    jsonStr = '{"source":"' + imgSource;
    if (true != null)
    {
        jsonStr = jsonStr + '", "isLocal":"' + isLocal;
    }
    jsonStr += '"}';
    cmread.callBackClient(action, jsonStr, token);
}


/* ==========C2B方法========== */
/**
 * 新闻阅读页字体大小设置(C2B)
 */
function setFontLevel(token, level)
{
	var fonts = [14, 16, 18, 20, 22];
	$(".read_text").css("font-size", fonts[level - 1] + "px");
}

/**
 * 前一张图（C2B）
 */
function prevPicture(token)
{
    currentImg = Math.max(currentImg - 1, 0);
    if (currentImg >= 0)
    {
        scrollImages(IMG_WIDTH * currentImg, speed);
    }
    checkImg();
}

/**
 * 后一张图（C2B）
 */
function nextPicture(token)
{
    currentImg = Math.min(currentImg + 1, maxImages - 1);
    if (currentImg >= 0)
    {
        scrollImages(IMG_WIDTH * currentImg, speed);
    }
    checkImg();
}

/* ==========图集页滑动及缩放========== */
/* 当前图片索引 */
var currentImg = 0;
/* 图片滚动速度（毫秒） */
var speed = 500;
/* 图集页图片对象 */
var imgsD;

$(function()
{
    imgsD = $("#imgs_tj");
});

/**
 * 检测是否到达第一张或最后一张图片
 */
function checkImg()
{
    if (currentImg == 0)
    {
        var jsonstr = '{"responseInfo": "到达第一张图片", "closeSelf" : "false"}';
        cmread.callBackClient("notifyResultToast", jsonstr, null);
    } else if (currentImg == maxImages - 1)
    {
        var jsonstr = '{"responseInfo": "到达最后一张图片", "closeSelf" : "false"}';
        cmread.callBackClient("notifyResultToast", jsonstr, null);
    }
}

/**
 * 切换图片
 */
function scrollImages(distance, duration)
{
    /* 切换速度 */
    imgsD.css("-webkit-transition-duration", (duration / 1000).toFixed(1) + "s");
    /* 切换方向 */
    var value = (distance < 0 ? "" : "-") + Math.abs(distance).toString();
    imgsD.css("-webkit-transform", "translate3d(" + value + "px,0px,0px)");
    /* 预加载下一张图，如果向前滑可能属于重复加载 */
    if ($("img[name='ImgUrlStr']"))
    {
        var imgS = $("img[name='ImgUrlStr']", ".nav_content_list");
        imgS.eq(currentImg + 1).attr("src", imgS.eq(currentImg + 1).attr("data-src"));
    }
}

/**
 * 设置浏览器页面是否允许缩放
 */
function allowZoom(isZoom)
{
    var viewport = document.querySelector("meta[name=viewport]");
    if (isZoom)
    {
        /* 允许缩放1-5倍 */
        viewport.setAttribute('content', 'width=device-width, initial-scale=1.0, minimum-scale=1.0, maximum-scale=5.0, user-scalable=yes');
    } else
    {
        /* 禁止缩放 */
        viewport.setAttribute('content', 'width=device-width, initial-scale=1.0, minimum-scale=1.0, maximum-scale=1.0, user-scalable=yes');
    }
    $('img')[currentImg].src = $('img')[currentImg].src;
}

/**
 * 启动或退出缩放模式
 */
function toggleZoom()
{
    if ($(".viewpicback").css("display") != "none")
    {
        /* 启动缩放模式，隐藏其他信息 */    
        $(".viewpicback").hide();
        $(".pictitle").hide();
        $(".picinfo").hide();
        zoom(true)
        allowZoom(true);
    }
    else
    {
        /* 退出缩放模式，显示其他信息 */    
        zoom(false)
        allowZoom(false);
        $(".viewpicback").show();
        $(".pictitle").show();
        $(".picinfo").show();
    }
}

/* 页面加载时更新样式表 */
var _pixel = window.devicePixelRatio;
if (_pixel >= 2)
{
    addStyle("css/style360.css");
} else
{
    addStyle("css/style320.css");
}

/* 2.3.2 启动新闻正文阅读页 */
function startNewsReader(URL, contentId, shareUrl, picUrl, sr, idNames, idValues,
nextNewsURL, token)
{
if (URL == null)
{
alert('第一个参数是必填参数');
return;
}
if (contentId == null)
{
alert('第二个参数是必填参数');
return;
}
 
var action = 'startNewsReader';
var jsonStr = null;
//URL = populateUrl(URL);
 
/* 以下为连接字符串，用本方法传进来的两个参数拼接jsonStr */
var jsonStr = '{"URL":"' + URL + '", "contentId":"' + contentId + '", "shareUrl":"' + shareUrl
+ '", "picUrl":"' + picUrl + '", "nextNewsURL":"' + nextNewsURL
+ '", "sr":"' + sr;// + '", "idName":"' + idName+ '", "idValue":"'
 
jsonStr += '", "ids":"';
for ( var i = 0; i < idNames.length; i++)
{
jsonStr += '&' + idNames[i] + '=' + idValues[i];
}
jsonStr += '"}';
 
cmread.callBackClient(action, jsonStr, token);
}

/**
 * 页面初始化完毕事件
 */

/*
	if(document.getElementById("con") != null)
	{
   	   var con = document.getElementById("con").innerHTML;
	}
	else
	{
	   var con = "暂无内容,请阅览其他章节."
	}*/
/*新闻内容*/
function f_getNewsContent()
{
	var con = "";
    if($(".read_text") != null){
	 $(".read_text").each(function(){
         con = con + $(this).text();
       });
      con = con.replace(/\s/g,"");
     }
    if(con == ""){
       con = "暂无内容,请阅览其他章节.";
    }
    window.mnpaper.getNewsContent(con);
}

/**
 * 启动新视频播放页(B2C)
 */
function startNewsVideoPlayer(URL, token)
{
    if (URL == null)
    {
        alert('第一个参数是必填参数');
        return;
    }
   
    var action = 'startNewsVideoPlayer';
    var isLocal = 'yes';
    var jsonStr = '{"URL":"' + URL;
    jsonStr = jsonStr + '", "isLocal":"' + isLocal;
    jsonStr += '"}';

    cmread.callBackClient(action, jsonStr, token);
}

