/*!
 * relationship.js v1.2.7
 * Chinese kinship library
 * https://passer-by.com/relationship/
 *
 * Copyright (c) 2016-present, HaoLe Zheng
 *
 * Released under the MIT License
 * https://github.com/mumuy/relationship
 *
 * Created on: 2025-06-30
 */
! function(s, f) {
	"object" == typeof exports && "undefined" != typeof module ? module.exports = f() : "function" == typeof define &&
		define.amd ? define(f) : (s = "undefined" != typeof globalThis ? globalThis : s || self).relationship = f()
}(this, (function() {
	"use strict";

	function s(s, f) {
		(null == f || f > s.length) && (f = s.length);
		for (var x = 0, d = Array(f); x < f; x++) d[x] = s[x];
		return d
	}

	function f(f, x) {
		if (f) {
			if ("string" == typeof f) return s(f, x);
			var d = {}.toString.call(f).slice(8, -1);
			return "Object" === d && f.constructor && (d = f.constructor.name), "Map" === d || "Set" === d ?
				Array.from(f) : "Arguments" === d || /^(?:Ui|I)nt(?:8|16|32)(?:Clamped)?Array$/.test(d) ? s(f,
					x) : void 0
		}
	}

	function x(x) {
		return function(f) {
			if (Array.isArray(f)) return s(f)
		}(x) || function(s) {
			if ("undefined" != typeof Symbol && null != s[Symbol.iterator] || null != s["@@iterator"])
				return Array.from(s)
		}(x) || f(x) || function() {
			throw new TypeError(
				"Invalid attempt to spread non-iterable instance.\nIn order to be iterable, non-array objects must have a [Symbol.iterator]() method."
				)
		}()
	}
	var d = [{
		exp: /^(\S+?)(应该|得)?(称呼|叫|喊)(\S+?)(什么|啥)？?$/,
		opt: function(s) {
			return {
				text: s[4],
				target: s[1]
			}
		}
	}, {
		exp: /^(\S+?)(应该|得)?(如何|怎么)(称呼|叫|喊)(\S+?)？?$/,
		opt: function(s) {
			return {
				text: s[5],
				target: s[1]
			}
		}
	}, {
		exp: /^(\S+?)是(\S+?)的(谁|什么|什么亲戚|啥亲戚|什么人)？?$/,
		opt: function(s) {
			return {
				text: s[1],
				target: s[2],
				type: s[1].includes("的") ? "default" : "chain"
			}
		}
	}, {
		exp: /^(\S+?)(应该|得)?管(\S+?)叫(什么|啥)？?$/,
		opt: function(s) {
			return {
				text: s[3],
				target: s[1]
			}
		}
	}, {
		exp: /^(\S+?)(和|与)(\S+?)(之间)?是(什么|啥)关系？?$/,
		opt: function(s) {
			return {
				text: s[1],
				target: s[3],
				type: "pair"
			}
		}
	}, {
		exp: /^(\S+?)对于(\S+?)是(什么|啥)关系？?$/,
		opt: function(s) {
			return {
				text: s[1],
				target: s[2],
				type: "chain"
			}
		}
	}, {
		exp: /^(\S+?)(指的)?是(什么|啥)(意思|关系|亲戚关系|辈分|人)？?$/,
		opt: function(s) {
			return {
				text: s[1],
				type: "chain"
			}
		}
	}, {
		exp: /^(\S+?)(应该|得)?(称呼|叫|喊)(什么|啥)？?$/,
		opt: function(s) {
			return {
				text: s[1]
			}
		}
	}, {
		exp: /^(\S+?)(应该|得)?(如何|怎么)(称呼|叫|喊)？?$/,
		opt: function(s) {
			return {
				text: s[1]
			}
		}
	}, {
		exp: /^(\S+?)是(谁|什么|什么亲戚|啥亲戚|什么人|什么辈分|啥辈分)？?$/,
		opt: function(s) {
			return {
				text: s[1],
				type: s[1].includes("的") ? "default" : "chain"
			}
		}
	}];

	function r(s, f) {
		var x = "undefined" != typeof Symbol && s[Symbol.iterator] || s["@@iterator"];
		if (!x) {
			if (Array.isArray(s) || (x = function(s, f) {
					if (s) {
						if ("string" == typeof s) return m(s, f);
						var x = {}.toString.call(s).slice(8, -1);
						return "Object" === x && s.constructor && (x = s.constructor.name), "Map" === x ||
							"Set" === x ? Array.from(s) : "Arguments" === x ||
							/^(?:Ui|I)nt(?:8|16|32)(?:Clamped)?Array$/.test(x) ? m(s, f) : void 0
					}
				}(s)) || f && s && "number" == typeof s.length) {
				x && (s = x);
				var d = 0,
					r = function() {};
				return {
					s: r,
					n: function() {
						return d >= s.length ? {
							done: !0
						} : {
							done: !1,
							value: s[d++]
						}
					},
					e: function(s) {
						throw s
					},
					f: r
				}
			}
			throw new TypeError(
				"Invalid attempt to iterate non-iterable instance.\nIn order to be iterable, non-array objects must have a [Symbol.iterator]() method."
				)
		}
		var e, o = !0,
			t = !1;
		return {
			s: function() {
				x = x.call(s)
			},
			n: function() {
				var s = x.next();
				return o = s.done, s
			},
			e: function(s) {
				t = !0, e = s
			},
			f: function() {
				try {
					o || null == x.return || x.return()
				} finally {
					if (t) throw e
				}
			}
		}
	}

	function m(s, f) {
		(null == f || f > s.length) && (f = s.length);
		for (var x = 0, d = Array(f); x < f; x++) d[x] = s[x];
		return d
	}
	var e = [{
			exp: /^(.+)&o([^#]+)&l/g,
			str: "$1$2"
		}, {
			exp: /^(.+)&l([^#]+)&o/g,
			str: "$1$2"
		}, {
			exp: /^(.+)?,o([sb](&\d+)?)([^#]+)&l/g,
			str: "$1,x$2$4"
		}, {
			exp: /^(.+)?,l([sb](&\d+)?)([^#]+)&o/g,
			str: "$1,x$2$4"
		}, {
			exp: /(,o[sb](&\d+)?)+(,o[sb])(&\d+)?/,
			str: "$3$4"
		}, {
			exp: /(,l[sb](&\d+)?)+(,l[sb])(&\d+)?/,
			str: "$3$4"
		}, {
			exp: /^(.*,[fh1])(,[olx][sb](&\d+)?)+,[olx]b(.*)$/,
			str: "$1,xb$4#$1$4"
		}, {
			exp: /^(.*,[mw0])(,[olx][sb](&\d+)?)+,[olx]s(.*)$/,
			str: "$1,xs$4#$1$4"
		}, {
			exp: /(,[fh1])(,[olx][sb](&\d+)?)+,[olx]s/g,
			str: "$1,xs"
		}, {
			exp: /(,[mw0])(,[olx][sb](&\d+)?)+,[olx]b/g,
			str: "$1,xb"
		}, {
			exp: /^,[olx][sb](&\d+)?,[olx]b(.+)?$/,
			str: ",xb$2#$2"
		}, {
			exp: /^,[olx][sb](&\d+)?,[olx]s(.+)?$/,
			str: ",xs$2#$2"
		}, {
			exp: /^,x([sb])$/,
			str: ",o$1#,l$1"
		}, {
			exp: /m,h/g,
			str: "f"
		}, {
			exp: /f,w/g,
			str: "m"
		}, {
			exp: /,[xol][sb](&\d+)?(,[mf])/g,
			str: "$2"
		}, {
			exp: /,[mf],d(&\d+)/,
			str: ",xs$1"
		}, {
			exp: /,[mf],d&([ol])/,
			str: ",$1s"
		}, {
			exp: /,[mf],s(&\d+)/,
			str: ",xb$1"
		}, {
			exp: /,[mf],s&([ol])/,
			str: ",$1b"
		}, {
			exp: /^(.*,[fh1]|[xol]b(&\d+)?),[mf],s(.*)$/,
			str: "$1,xb$3#$1$3"
		}, {
			exp: /^(.*,[mw0]|[xol]s(&\d+)?),[mf],d(.*)$/,
			str: "$1,xs$3#$1$3"
		}, {
			exp: /(,[mw0]|[xol]s(&\d+)?),[mf],s/,
			str: "$1,xb"
		}, {
			exp: /(,[fh1]|[xol]b(&\d+)?),[mf],d/,
			str: "$1,xs"
		}, {
			exp: /^,[mf],s(.+)?$/,
			str: ",xb$1#,1$1"
		}, {
			exp: /^,[mf],d(.+)?$/,
			str: ",xs$1#,0$1"
		}, {
			exp: /,[ds](&[ol\d]+)?,[olx]b(&\d+)/g,
			str: ",s$2"
		}, {
			exp: /,[ds](&[ol\d]+)?,[olx]s(&\d+)/g,
			str: ",d$2"
		}, {
			exp: /,[ds]&o,ob/g,
			str: ",s&o"
		}, {
			exp: /,[ds]&o,os/g,
			str: ",d&o"
		}, {
			exp: /,[ds]&l,lb/g,
			str: ",s&l"
		}, {
			exp: /,[ds]&l,ls/g,
			str: ",d&l"
		}, {
			exp: /,[ds](&[ol\d]+)?,[olx]s(&\d+)?/g,
			str: ",d$2"
		}, {
			exp: /,[ds](&[ol\d]+)?,[olx]b(&\d+)?/g,
			str: ",s$2"
		}, {
			exp: /(,[mwd0]|,[olx]s)(&[ol\d]+)?,[ds](&[ol\d]+)?,m/g,
			str: "$1"
		}, {
			exp: /(,[mwd0]|,[olx]s)(&[ol\d]+)?,[ds](&[ol\d]+)?,f/g,
			str: "$1,h"
		}, {
			exp: /(,[fhs1]|,[olx]b)(&[ol\d]+)?,[ds](&[ol\d]+)?,f/g,
			str: "$1"
		}, {
			exp: /(,[fhs1]|,[olx]b)(&[ol\d]+)?,[ds](&[ol\d]+)?,m/g,
			str: "$1,w"
		}, {
			exp: /^,[ds],m(.+)?$/,
			str: ",w$1#$1"
		}, {
			exp: /^,[ds],f(.+)?$/,
			str: ",h$1#$1"
		}, {
			exp: /,[wh](,[ds])/g,
			str: "$1"
		}, {
			exp: /,w,h|,h,w/g,
			str: ""
		}, {
			exp: /(.+)?\[([^\|]+?)\|([^\[\]]*\|[^\[\]]*)\](.+)?/g,
			str: "$1$2$4#$1[$3]$4"
		}, {
			exp: /(.+)?\[([^\[\]\|]+?)\|([^\[\]\|]+?)?\](.+)?/g,
			str: "$1$2$4#$1$3$4"
		}],
		o = [{
			exp: /^从表/,
			arr: ["从父姑表", "从父舅表", "从父姨表", "从母姑表", "从母舅表", "从母叔表"]
		}, {
			exp: /^表表/,
			arr: ["姑表叔表", "姑表姑表", "姑表舅表", "姑表姨表", "舅表叔表", "舅表姑表", "舅表舅表", "舅表姨表"]
		}, {
			exp: /^([夫妻内外]?)表/,
			arr: ["$1姑表", "$1舅表"]
		}, {
			exp: /^([姑舅])表(?=[^伯叔])/,
			arr: ["$1表伯", "$1表叔"]
		}, {
			exp: /^姻/,
			arr: ["姑姻", "姨姻", "姊妹姻", "女姻"]
		}, {
			exp: /^眷/,
			arr: ["叔眷", "舅眷", "兄弟眷", "男眷"]
		}, {
			exp: /^亲家/,
			arr: ["姊妹姻", "兄弟眷"]
		}, {
			exp: /^([堂表姨]?)([曾高天烈太远鼻]?)(祖?)([伯叔姑舅姨])/,
			arr: ["$1$4$2$3"]
		}, {
			exp: /^([曾高天烈太远鼻]?)祖?王姑/,
			arr: ["姑$1祖母"]
		}, {
			exp: /^([曾玄元来晜仍云耳])([侄甥])/,
			arr: ["$2$1"]
		}, {
			exp: /^外表([伯叔姑舅姨])/,
			arr: ["姑表$1外", "舅表$1外"]
		}, {
			exp: /([堂表姨]?)外甥/,
			arr: ["$1甥"]
		}, {
			exp: /^([舅叔])([曾玄外]*)孙/,
			arr: ["$1侄$2孙"]
		}, {
			exp: /^([姨姑])([曾玄外]*)孙/,
			arr: ["$1甥$2孙"]
		}, {
			exp: /([孙甥侄])$/,
			arr: ["$1男", "$1女"]
		}, {
			exp: /([姑舅姨叔])([孙外]*)([男女])$/,
			arr: ["$1表侄$2$3", "$1表甥$2$3"]
		}, {
			exp: /(.+)父母$/,
			arr: ["$1父", "$1母"]
		}, {
			exp: /(.+)公婆$/,
			arr: ["$1公", "$1婆"]
		}, {
			exp: /祖$/,
			arr: ["祖父"]
		}, {
			exp: /(新妇|媳)$/,
			arr: ["媳妇"]
		}, {
			exp: /嫂$/,
			arr: ["兄妇"]
		}, {
			exp: /女儿$/,
			arr: ["女"]
		}],
		t = {
			"晜": "兄",
			"哥": "兄",
			"姐": "姊",
			"侄": "姪",
			"婿": "壻",
			"嬷": "嫲",
			"祖父": "王父",
			"祖母": "王母",
			"孙女婿": "孙婿",
			"甥女婿": "甥婿",
			"侄女婿": "侄婿",
			"孙媳妇": "孙妇",
			"甥媳妇": "甥妇",
			"侄媳妇": "侄妇",
			"弟媳妇": "弟妇"
		};

	function b(s, x) {
		return function(s) {
			if (Array.isArray(s)) return s
		}(s) || function(s, f) {
			var x = null == s ? null : "undefined" != typeof Symbol && s[Symbol.iterator] || s[
			"@@iterator"];
			if (null != x) {
				var d, r, m, e, o = [],
					t = !0,
					b = !1;
				try {
					if (m = (x = x.call(s)).next, 0 === f) {
						if (Object(x) !== x) return;
						t = !1
					} else
						for (; !(t = (d = m.call(x)).done) && (o.push(d.value), o.length !== f); t = !0);
				} catch (s) {
					b = !0, r = s
				} finally {
					try {
						if (!t && null != x.return && (e = x.return(), Object(e) !== e)) return
					} finally {
						if (b) throw r
					}
				}
				return o
			}
		}(s, x) || f(s, x) || function() {
			throw new TypeError(
				"Invalid attempt to destructure non-iterable instance.\nIn order to be iterable, non-array objects must have a [Symbol.iterator]() method."
				)
		}()
	}
	var l = ["", "一", "二", "三", "四", "五", "六", "七", "八", "九", "十"];

	function n(s) {
		return n = "function" == typeof Symbol && "symbol" == typeof Symbol.iterator ? function(s) {
			return typeof s
		} : function(s) {
			return s && "function" == typeof Symbol && s.constructor === Symbol && s !== Symbol.prototype ?
				"symbol" : typeof s
		}, n(s)
	}

	function h(s) {
		var f = function(s, f) {
			if ("object" != n(s) || !s) return s;
			var x = s[Symbol.toPrimitive];
			if (void 0 !== x) {
				var d = x.call(s, f || "default");
				if ("object" != n(d)) return d;
				throw new TypeError("@@toPrimitive must return a primitive value.")
			}
			return ("string" === f ? String : Number)(s)
		}(s, "string");
		return "symbol" == n(f) ? f : f + ""
	}

	function w(s, f, x) {
		return (f = h(f)) in s ? Object.defineProperty(s, f, {
			value: x,
			enumerable: !0,
			configurable: !0,
			writable: !0
		}) : s[f] = x, s
	}
	var M = {
			"f#s": ["父子"],
			"m#s": ["母子"],
			"f#d": ["父女"],
			"m#d": ["母女"],
			"h#w": ["夫妻"],
			"ob#lb": ["兄弟"],
			"ob#ls": ["兄妹"],
			"os#ls": ["姐妹"],
			"os#lb": ["姐弟"],
			"w,f#d,h": ["翁婿"],
			"w,m#d,h": ["母婿"],
			"h,f#s,w": ["翁媳"],
			"h,m#s,w": ["婆媳"],
			"f,[f|m]#s,[s|d]": ["祖孙"],
			"m,f#d,[s|d]": ["公孙"],
			"m,m#d,[s|d]": ["婆孙"],
			"f,[ob|ob,w]#[lb|h,lb],[s|d]": ["伯侄"],
			"f,lb#ob,[s|d]": ["叔侄"],
			"f,lb,w#h,ob,[s|d]": ["婶侄"],
			"f,[xs|xs,h]#[xb|w,xb],[s|d]": ["姑侄"],
			"m,[xb|xb,w]#[xs|h,xs],[s|d]": ["舅甥"],
			"m,[xs|xs,h]#[xs|w,xs],[s|d]": ["姨甥"],
			"f,xb,s&o#f,xb,s&l": ["堂兄弟"],
			"f,xb,s&o#f,xb,d&l": ["堂兄妹"],
			"f,xb,d&o#f,xb,s&l": ["堂姐弟"],
			"f,xb,d&o#f,xb,d&l": ["堂姐妹"],
			"f,xs,s&o#m,xb,s&l": ["表兄弟"],
			"m,xb,s&o#f,xs,s&l": ["表兄弟"],
			"f,xs,s&o#m,xb,d&l": ["表兄妹"],
			"m,xb,s&o#f,xs,d&l": ["表兄妹"],
			"f,xs,d&o#m,xb,d&l": ["表姐妹"],
			"m,xb,d&o#f,xs,d&l": ["表姐妹"],
			"f,xs,d&o#m,xb,s&l": ["表姐弟"],
			"m,xb,d&o#f,xs,s&l": ["表姐弟"],
			"m,xs,s&o#m,xs,s&l": ["姨兄弟"],
			"m,xs,s&o#m,xs,d&l": ["姨兄妹"],
			"m,xs,d&o#m,xs,s&l": ["姨姐弟"],
			"m,xs,d&o#m,xs,d&l": ["姨姐妹"],
			"h,ob,w#h,lb,w": ["妯娌"],
			"w,os,h#w,ls,h": ["连襟"],
			"w,os#ls,h": ["襟姐弟"],
			"w,ls#os,h": ["襟兄妹"],
			"xs,h#w,xb": ["郎舅"],
			"xs,h#w,xs": ["郎姨"],
			"lb,w#h,ob": ["伯媳"],
			"ob,w#h,lb": ["叔嫂"],
			"xb,w#h,xs": ["姑嫂"],
			"xs,h,xb#xb,w,xb": ["姻兄弟"],
			"d,h,[f|m]#s,w,[f|m]": ["儿女亲家"]
		},
		a = {
			"f,xb": ["几爸爸", "几爸", "几爹"],
			"f,xb,w": ["几妈妈", "几妈", "几娘"],
			"f,f,xb": ["几爷爷", "几大爷", "几嗲", "几爷", "几公"],
			"f,f,xb,w": ["几奶奶", "几大娘", "几奶", "几婆"],
			"m,f,xb": ["几外公", "几姥爷", "几外爷"],
			"m,f,xb,w": ["几外婆", "几姥姥", "几姥奶", "几外奶", "几姥"]
		},
		c = {
			"{G2}": {
				"f,f,xb": ["从祖"],
				"m,f,xb": ["外从祖"]
			},
			"{G1}": {
				"f,xb": ["堂", "同堂", "亲堂", "从父", "叔伯", "堂房", "从"],
				"f,xs": ["姑表", "姑家"],
				"m,xb": ["舅表", "舅家"],
				"m,xs": ["姨", "从母", "两姨", "姨表", "从"],
				"f,f,xb,s": ["从堂", "再从父", "远堂", "堂叔伯", "叔伯叔伯", "再从"],
				"f,f,xb,d": ["堂姑表", "从父姑表"],
				"f,f,xs,s": ["姑表叔表"],
				"f,f,xs,d": ["姑表姑表"],
				"f,m,xb,s": ["舅表叔表"],
				"f,m,xb,d": ["舅表姑表"],
				"f,m,xs,s": ["从母叔表"],
				"f,m,xs,d": ["从母姑表"],
				"m,f,xb,s": ["堂舅表", "从父舅表"],
				"m,f,xb,d": ["堂姨表", "从父姨表"],
				"m,f,xs,s": ["姑表舅表"],
				"m,f,xs,d": ["姑表姨表"],
				"m,m,xb,s": ["舅表舅表"],
				"m,m,xb,d": ["舅表姨表"],
				"m,m,xs,s": ["从母舅表"],
				"m,m,xs,d": ["再从母", "姨姨", "再从"],
				"f,f,f,xb,s,s": ["三从父", "再从堂", "远堂", "族", "三从"],
				"m,m,m,xs,d,d": ["三从母", "三从"],
				"f,f,f,f,xb,s,s,s": ["四从父", "三从堂", "远堂", "族", "四从"],
				"m,m,m,m,xs,d,d,d": ["四从母", "四从"],
				"[f|m],[f|m],[f|m],[f,xs|m,xb],[s|d],[s|d],[s|d]": ["重表"],
				"[f|m],[f|m],[f,xs|m,xb],[s|d],[s|d]": ["重表"]
			},
			"{G1M}": {
				"f,ob": ["伯"],
				"f,lb": ["叔", "仲", "季"],
				"m,xb": ["舅"],
				"f,f,xb,s": ["堂", "从父", "叔伯", "从"],
				"f,f,xb,s&o": ["堂伯", "从父伯", "叔伯伯", "从伯"],
				"f,f,xb,s&l": ["堂叔", "从父叔", "叔伯叔", "从叔"],
				"f,f,f,xb,s,s": ["从堂"],
				"f,f,f,xb,s,s&o": ["从堂伯"],
				"f,f,f,xb,s,s&l": ["从堂叔"],
				"f,f,f,f,xb,s,s,s": ["族"],
				"f,f,xs,s&o": ["姑表伯"],
				"f,f,xs,s&l": ["姑表叔"],
				"f,m,xb,s&o": ["舅表伯"],
				"f,m,xb,s&l": ["舅表叔"],
				"f,m,xs,s&o": ["姨伯", "从母伯", "从伯"],
				"f,m,xs,s&l": ["姨叔", "从母叔", "从叔"],
				"m,f,xb,s": ["堂舅", "从父舅", "叔伯舅"],
				"m,f,xs,s": ["姑表舅"],
				"m,m,xb,s": ["舅表舅"],
				"m,m,xs,s": ["姨舅", "从母舅"],
				"f,[f|m],[f|m],[f,xs|m,xb],[s|d],[s|d],s&o": ["重表伯"],
				"f,[f|m],[f|m],[f,xs|m,xb],[s|d],[s|d],s&l": ["重表叔"],
				"f,[f|m],[f,xs|m,xb],[s|d],s&o": ["重表伯"],
				"f,[f|m],[f,xs|m,xb],[s|d],s&l": ["重表叔"],
				"m,[f|m],[f|m],[f,xs|m,xb],[s|d],[s|d],s": ["重表舅"],
				"m,[f|m],[f,xs|m,xb],[s|d],s": ["重表舅"]
			},
			"{G1W}": {
				"f,xs": ["姑"],
				"m,xs": ["姨", "姏", "茙", "荻"],
				"f,f,xb,d": ["堂姑", "从父姑"],
				"f,f,f,xb,s,d": ["从堂姑"],
				"f,f,xs,d": ["姑表姑"],
				"f,m,xb,d": ["舅表姑"],
				"f,m,xs,d": ["姨姑", "从母姑"],
				"m,f,xb,d": ["堂姨", "从父姨", "叔伯姨"],
				"m,f,xs,d": ["姑表姨"],
				"m,m,xb,d": ["舅表姨"],
				"m,m,xs,d": ["姨姨", "从母姨"],
				"f,[f|m],[f|m],[f,xs|m,xb],[s|d],[s|d],d": ["重表姑"],
				"f,[f|m],[f,xs|m,xb],[s|d],d": ["重表姑"],
				"m,[f|m],[f|m],[f,xs|m,xb],[s|d],[s|d],d": ["重表姨"],
				"m,[f|m],[f,xs|m,xb],[s|d],d": ["重表姨"]
			},
			"{G0}": {
				xb: ["侄"],
				"1,xb": ["从"],
				"1,f,xb,s": ["再从"],
				"1,f,f,xb,s,s": ["三从"],
				"h,xb": ["叔侄", "叔伯"],
				"w,xb": ["舅侄"],
				xs: ["甥", "外甥"],
				"0,xs": ["从"],
				"0,m,xs,d": ["再从"],
				"0,m,m,xs,d,d": ["三从"],
				"h,xs": ["姑甥"],
				"w,xs": ["姨甥", "襟侄"]
			},
			"{M2W}": {
				"f,f,xb,w": ["叔祖眷"],
				"m,f,xb,w": ["叔外祖眷"],
				"f,m,xb,w": ["舅祖眷"],
				"m,m,xb,w": ["舅外祖眷"]
			},
			"{M2M}": {
				"f,f,xs,h": ["姑祖姻"],
				"m,f,xs,h": ["姑外祖姻"],
				"f,m,xs,h": ["姨祖姻"],
				"m,m,xs,h": ["姨外祖姻"]
			},
			"{M1W}": {
				"f,xb,w": ["叔眷"],
				"f,f,xb,s,w": ["从父叔眷"],
				"f,f,xs,s,w": ["姑表叔眷"],
				"f,m,xb,s,w": ["舅表叔眷"],
				"f,m,xs,s,w": ["从母叔眷"],
				"m,xb,w": ["舅眷"],
				"m,f,xb,s,w": ["从父舅眷"],
				"m,f,xs,s,w": ["姑表舅眷"],
				"m,m,xb,s,w": ["舅表舅眷"],
				"m,m,xs,s,w": ["从母舅眷"]
			},
			"{M1M}": {
				"f,xs,h": ["姑姻"],
				"f,f,xb,d,h": ["从父姑姻"],
				"f,f,xs,d,h": ["姑表姑姻"],
				"f,m,xb,d,h": ["舅表姑姻"],
				"f,m,xs,d,h": ["从母姑姻"],
				"m,xs,h": ["姨姻"],
				"m,f,xb,d,h": ["从父姨姻"],
				"m,f,xs,d,h": ["姑表姨姻"],
				"m,m,xb,d,h": ["舅表姨姻"],
				"m,m,xs,d,h": ["从母姨姻"]
			},
			"{M0}": {
				"xb,w": ["兄弟眷"],
				"xs,h": ["姊妹姻"],
				"w,xb,w": ["舅兄弟眷", "内兄弟眷"],
				"w,xs,h": ["姨姊妹姻", "内姊妹姻"],
				"h,xb,w": ["叔兄弟眷", "外兄弟眷"],
				"h,xs,h": ["姑姊妹姻", "外姊妹姻"],
				"f,xb,s,w": ["从父兄弟眷"],
				"f,xb,d,h": ["从父姊妹姻"],
				"f,xs,s,w": ["姑表兄弟眷"],
				"f,xs,d,h": ["姑表姊妹姻"],
				"m,xb,s,w": ["舅表兄弟眷"],
				"m,xb,d,h": ["舅表姊妹姻"],
				"m,xs,s,w": ["从母兄弟眷"],
				"m,xs,d,h": ["从母姊妹姻"]
			},
			"{M-1}": {
				"s,w": ["男眷", "息眷"],
				"d,h": ["女姻", "息姻"],
				"xb,s,w": ["侄眷"],
				"xb,d,h": ["侄姻"],
				"xs,s,w": ["甥眷"],
				"xs,d,h": ["甥姻"],
				"h,xb,s,w": ["叔侄眷"],
				"h,xb,d,h": ["叔侄姻"],
				"h,xs,s,w": ["姑甥眷"],
				"h,xs,d,h": ["姑甥姻"],
				"w,xb,s,w": ["舅侄眷"],
				"w,xb,d,h": ["舅侄姻"],
				"w,xs,s,w": ["姨甥眷"],
				"w,xs,d,h": ["姨甥姻"],
				"f,xb,s,s,w": ["堂侄眷"],
				"f,xb,s,d,h": ["堂侄姻"],
				"f,xb,d,s,w": ["堂甥眷"],
				"f,xb,d,d,h": ["堂甥姻"],
				"f,xs,s,s,w": ["姑表侄眷"],
				"f,xs,s,d,h": ["姑表侄姻"],
				"f,xs,d,s,w": ["姑表甥眷"],
				"f,xs,d,d,h": ["姑表甥姻"],
				"m,xb,s,s,w": ["舅表侄眷"],
				"m,xb,s,d,h": ["舅表侄姻"],
				"m,xb,d,s,w": ["舅表甥眷"],
				"m,xb,d,d,h": ["舅表甥姻"],
				"m,xs,s,s,w": ["姨侄眷"],
				"m,xs,s,d,h": ["姨侄姻"],
				"m,xs,d,s,w": ["姨甥眷"],
				"m,xs,d,d,h": ["姨甥姻"]
			},
			"{M-2}": {
				"s,s,w": ["孙眷"],
				"s,d,h": ["孙姻"],
				"d,s,w": ["外孙眷"],
				"d,d,h": ["外孙姻"],
				"xb,s,s,w": ["侄孙眷"],
				"xb,s,d,h": ["侄孙姻"],
				"xb,d,s,w": ["侄外孙眷"],
				"xb,d,d,h": ["侄外孙姻"],
				"xs,s,s,w": ["甥孙眷"],
				"xs,s,d,h": ["甥孙姻"],
				"xs,d,s,w": ["甥外孙眷"],
				"xs,d,d,h": ["甥外孙姻"],
				"h,xb,s,s,w": ["叔侄孙眷", "叔伯孙眷", "叔孙眷"],
				"h,xb,s,d,h": ["叔侄孙姻", "叔伯孙姻", "叔孙姻"],
				"h,xb,d,s,w": ["叔侄外孙眷", "叔伯外孙眷", "叔外孙眷"],
				"h,xb,d,d,h": ["叔侄外孙姻", "叔伯外孙姻", "叔外孙姻"],
				"h,xs,s,s,w": ["姑甥孙眷", "姑孙眷"],
				"h,xs,s,d,h": ["姑甥孙姻", "姑孙姻"],
				"h,xs,d,s,w": ["姑甥外孙眷", "姑外孙眷"],
				"h,xs,d,d,h": ["姑甥外孙姻", "姑外孙姻"],
				"w,xb,s,s,w": ["舅侄孙眷", "舅孙眷"],
				"w,xb,s,d,h": ["舅侄孙姻", "舅孙姻"],
				"w,xb,d,s,w": ["舅侄外孙眷", "舅外孙眷"],
				"w,xb,d,d,h": ["舅侄外孙姻", "舅外孙姻"],
				"w,xs,s,s,w": ["姨甥孙眷", "姨孙眷"],
				"w,xs,s,d,h": ["姨甥孙姻", "姨孙姻"],
				"w,xs,d,s,w": ["姨甥外孙眷", "姨外孙眷"],
				"w,xs,d,d,h": ["姨甥外孙姻", "姨外孙姻"]
			}
		},
		i = {
			"{G2},s": ["父"],
			"{G2},s,w": ["母"],
			"{G2},s,s": ["兄弟"],
			"{G2},s,s&o": ["兄"],
			"{G2},s,s&l": ["弟"],
			"{G2},s,s,s": ["男", "子"],
			"{G2},s,s,d": ["女"],
			"{G2},s,d": ["姊妹"],
			"{G2},s,d&o": ["姊"],
			"{G2},s,d&l": ["妹"],
			"f,f,f,f,f,f,f,f,[{G1M}|{G1W},h]": ["鼻祖父"],
			"f,f,f,f,f,f,f,f,[{G1M},w|{G1W}]": ["鼻祖母"],
			"f,f,f,f,f,f,f,[{G1M}|{G1W},h]": ["远祖父"],
			"f,f,f,f,f,f,f,[{G1M},w|{G1W}]": ["远祖母"],
			"f,f,f,f,f,f,[{G1M}|{G1W},h]": ["太祖父"],
			"f,f,f,f,f,f,[{G1M},w|{G1W}]": ["太祖母"],
			"f,f,f,f,f,[{G1M}|{G1W},h]": ["烈祖父"],
			"f,f,f,f,f,[{G1M},w|{G1W}]": ["烈祖母"],
			"f,f,f,f,[{G1M}|{G1W},h]": ["天祖父"],
			"f,f,f,f,[{G1M},w|{G1W}]": ["天祖母"],
			"f,f,f,[{G1M}|{G1W},h]": ["高祖父", "外曾外曾外毑父"],
			"f,f,f,[{G1M},w|{G1W}]": ["高祖母", "外曾外曾外毑母"],
			"f,f,m,[{G1M}|{G1W},h]": ["高外祖父", "外曾外曾毑父"],
			"f,f,m,[{G1M},w|{G1W}]": ["高外祖母", "外曾外曾毑母"],
			"f,m,f,[{G1M}|{G1W},h]": ["曾外曾祖父", "外高外毑父"],
			"f,m,f,[{G1M},w|{G1W}]": ["曾外曾祖母", "外高外毑母"],
			"f,m,m,[{G1M}|{G1W},h]": ["曾外曾外祖父", "外高毑父"],
			"f,m,m,[{G1M},w|{G1W}]": ["曾外曾外祖母", "外高毑母"],
			"m,f,f,[{G1M}|{G1W},h]": ["外高祖父", "曾外曾外毑父"],
			"m,f,f,[{G1M},w|{G1W}]": ["外高祖母", "曾外曾外毑母"],
			"m,f,m,[{G1M}|{G1W},h]": ["外高外祖父", "曾外曾祖毑父"],
			"m,f,m,[{G1M},w|{G1W}]": ["外高外祖母", "曾外曾祖毑母"],
			"m,m,f,[{G1M}|{G1W},h]": ["外曾外曾祖父", "高外毑父"],
			"m,m,f,[{G1M},w|{G1W}]": ["外曾外曾祖母", "高外毑母"],
			"m,m,m,[{G1M}|{G1W},h]": ["外曾外曾外祖父", "高毑父"],
			"m,m,m,[{G1M},w|{G1W}]": ["外曾外曾外祖母", "高毑母"],
			"f,f,[{G1M}|{G1W},h]": ["?曾祖父", "曾?祖父", "?太公", "太?公", "?公太", "太?爷", "?太爷", "?太爷爷", "太?爷爷"],
			"f,f,[{G1M},w|{G1W}]": ["?曾祖母", "曾?祖母", "?太婆", "太?婆", "?婆太", "太?奶", "?太奶", "?太奶奶", "太?奶奶"],
			"f,m,[{G1M}|{G1W},h]": ["?曾外祖父", "曾外?祖父", "?太外公", "太外?公", "太外?爷", "?太外爷", "?太外爷爷", "太外?爷爷"],
			"f,m,[{G1M},w|{G1W}]": ["?曾外祖母", "曾外?祖母", "?太外婆", "太外?婆", "太外?奶", "?太外奶", "?太外奶奶", "太外?奶奶"],
			"m,f,[{G1M}|{G1W},h]": ["?外曾祖父", "外曾?祖父", "?外太公", "外太?公", "外太?爷", "?外太爷", "?外太爷爷", "外太?爷爷"],
			"m,f,[{G1M},w|{G1W}]": ["?外曾祖母", "外曾?祖母", "?外太婆", "外太?婆", "外太?奶", "?外太奶", "?外太奶奶", "外太?奶奶"],
			"m,m,[{G1M}|{G1W},h]": ["?外曾外祖父", "外曾外?祖父", "?外太外公", "外太外?公", "外太外?爷", "?外太外爷", "?外太外爷爷", "外太外?爷爷"],
			"m,m,[{G1M},w|{G1W}]": ["?外曾外祖母", "外曾外?祖母", "?外太外婆", "外太外?婆", "外太外?奶", "?外太外奶", "?外太外奶奶", "外太外?奶奶"],
			"f,[{G1M}|{G1W},h]": ["祖父", "公", "太?父", "奶爷", "爷爷", "爷"],
			"f,[{G1M},w|{G1W}]": ["祖母", "婆", "太?母", "奶奶", "奶"],
			"m,[{G1M}|{G1W},h]": ["外祖父", "外公", "外爷", "外?公", "外?祖父", "外太?父", "太外?父", "姥爷", "姥公", "毑公", "毑爷",
				"毑父", "嘎公"
			],
			"m,[{G1M},w|{G1W}]": ["外祖母", "外婆", "外奶", "外?婆", "外?祖母", "外太?母", "太外?母", "姥姥", "姥婆", "毑婆", "毑毑",
				"毑母", "嘎嘎"
			],
			"f,f,{G1},s&o": ["伯祖父", "伯爷爷"],
			"f,f,{G1},s&o,w": ["伯祖母", "伯奶奶"],
			"f,f,{G1},s&l": ["叔祖父", "叔爷爷"],
			"f,f,{G1},s&l,w": ["叔祖母", "叔奶奶"],
			"f,f,{G1},d": ["姑祖母", "姑奶奶"],
			"f,f,{G1},d,h": ["姑祖父", "姑爷爷"],
			"f,m,{G1},s": ["舅祖父", "舅爷爷"],
			"f,m,{G1},s,w": ["舅祖母", "舅奶奶"],
			"f,m,{G1},d": ["姨祖母", "姨奶奶"],
			"f,m,{G1},d,h": ["姨祖父", "姨爷爷"],
			"m,f,{G1},s&o": ["伯外祖父", "伯外公", "伯姥爷"],
			"m,f,{G1},s&o,w": ["伯外祖母", "伯外婆", "伯姥姥"],
			"m,f,{G1},s&l": ["叔外祖父", "叔外公", "叔姥爷"],
			"m,f,{G1},s&l,w": ["叔外祖母", "叔外婆", "叔姥姥"],
			"m,f,{G1},d": ["姑外祖母", "姑外婆", "姑姥姥"],
			"m,f,{G1},d,h": ["姑外祖父", "姑外公", "姑姥爷"],
			"m,m,{G1},s": ["舅外祖父", "舅外公", "舅姥爷"],
			"m,m,{G1},s,w": ["舅外祖母", "舅外婆", "舅姥姥"],
			"m,m,{G1},d": ["姨外祖母", "姨外公", "姨姥爷"],
			"m,m,{G1},d,h": ["姨外祖父", "姨外婆", "姨姥姥"],
			"{G1M}#{G1W},h": ["父"],
			"{G1M},w#{G1W}": ["母"],
			"f,{G1},s&o": ["伯父", "伯伯", "伯", "大爷"],
			"f,{G1},s&o,w": ["伯母", "大娘"],
			"f,{G1},s&l": ["叔父", "叔爸", "叔叔", "叔"],
			"f,{G1},s&l,w": ["叔母", "婶"],
			"f,{G1},s,s&o": ["哥"],
			"f,{G1},s,s&l": ["弟"],
			"f,{G1},d": ["姑母", "姑姑", "姑妈", "姑"],
			"f,{G1},d,h": ["姑父", "姑丈", "姑爸", "姑夫"],
			"m,{G1},s": ["舅父", "舅舅", "舅爸", "舅"],
			"m,{G1},s,w": ["舅母", "舅妈"],
			"m,{G1},d": ["姨母", "姨姨", "姨妈", "姨"],
			"m,{G1},d,h": ["姨父", "姨丈", "姨爸", "姨夫"],
			"{G1},s": ["兄弟"],
			"{G1},s,w": ["兄弟妇"],
			"{G1},s&o": ["哥", "哥哥", "阿哥"],
			"{G1},s&o,w": ["嫂", "嫂子", "兄妇"],
			"{G1},s&l": ["弟", "弟弟", "阿弟"],
			"{G1},s&l,w": ["弟媳", "弟妇"],
			"{G1},s,s": ["侄男", "侄子", "侄儿"],
			"{G1},s,s,w": ["侄妇"],
			"{G1},s,s,s": ["侄孙男"],
			"{G1},s,s,s,w": ["侄孙妇"],
			"{G1},s,s,s,s": ["侄曾孙男"],
			"{G1},s,s,s,s,w": ["侄曾孙妇"],
			"{G1},s,s,s,s,s": ["侄玄孙男"],
			"{G1},s,s,s,s,s,w": ["侄玄孙妇"],
			"{G1},s,s,s,s,d": ["侄玄孙女"],
			"{G1},s,s,s,s,d,h": ["侄玄孙婿"],
			"{G1},s,s,d": ["侄孙女"],
			"{G1},s,s,d,h": ["侄孙婿"],
			"{G1},s,s,s,d": ["侄曾孙女"],
			"{G1},s,s,s,d,h": ["侄曾孙婿"],
			"{G1},s,d": ["侄女", "侄女儿"],
			"{G1},s,d,h": ["侄婿"],
			"{G1},s,d,s": ["侄外孙男", "外孙男"],
			"{G1},s,d,s,w": ["侄外孙妇"],
			"{G1},s,d,d": ["侄外孙女", "外孙女"],
			"{G1},s,d,d,h": ["侄外孙婿"],
			"{G1},d": ["姐妹"],
			"{G1},d,h": ["姐妹壻"],
			"{G1},d&o": ["姐", "姐姐", "阿姐"],
			"{G1},d&o,h": ["姐夫"],
			"{G1},d&l": ["妹", "妹妹", "阿妹"],
			"{G1},d&l,h": ["妹夫"],
			"{G1},d,s": ["甥男"],
			"{G1},d,s,w": ["甥妇"],
			"{G1},d,s,s": ["甥孙男"],
			"{G1},d,s,s,w": ["甥孙妇"],
			"{G1},d,s,d": ["甥孙女"],
			"{G1},d,s,d,h": ["甥孙婿"],
			"{G1},d,d": ["甥女"],
			"{G1},d,d,h": ["甥婿"],
			"{G1},d,d,s": ["甥外孙男", "外孙男"],
			"{G1},d,d,s,w": ["甥外孙妇"],
			"{G1},d,d,d": ["甥外孙女", "外孙女"],
			"{G1},d,d,d,h": ["甥外孙婿"],
			"h,f,[{G1M}|{G1W},h]": ["祖公父", "祖公", "祖翁", "奶公"],
			"h,f,[{G1M},w|{G1W}]": ["祖婆母", "祖婆", "祖姆", "奶婆"],
			"h,m,[{G1M}|{G1W},h]": ["外祖公父", "外祖公", "外祖翁", "姥公"],
			"h,m,[{G1M},w|{G1W}]": ["外祖婆母", "外祖婆", "外祖姆", "姥婆"],
			"h,[{G1M}|{G1W},h]": ["公父", "公公"],
			"h,[{G1M},w|{G1W}]": ["婆母", "婆婆"],
			"h,{G1},s&o": ["哥哥", "大伯兄"],
			"h,{G1},s&o,w": ["嫂子", "大伯嫂"],
			"h,{G1},s&l": ["弟弟", "小叔弟"],
			"h,{G1},s&l,w": ["弟妹", "小叔弟妇"],
			"h,{G1},s": ["伯叔"],
			"h,{G1},s,w": ["妯娌"],
			"h,{G1},d&o": ["大姑子", "大姑姐"],
			"h,{G1},d&o,h": ["姐夫", "大姑姐夫"],
			"h,{G1},d&l": ["小姑子", "小姑妹"],
			"h,{G1},d&l,h": ["妹夫", "小姑妹夫"],
			"h,{G1},d": ["姑子"],
			"h,{G1},d,h": ["姑夫"],
			"w,f,[{G1M}|{G1W},h]": ["祖岳父", "太?岳", "祖丈人", "爷丈人", "奶爷丈人"],
			"w,f,[{G1M},w|{G1W}]": ["祖岳母", "太?岳母", "祖丈母", "祖丈母娘", "奶丈母娘", "奶丈母"],
			"w,m,[{G1M}|{G1W},h]": ["外祖岳父", "外太?岳父", "太外?岳父", "外祖丈人", "姥爷丈人"],
			"w,m,[{G1M},w|{G1W}]": ["外祖岳母", "外太?岳母", "太外?岳母", "外祖丈母", "外祖丈母娘", "姥丈母娘", "姥丈母"],
			"w,[{G1M}|{G1W},h]": ["岳父", "丈人", "丈人爹"],
			"w,[{G1M},w|{G1W}]": ["岳母", "丈母", "丈母娘"],
			"w,{G1},s&o": ["大舅子", "大舅兄", "舅兄"],
			"w,{G1},s&o,w": ["嫂子", "大舅姆", "大舅兄妇", "舅兄妇", "舅姐", "大舅姐", "大妗子", "大妗儿"],
			"w,{G1},s&l": ["小舅子", "小舅弟", "舅弟"],
			"w,{G1},s&l,w": ["弟妹", "小舅姆", "小舅弟妇", "舅弟妇", "舅妹", "小舅妹", "小妗子", "小妗儿"],
			"w,{G1},s": ["舅子"],
			"w,{G1},s,w": ["舅嫂"],
			"w,{G1},d&o": ["大姨子", "大姨姐", "姨姐"],
			"w,{G1},d&o,h": ["姐夫", "大姨姐夫", "襟兄", "姨兄", "大姨哥", "大尹子"],
			"w,{G1},d&l": ["小姨子", "小姨妹", "姨妹"],
			"w,{G1},d&l,h": ["妹夫", "小姨妹夫", "襟弟", "姨弟", "小姨弟", "小尹子"],
			"w,{G1},d": ["姨子"],
			"w,{G1},d,h": ["连襟", "连桥"],
			"{G0},s": ["男", "男儿", "儿", "子", "儿子"],
			"{G0},s,w": ["媳妇", "媳", "妇"],
			"{G0},s,s": ["孙", "孙男", "孙子"],
			"{G0},s,s,w": ["孙妇"],
			"{G0},s,s,s": ["曾孙", "曾孙男"],
			"{G0},s,s,s,w": ["曾孙妇"],
			"{G0},s,s,s,s": ["玄孙", "玄孙男", "元孙", "元孙男"],
			"{G0},s,s,s,s,w": ["玄孙妇"],
			"{G0},s,s,s,d": ["玄孙女", "元孙女"],
			"{G0},s,s,s,d,h": ["玄孙婿"],
			"{G0},s,s,d": ["曾孙女"],
			"{G0},s,s,d,h": ["曾孙婿"],
			"{G0},s,s,d,s": ["玄外孙", "玄外孙男"],
			"{G0},s,s,d,s,w": ["玄外孙妇"],
			"{G0},s,s,d,d": ["玄外孙女"],
			"{G0},s,s,d,d,h": ["玄外孙婿"],
			"{G0},s,d": ["孙女"],
			"{G0},s,d,h": ["孙婿"],
			"{G0},s,d,s": ["曾外孙", "曾外孙男"],
			"{G0},s,d,s,w": ["曾外孙妇"],
			"{G0},s,d,s,s": ["曾外曾孙", "曾外曾孙男"],
			"{G0},s,d,s,s,w": ["曾外曾孙妇"],
			"{G0},s,d,s,d": ["曾外曾孙女"],
			"{G0},s,d,s,d,h": ["曾外曾孙婿"],
			"{G0},s,d,d": ["曾外孙女"],
			"{G0},s,d,d,h": ["曾外孙婿"],
			"{G0},s,d,d,s": ["曾外曾外孙", "曾外曾外孙男"],
			"{G0},s,d,d,s,w": ["曾外曾外孙妇"],
			"{G0},s,d,d,d": ["曾外曾外孙女"],
			"{G0},s,d,d,d,h": ["曾外曾外孙婿"],
			"{G0},d": ["女", "女儿"],
			"{G0},d,h": ["女婿", "婿"],
			"{G0},d,s": ["外孙", "外孙男"],
			"{G0},d,s,w": ["外孙妇"],
			"{G0},d,s,s": ["外曾孙", "外曾孙男"],
			"{G0},d,s,s,w": ["外曾孙妇"],
			"{G0},d,s,s,s": ["外玄孙", "外玄孙男"],
			"{G0},d,s,s,d": ["外玄孙女"],
			"{G0},d,s,d": ["外曾孙女"],
			"{G0},d,s,d,h": ["外曾孙婿"],
			"{G0},d,s,d,s": ["外玄外孙", "外玄外孙男"],
			"{G0},d,s,d,d": ["外玄外孙女"],
			"{G0},d,d": ["外孙女"],
			"{G0},d,d,h": ["外孙婿"],
			"{G0},d,d,s": ["外曾外孙", "外曾外孙男"],
			"{G0},d,d,s,w": ["外曾外孙妇"],
			"{G0},d,d,s,s": ["外曾外曾孙", "外曾外曾孙男"],
			"{G0},d,d,s,d": ["外曾外曾孙女"],
			"{G0},d,d,d": ["外曾外孙女"],
			"{G0},d,d,d,h": ["外曾外孙婿"],
			"{G0},d,d,d,s": ["外曾外曾外孙"],
			"{G0},d,d,d,d": ["外曾外曾外孙女"],
			"{M2W},xb": ["舅祖父"],
			"{M2W},xb,w": ["舅祖母"],
			"{M2W},xb,s&o": ["舅表伯父"],
			"{M2W},xb,s&o,w": ["舅表伯母"],
			"{M2W},xb,s&l": ["舅表叔父"],
			"{M2W},xb,s&l,w": ["舅表叔母"],
			"{M2W},xb,d": ["舅表姑母"],
			"{M2W},xb,d,h": ["舅表姑父"],
			"{M2W},xs": ["姨祖母"],
			"{M2W},xs,h": ["姨祖父"],
			"{M2W},xs,s&o": ["姨伯父"],
			"{M2W},xs,s&o,w": ["姨伯母"],
			"{M2W},xs,s&l": ["姨叔父"],
			"{M2W},xs,s&l,w": ["姨叔母"],
			"{M2W},xs,d": ["姨姑母"],
			"{M2W},xs,d,h": ["姨姑父"],
			"{M2M},xb": ["叔祖父"],
			"{M2M},xb,w": ["叔祖母"],
			"{M2M},xb,s&o": ["堂伯父"],
			"{M2M},xb,s&o,w": ["堂伯母"],
			"{M2M},xb,s&l": ["堂叔父"],
			"{M2M},xb,s&l,w": ["堂叔母"],
			"{M2M},xb,d": ["堂姑母"],
			"{M2M},xb,d,h": ["堂姑父"],
			"{M2M},xs": ["姑祖母"],
			"{M2M},xs,h": ["姑祖父"],
			"{M2M},xs,s&o": ["姑表伯父"],
			"{M2M},xs,s&o,w": ["姑表伯母"],
			"{M2M},xs,s&l": ["姑表叔父"],
			"{M2M},xs,s&l,w": ["姑表叔母"],
			"{M2M},xs,d": ["姑表姑母"],
			"{M2M},xs,d,h": ["姑表姑父"],
			"{M1W},f": ["外祖父"],
			"{M1W},f,xb,s": ["堂舅父"],
			"{M1W},f,xb,s,w": ["堂舅母"],
			"{M1W},f,xb,d": ["堂姨母"],
			"{M1W},f,xb,d,h": ["堂姨父"],
			"{M1W},f,ob": ["伯外祖父"],
			"{M1W},f,ob,w": ["伯外祖母"],
			"{M1W},f,lb": ["叔外祖父"],
			"{M1W},f,lb,w": ["叔外祖母"],
			"{M1W},f,xs": ["姑外祖母"],
			"{M1W},f,xs,h": ["姑外祖父"],
			"{M1W},f,xs,s": ["姑表舅父"],
			"{M1W},f,xs,s,w": ["姑表舅母"],
			"{M1W},f,xs,d": ["姑表姨母"],
			"{M1W},f,xs,d,h": ["姑表姨父"],
			"{M1W},m": ["外祖母"],
			"{M1W},m,xb": ["舅外祖父"],
			"{M1W},m,xb,w": ["舅外祖母"],
			"{M1W},m,xb,s": ["舅表舅父"],
			"{M1W},m,xb,s,w": ["舅表舅母"],
			"{M1W},m,xb,d": ["舅表姨母"],
			"{M1W},m,xb,d,h": ["舅表姨父"],
			"{M1W},m,xs": ["姨外祖母"],
			"{M1W},m,xs,h": ["姨外祖父"],
			"{M1W},m,xs,s": ["姨舅父"],
			"{M1W},m,xs,s,w": ["姨舅母"],
			"{M1W},m,xs,d": ["姨姨母"],
			"{M1W},m,xs,d,h": ["姨姨父"],
			"{M1W},xb": ["舅父"],
			"{M1W},xb,w": ["舅母"],
			"{M1W},xb,[s|d]": ["舅表兄弟姊妹"],
			"{M1W},xb,s": ["舅表兄弟"],
			"{M1W},xb,s,w": ["舅表兄弟妇"],
			"{M1W},xb,s&o": ["舅表兄"],
			"{M1W},xb,s&o,w": ["舅表兄妇"],
			"{M1W},xb,s&l": ["舅表弟"],
			"{M1W},xb,s&l,w": ["舅表弟妇"],
			"{M1W},xb,s,s": ["舅表侄男", "侄男"],
			"{M1W},xb,s,s,w": ["舅表侄妇", "侄妇"],
			"{M1W},xb,s,d": ["舅表侄女", "侄女"],
			"{M1W},xb,s,d,h": ["舅表侄婿", "侄婿"],
			"{M1W},xb,d": ["舅表姊妹"],
			"{M1W},xb,d,h": ["舅表姊妹壻"],
			"{M1W},xb,d&o": ["舅表姊"],
			"{M1W},xb,d&o,h": ["舅表姊壻"],
			"{M1W},xb,d&l": ["舅表妹"],
			"{M1W},xb,d&l,h": ["舅表妹壻"],
			"{M1W},xb,d,s": ["舅表甥男", "甥男"],
			"{M1W},xb,d,s,w": ["舅表甥妇", "甥妇"],
			"{M1W},xb,d,d": ["舅表甥女", "甥女"],
			"{M1W},xb,d,d,h": ["舅表甥婿", "甥婿"],
			"{M1W},xs": ["姨母", "姨妈"],
			"{M1W},xs,h": ["姨父", "姨丈", "姨夫"],
			"{M1W},xs,[s|d]": ["姨表兄弟姊妹"],
			"{M1W},xs,s": ["姨表兄弟"],
			"{M1W},xs,s,w": ["姨表兄弟妇"],
			"{M1W},xs,s&o": ["姨表兄"],
			"{M1W},xs,s&o,w": ["姨表兄妇"],
			"{M1W},xs,s&l": ["姨表弟"],
			"{M1W},xs,s&l,w": ["姨表弟妇"],
			"{M1W},xs,s,s": ["姨表侄男", "侄男"],
			"{M1W},xs,s,s,w": ["姨表侄妇", "侄妇"],
			"{M1W},xs,s,d": ["姨表侄女", "侄女"],
			"{M1W},xs,s,d,h": ["姨表侄婿", "侄婿"],
			"{M1W},xs,d": ["姨表姊妹"],
			"{M1W},xs,d,h": ["姨表姊妹壻"],
			"{M1W},xs,d&o": ["姨表姊"],
			"{M1W},xs,d&o,h": ["姨表姊壻"],
			"{M1W},xs,d&l": ["姨表妹"],
			"{M1W},xs,d&l,h": ["姨表妹壻"],
			"{M1W},xs,d,s": ["姨表甥男", "甥男"],
			"{M1W},xs,d,s,w": ["姨表甥妇", "甥妇"],
			"{M1W},xs,d,d": ["姨表甥女", "甥女"],
			"{M1W},xs,d,d,h": ["姨表甥婿", "甥婿"],
			"{M1M},f": ["祖父"],
			"{M1M},f,xb,s&o": ["堂伯父"],
			"{M1M},f,xb,s&o,w": ["堂伯母"],
			"{M1M},f,xb,s&l": ["堂叔父"],
			"{M1M},f,xb,s&l,w": ["堂叔母"],
			"{M1M},f,xb,d": ["堂姑母"],
			"{M1M},f,xb,d,h": ["堂姑父"],
			"{M1M},f,ob": ["伯祖父"],
			"{M1M},f,ob,w": ["伯祖母"],
			"{M1M},f,lb": ["叔祖父"],
			"{M1M},f,lb,w": ["叔祖母"],
			"{M1M},f,xs": ["姑祖母"],
			"{M1M},f,xs,h": ["姑祖父"],
			"{M1M},f,xs,s&o": ["姑表伯父"],
			"{M1M},f,xs,s&o,w": ["姑表伯母"],
			"{M1M},f,xs,s&l": ["姑表叔父"],
			"{M1M},f,xs,s&l,w": ["姑表叔母"],
			"{M1M},f,xs,d": ["姑表姑母"],
			"{M1M},f,xs,d,h": ["姑表姑父"],
			"{M1M},m": ["祖母"],
			"{M1M},m,xb": ["舅祖父"],
			"{M1M},m,xb,w": ["舅祖母"],
			"{M1M},m,xb,s&o": ["舅表伯父"],
			"{M1M},m,xb,s&o,w": ["舅表伯母"],
			"{M1M},m,xb,s&l": ["舅表叔父"],
			"{M1M},m,xb,s&l,w": ["舅表叔母"],
			"{M1M},m,xb,d": ["舅表姑母"],
			"{M1M},m,xb,d,h": ["舅表姑父"],
			"{M1M},m,xs": ["姨祖母"],
			"{M1M},m,xs,h": ["姨祖父"],
			"{M1M},m,xs,s&o": ["姨伯父"],
			"{M1M},m,xs,s&o,w": ["姨伯母"],
			"{M1M},m,xs,s&l": ["姨叔父"],
			"{M1M},m,xs,s&l,w": ["姨叔母"],
			"{M1M},m,xs,d": ["姨姑母"],
			"{M1M},m,xs,d,h": ["姨姑父"],
			"{M1M},xb": ["叔伯父"],
			"{M1M},xb,w": ["叔伯母"],
			"{M1M},ob": ["伯父"],
			"{M1M},ob,w": ["伯母"],
			"{M1M},lb": ["叔父"],
			"{M1M},lb,w": ["叔母"],
			"{M1M},xb,[s|d]": ["叔表兄弟姊妹"],
			"{M1M},xb,s": ["叔表兄弟"],
			"{M1M},xb,s,w": ["叔表兄弟妇"],
			"{M1M},xb,s&o": ["叔表兄"],
			"{M1M},xb,s&o,w": ["叔表兄妇"],
			"{M1M},xb,s&l": ["叔表弟"],
			"{M1M},xb,s&l,w": ["叔表弟妇"],
			"{M1M},xb,s,s": ["叔表侄男", "侄男"],
			"{M1M},xb,s,s,w": ["叔表侄妇", "侄妇"],
			"{M1M},xb,s,d": ["叔表侄女", "侄女"],
			"{M1M},xb,s,d,h": ["叔表侄婿", "侄婿"],
			"{M1M},xb,d": ["叔表姊妹"],
			"{M1M},xb,d,h": ["叔表姊妹壻"],
			"{M1M},xb,d&o": ["叔表姊"],
			"{M1M},xb,d&o,h": ["叔表姊壻"],
			"{M1M},xb,d&l": ["叔表妹"],
			"{M1M},xb,d&l,h": ["叔表妹壻"],
			"{M1M},xb,d,s": ["叔表甥男", "甥男"],
			"{M1M},xb,d,s,w": ["叔表甥妇", "甥妇"],
			"{M1M},xb,d,d": ["叔表甥女", "甥女"],
			"{M1M},xb,d,d,h": ["叔表甥婿", "甥婿"],
			"{M1M},xs": ["姑母", "姑妈"],
			"{M1M},xs,h": ["姑父", "姑丈", "姑夫"],
			"{M1M},xs,[s|d]": ["姑表兄弟姊妹"],
			"{M1M},xs,s": ["姑表兄弟"],
			"{M1M},xs,s,w": ["姑表兄弟妇"],
			"{M1M},xs,s&o": ["姑表兄"],
			"{M1M},xs,s&o,w": ["姑表兄妇"],
			"{M1M},xs,s&l": ["姑表弟"],
			"{M1M},xs,s&l,w": ["姑表弟妇"],
			"{M1M},xs,s,s": ["姑表侄男", "侄男"],
			"{M1M},xs,s,s,w": ["姑表侄妇", "侄妇"],
			"{M1M},xs,s,d": ["姑表侄女", "侄女"],
			"{M1M},xs,s,d,h": ["姑表侄婿", "侄婿"],
			"{M1M},xs,d": ["姑表姊妹"],
			"{M1M},xs,d,h": ["姑表姊妹壻"],
			"{M1M},xs,d&o": ["姑表姊"],
			"{M1M},xs,d&o,h": ["姑表姊壻"],
			"{M1M},xs,d&l": ["姑表妹"],
			"{M1M},xs,d&l,h": ["姑表妹壻"],
			"{M1M},xs,d,s": ["姑表甥男", "甥男"],
			"{M1M},xs,d,s,w": ["姑表甥妇", "甥妇"],
			"{M1M},xs,d,d": ["姑表甥女", "甥女"],
			"{M1M},xs,d,d,h": ["姑表甥婿", "甥婿"],
			"{M0},f": ["父"],
			"{M0},f,f": ["祖父"],
			"{M0},f,f,ob": ["伯祖父"],
			"{M0},f,f,ob,w": ["伯祖母"],
			"{M0},f,f,lb": ["叔祖父"],
			"{M0},f,f,lb,w": ["叔祖母"],
			"{M0},f,f,xs": ["姑祖母"],
			"{M0},f,f,xs,h": ["姑祖父"],
			"{M0},f,m": ["祖母"],
			"{M0},f,m,xb": ["舅祖父"],
			"{M0},f,m,xb,w": ["舅祖母"],
			"{M0},f,m,xs": ["姨祖母"],
			"{M0},f,m,xs,h": ["姨祖父"],
			"{M0},f,ob": ["伯父"],
			"{M0},f,ob,w": ["伯母"],
			"{M0},f,lb": ["叔父"],
			"{M0},f,lb,w": ["叔母"],
			"{M0},f,xb,[s|d]": ["叔表兄弟姊妹", "叔表姊妹兄弟"],
			"{M0},f,xb,s": ["叔表兄弟"],
			"{M0},f,xb,s,w": ["叔表兄弟妇"],
			"{M0},f,xb,s&o": ["叔表兄"],
			"{M0},f,xb,s&o,w": ["叔表兄妇"],
			"{M0},f,xb,s&l": ["叔表弟"],
			"{M0},f,xb,s&l,w": ["叔表弟妇"],
			"{M0},f,xb,d": ["叔表姊妹"],
			"{M0},f,xb,d,h": ["叔表姊妹壻"],
			"{M0},f,xb,d&o": ["叔表姊"],
			"{M0},f,xb,d&o,h": ["叔表姊壻"],
			"{M0},f,xb,d&l": ["叔表妹"],
			"{M0},f,xb,d&l,h": ["叔表妹壻"],
			"{M0},f,xs": ["姑母", "姑妈"],
			"{M0},f,xs,h": ["姑父", "姑丈", "姑夫"],
			"{M0},f,xs,[s|d]": ["姑表兄弟姊妹", "姑表姊妹兄弟"],
			"{M0},f,xs,s": ["姑表兄弟"],
			"{M0},f,xs,s,w": ["姑表兄弟妇"],
			"{M0},f,xs,s&o": ["姑表兄"],
			"{M0},f,xs,s&o,w": ["姑表兄妇"],
			"{M0},f,xs,s&l": ["姑表弟"],
			"{M0},f,xs,s&l,w": ["姑表弟妇"],
			"{M0},f,xs,d": ["姑表姊妹"],
			"{M0},f,xs,d,h": ["姑表姊妹壻"],
			"{M0},f,xs,d&o": ["姑表姊"],
			"{M0},f,xs,d&o,h": ["姑表姊壻"],
			"{M0},f,xs,d&l": ["姑表妹"],
			"{M0},f,xs,d&l,h": ["姑表妹壻"],
			"{M0},m": ["母"],
			"{M0},m,f": ["外祖父"],
			"{M0},m,f,ob": ["伯外祖父"],
			"{M0},m,f,ob,w": ["伯外祖母"],
			"{M0},m,f,lb": ["叔外祖父"],
			"{M0},m,f,lb,w": ["叔外祖母"],
			"{M0},m,f,xs": ["姑外祖母"],
			"{M0},m,f,xs,h": ["姑外祖父"],
			"{M0},m,m": ["外祖母"],
			"{M0},m,m,xb": ["舅外祖父"],
			"{M0},m,m,xb,w": ["舅外祖母"],
			"{M0},m,m,xs": ["姨外祖母"],
			"{M0},m,m,xs,h": ["姨外祖父"],
			"{M0},m,xb": ["舅父"],
			"{M0},m,xb,w": ["舅母"],
			"{M0},m,xb,[s|d]": ["舅表兄弟姊妹", "舅表姊妹兄弟"],
			"{M0},m,xb,s": ["舅表兄弟"],
			"{M0},m,xb,s,w": ["舅表兄弟妇"],
			"{M0},m,xb,s&o": ["舅表兄"],
			"{M0},m,xb,s&o,w": ["舅表兄妇"],
			"{M0},m,xb,s&l": ["舅表弟"],
			"{M0},m,xb,s&l,w": ["舅表弟妇"],
			"{M0},m,xb,d": ["舅表姊妹"],
			"{M0},m,xb,d,h": ["舅表姊妹壻"],
			"{M0},m,xb,d&o": ["舅表姊"],
			"{M0},m,xb,d&o,h": ["舅表姊壻"],
			"{M0},m,xb,d&l": ["舅表妹"],
			"{M0},m,xb,d&l,h": ["舅表妹壻"],
			"{M0},m,xs": ["姨母", "姨妈"],
			"{M0},m,xs,h": ["姨父", "姨丈", "姨夫"],
			"{M0},m,xs,[s|d]": ["姨兄弟姊妹", "姨姊妹兄弟"],
			"{M0},m,xs,s": ["姨兄弟"],
			"{M0},m,xs,s,w": ["姨兄弟妇"],
			"{M0},m,xs,s&o": ["姨兄"],
			"{M0},m,xs,s&o,w": ["姨兄妇"],
			"{M0},m,xs,s&l": ["姨弟"],
			"{M0},m,xs,s&l,w": ["姨弟妇"],
			"{M0},m,xs,d": ["姨姊妹"],
			"{M0},m,xs,d,h": ["姨姊妹壻"],
			"{M0},m,xs,d&o": ["姨姊"],
			"{M0},m,xs,d&o,h": ["姨姊壻"],
			"{M0},m,xs,d&l": ["姨妹"],
			"{M0},m,xs,d&l,h": ["姨妹壻"],
			"{M0},xb": ["兄弟"],
			"{M0},xb,w": ["兄弟妇"],
			"{M0},xb&o": ["兄"],
			"{M0},xb&o,w": ["兄妇", "兄嫂", "嫂子"],
			"{M0},xb&l": ["弟"],
			"{M0},xb&l,w": ["弟妇", "弟妹"],
			"{M0},xb,s": ["侄男", "侄子", "侄儿"],
			"{M0},xb,s,w": ["侄妇"],
			"{M0},xb,d": ["侄女"],
			"{M0},xb,d,h": ["侄婿"],
			"{M0},xs": ["姊妹"],
			"{M0},xs,h": ["姊妹壻"],
			"{M0},xs&o": ["姊"],
			"{M0},xs&o,h": ["姊壻", "姐夫"],
			"{M0},xs&l": ["妹"],
			"{M0},xs&l,h": ["妹壻", "妹夫"],
			"{M0},xs,s": ["甥男"],
			"{M0},xs,s,w": ["甥妇"],
			"{M0},xs,d": ["甥女"],
			"{M0},xs,d,h": ["甥婿"],
			"{M-1},f": ["兄弟"],
			"{M-1},f&o": ["兄"],
			"{M-1},f&l": ["弟"],
			"{M-1},f,f": ["父"],
			"{M-1},f,f,f": ["祖父"],
			"{M-1},f,f,m": ["祖母"],
			"{M-1},f,f,ob": ["伯父"],
			"{M-1},f,f,ob,w": ["伯母"],
			"{M-1},f,f,lb": ["叔父"],
			"{M-1},f,f,lb,w": ["叔母"],
			"{M-1},f,m": ["母"],
			"{M-1},f,m,f": ["外祖父"],
			"{M-1},f,m,m": ["外祖母"],
			"{M-1},f,xb": ["叔兄弟"],
			"{M-1},f,xb,w": ["叔兄弟妇"],
			"{M-1},f,ob": ["叔兄"],
			"{M-1},f,ob,w": ["叔兄妇"],
			"{M-1},f,lb": ["叔弟"],
			"{M-1},f,lb,w": ["叔弟妇"],
			"{M-1},f,xb,s": ["叔男"],
			"{M-1},f,xb,d": ["叔女"],
			"{M-1},f,xs": ["姑姊妹"],
			"{M-1},f,xs,h": ["姑姊妹壻"],
			"{M-1},f,os": ["姑姊"],
			"{M-1},f,os,h": ["姑姊壻"],
			"{M-1},f,ls": ["姑妹"],
			"{M-1},f,ls,h": ["姑妹壻"],
			"{M-1},f,xs,s": ["姑男"],
			"{M-1},f,xs,d": ["姑女"],
			"{M-1},m": ["姊妹"],
			"{M-1},m&o": ["姊"],
			"{M-1},m&l": ["妹"],
			"{M-1},m,f": ["父"],
			"{M-1},m,f,f": ["祖父"],
			"{M-1},m,f,m": ["祖母"],
			"{M-1},m,m": ["母"],
			"{M-1},m,m,f": ["外祖父"],
			"{M-1},m,m,m": ["外祖母"],
			"{M-1},m,xb": ["舅兄弟"],
			"{M-1},m,xb,w": ["舅兄弟妇"],
			"{M-1},m,ob": ["舅兄"],
			"{M-1},m,ob,w": ["舅兄妇"],
			"{M-1},m,lb": ["舅弟"],
			"{M-1},m,lb,w": ["舅弟妇"],
			"{M-1},m,xb,s": ["舅男"],
			"{M-1},m,xb,d": ["舅女"],
			"{M-1},m,xs": ["姨姊妹"],
			"{M-1},m,xs,h": ["姨姊妹壻"],
			"{M-1},m,os": ["姨姊"],
			"{M-1},m,os,h": ["姨姊壻"],
			"{M-1},m,ls": ["姨妹"],
			"{M-1},m,ls,h": ["姨妹壻"],
			"{M-1},m,xs,s": ["姨男"],
			"{M-1},m,xs,d": ["姨女"],
			"{M-1},xb": ["男"],
			"{M-1},xb,w": ["妇"],
			"{M-1},xb,s": ["孙男"],
			"{M-1},xb,s,w": ["孙妇"],
			"{M-1},xb,d": ["孙女"],
			"{M-1},xb,d,h": ["孙婿"],
			"{M-1},xs": ["女"],
			"{M-1},xs,h": ["婿"],
			"{M-1},xs,s": ["外孙男"],
			"{M-1},xs,s,w": ["外孙妇"],
			"{M-1},xs,d": ["外孙女"],
			"{M-1},xs,d,h": ["外孙婿"],
			"{M-2},f": ["男"],
			"{M-2},m": ["女"],
			"{M-2},[f|m],f&o": ["兄"],
			"{M-2},[f|m],f&l": ["弟"],
			"{M-2},[f|m],m&o": ["姊"],
			"{M-2},[f|m],m&l": ["妹"],
			"{M-2},xb": ["孙男"],
			"{M-2},xb,w": ["孙妇"],
			"{M-2},xs": ["孙女"],
			"{M-2},xs,h": ["孙婿"]
		},
		u = {
			"": ["自己", "我", "俺", "吾", "本人", "在下"],
			"f,f,f,f,f,f,f,f,f,f,f,f": ["先祖父", "先太爷", "十二世祖"],
			"f,f,f,f,f,f,f,f,f,f,f,m": ["先祖母", "先太奶"],
			"f,f,f,f,f,f,f,f,f,f,f": ["始祖父", "始太爷", "十一世祖"],
			"f,f,f,f,f,f,f,f,f,f,m": ["始祖母", "始太奶"],
			"f,f,f,f,f,f,f,f,f,f": ["开祖父", "开太爷", "十世祖"],
			"f,f,f,f,f,f,f,f,f,m": ["开祖母", "开太奶"],
			"f,f,f,f,f,f,f,f,f": ["鼻祖父", "鼻太爷", "九世祖"],
			"f,f,f,f,f,f,f,f,m": ["鼻祖母", "鼻太奶"],
			"f,f,f,f,f,f,f,f": ["远祖父", "远太爷", "八世祖"],
			"f,f,f,f,f,f,f,m": ["远祖母", "远太奶"],
			"f,f,f,f,f,f,f": ["太祖父", "太太爷", "七世祖"],
			"f,f,f,f,f,f,m": ["太祖母", "太太奶"],
			"f,f,f,f,f,f": ["烈祖父", "烈太爷", "六世祖"],
			"f,f,f,f,f,m": ["烈祖母", "烈太奶"],
			"f,f,f,f,f": ["天祖父", "天太爷", "五世祖"],
			"f,f,f,f,m": ["天祖母", "天太奶"],
			"f,f,f,f": ["高祖父", "外曾外曾外毑父", "曾曾祖父", "祖太公", "祖太爷", "高太爷", "祖太翁", "祖太爷爷", "四世祖"],
			"f,f,f,m": ["高祖母", "外曾外曾外毑母", "曾曾祖母", "祖太婆", "祖太奶", "高太奶", "祖太姆", "祖太奶奶"],
			"f,f,m,f": ["高外祖父", "外曾外曾毑父", "高外翁"],
			"f,f,m,m": ["高外祖母", "外曾外曾毑母", "高外婆"],
			"f,m,f,f": ["曾外曾祖父", "外高外毑父"],
			"f,m,f,m": ["曾外曾祖母", "外高外毑母"],
            "f,m,f,m,m": ["曾外曾外曾祖母", "外高外高外毑母"],
            "f,m,f,m,m,xs": ["曾外曾祖母", "外高外毑母"],
            "f,m,f,m,m,xs,s": ["从母舅表曾祖父"],
            "f,m,f,m,m,xs,s,s": ["从母舅表祖父"],
			"f,m,m,xb": ["舅曾外祖父"],
			"f,m,m,xb,s&o": ["表伯祖父"],
			"f,m,m,xb,s&l": ["表叔祖父"],
			"f,m,m,xb,s,s": ["表叔父"],
			"f,m,m,xb,s,s,s&o": ["表哥"],
			"f,m,m,xb,s,s,s&l": ["表弟"],
			"f,m,f,lb": ["叔曾外祖父"],
			"f,m,f,ob": ["伯曾外祖父"],
			"f,m,f,xb,s&o": ["伯外祖父"],
			"f,m,f,xb,s&l": ["叔外祖父"],
			"f,m,f,xb,s,s&o": ["伯父"],
			"f,m,f,xb,s,s&l": ["叔父"],
			"f,m,m,f": ["曾外曾外祖父", "外高毑父"],
			"f,m,m,m": ["曾外曾外祖母", "外高毑母"],
			"m,f,f,f": ["外高祖父", "曾外曾外毑父"],
			"m,f,f,m": ["外高祖母", "曾外曾外毑母"],
			"m,f,m,f": ["外高外祖父", "曾外曾祖毑父"],
			"m,f,m,m": ["外高外祖母", "曾外曾祖毑母"],
			"m,m,f,f": ["外曾外曾祖父", "高外毑父"],
			"m,m,f,m": ["外曾外曾祖母", "高外毑母"],
			"m,m,m,f": ["外曾外曾外祖父", "高毑父"],
			"m,m,m,m": ["外曾外曾外祖母", "高毑母"],
			"f,f,f": ["曾祖父", "曾祖", "外曾外毑父", "太公", "太爷", "老太爷", "太翁", "太爷爷", "曾爷爷", "公太", "佬嗲", "祖爷", "三世祖"],
			"f,f,m": ["曾祖母", "外曾外毑母", "太婆", "太奶", "老太奶", "太嬷", "太姆", "太奶奶", "曾奶奶", "婆太", "老娭毑"],
			"f,m,f": ["曾外祖父", "曾外祖", "外曾毑父", "太外公", "太外爷", "太外翁", "太外爷爷"],
			"f,m,m": ["曾外祖母", "外曾毑母", "太外婆", "太外奶", "太外嬷", "太外姆", "太外奶奶"],
			"m,f,f": ["外曾祖父", "外曾祖", "曾外毑父", "外太公", "外太爷", "外太翁", "外太爷爷"],
			"m,f,m": ["外曾祖母", "曾外毑母", "外太婆", "外太奶", "外太嬷", "外太姆", "外太奶奶"],
			"m,m,f": ["外曾外祖父", "外曾外祖", "曾毑父", "外太外公", "外太外爷", "外太外翁", "外太外爷爷", "外太姥爷"],
			"m,m,m": ["外曾外祖母", "曾毑母", "外太外婆", "外太外奶", "外太外嬷", "外太外姆", "外太外奶奶", "外太姥姥"],
			"f,f": ["爷爷", "祖父", "祖公", "阿爷", "阿公", "奶爹", "亚爷", "亚公", "依爷", "大父", "祖翁", "嗲嗲", "爷", "祖君", "奶爷",
				"爷儿", "爷老", "爷老子", "爷老倌", "二世祖"
			],
			"f,m": ["奶奶", "祖母", "祖婆", "阿奶", "阿婆", "奶娘", "亚嬷", "亚婆", "依奶", "大母", "祖嫲", "嫲嫲", "奶", "重慈", "阿嬷",
				"婻婻", "娭毑", "嗯奶", "娘姆", "媪婆", "亲婆"
			],
			"m,f": ["外公", "外祖父", "姥爷", "阿公", "外爷", "客公", "毑父", "毑公", "姥公", "舅家爷", "嘎公", "嘎爹", "嘎嘎爹", "嘎爷爷",
				"尕公", "毑爹", "毑爷", "外大父", "姥爹", "魏公", "魏爷", "简爷"
			],
			"m,m": ["外婆", "外祖母", "姥姥", "阿婆", "外奶", "客婆", "毑母", "毑婆", "姥婆", "舅家婆", "嘎嘎", "嘎婆", "嘎嘎婆", "嘎奶奶",
				"尕婆", "毑娘", "毑毑", "外大母", "姥娘", "魏婆", "魏奶", "简婆", "阿嬷", "外嬷", "嫲嫲", "好婆", "嫏嫏", "嫏娘", "姥"
			],
			"f,f,ob": ["伯公", "伯祖", "伯翁", "大爷爷", "大嗲", "大爷", "大公", "大阿爷"],
			"f,f,ob,w": ["伯婆", "姆婆", "大奶奶", "伯娭毑"],
			"f,f,lb": ["叔公", "叔祖", "叔翁", "小爷爷", "晚公", "幺爷", "细嗲"],
			"f,f,lb,w": ["叔婆", "婶婆", "小奶奶", "叔娭毑", "晚婆", "幺奶"],
			"f,f,xs": ["姑奶奶", "祖姑", "姑奶", "恩婆", "姑娭毑"],
			"f,f,xs,h": ["姑爷爷", "祖姑丈", "恩爹", "姑丈公", "丈公"],
			"f,m,ob": ["大舅爷", "大舅爹"],
			"f,m,ob,w": ["大舅婆"],
			"f,m,lb": ["小舅爷", "小舅爹"],
			"f,m,lb,w": ["小舅婆"],
			"f,m,xb": ["舅爷爷", "舅祖", "舅爹", "太舅父"],
			"f,m,xb,w": ["舅奶奶", "妗婆", "舅婆", "妗奶", "太舅母"],
			"f,m,xs": ["姨奶奶", "姨奶", "姨娭毑"],
			"f,m,xs,h": ["姨爷爷", "姨公公", "姨爹", "姨丈公", "丈公"],
			"m,f,ob": ["伯外公", "外伯祖", "伯外祖", "大外公", "大姥爷", "大外爷"],
			"m,f,ob,w": ["伯外婆", "外姆婆", "大外婆", "大姥姥", "大姥奶"],
			"m,f,lb": ["叔外公", "外叔祖", "叔外祖", "小外公", "小姥爷", "小外爷"],
			"m,f,lb,w": ["叔外婆", "外婶婆", "小外婆", "小姥姥", "婶姥姥", "小姥奶"],
			"m,f,xs": ["姑外婆", "姑婆", "恩婆"],
			"m,f,xs,h": ["姑外公", "姑公", "恩爹", "外姑丈公", "外丈公"],
			"m,m,xb": ["舅外公", "舅公", "舅爹"],
			"m,m,xb,w": ["舅外婆", "舅婆", "妗姥姥", "妗姥娘", "妗姥", "外妗婆"],
			"m,m,xs": ["姨外婆", "姨婆"],
			"m,m,xs,h": ["姨外公", "姨公", "外姨丈公", "外丈公"],
			f: ["爸爸", "父亲", "老父亲", "老爸", "阿爸", "阿父", "阿爹", "老窦", "爹地", "依爹", "老爹", "老汉", "老爷子", "老子", "牙老子",
				"爸", "父", "爹", "老汉儿", "牙老倌", "爸比", "爹爹", "爹啲", "一世祖"
			],
			"f,ob": ["伯父", "伯伯", "伯爸", "阿伯", "伯爷", "依伯", "伯儿", "大伯", "大爹", "大爸", "大爸爸", "世父", "大爷", "大大", "几伯",
				"伯"
			],
			"f,ob,w": ["伯母", "伯妈", "伯娘", "依姆", "世母", "大娘", "伯妇", "大嬷", "大妈", "大妈妈", "大姆妈", "伯姐", "姆"],
			"f,lb": ["叔叔", "叔父", "叔爸", "阿叔", "叔爹", "依叔", "叔儿", "小叔", "小爹", "小爸", "小爸爸", "仲父", "季父", "叔仔", "几叔",
				"叔"
			],
			"f,lb,w": ["婶婶", "叔母", "叔妈", "阿婶", "叔娘", "依婶", "婶儿", "小婶", "小娘", "小妈", "小妈妈", "仲母", "季母", "叔妇",
				"几婶", "婶", "婶母", "婶妈", "婶娘", "婶子", "家婶", "婶爹", "嬢嬢"
			],
			"f,xb,s&o": ["堂哥", "堂老兄"],
			"f,xb,s&o,w": ["堂嫂", "堂兄嫂"],
			"f,xb,s&l": ["堂弟", "堂老弟"],
			"f,xb,s&l,w": ["堂弟媳", "堂弟妇", "堂弟妹"],
			"f,xb,s,s": ["堂侄", "再从子"],
			"f,xb,s,s,w": ["堂侄媳妇"],
			"f,xb,s,s,s": ["堂侄孙", "再从孙"],
			"f,xb,s,s,s,s": ["堂曾孙", "再曾孙"],
			"f,xb,s,s,s,s,s": ["堂玄孙", "再玄孙"],
			"f,xb,s,d": ["堂侄女"],
			"f,xb,s,d,h": ["堂侄女婿"],
			"f,xb,d&o": ["堂姐", "堂大姐"],
			"f,xb,d&o,h": ["堂姐夫"],
			"f,xb,d&l": ["堂妹", "堂细妹"],
			"f,xb,d&l,h": ["堂妹夫"],
			"f,xb,d,s": ["堂外甥"],
			"f,xb,d,s,w": ["堂外甥媳妇"],
			"f,xb,d,d": ["堂外甥女"],
			"f,xb,d,d,h": ["堂外甥女婿"],
			"f,os": ["大姑", "姑姊", "姑嬷"],
			"f,os,h": ["大姑丈", "大姑夫", "恩伯"],
			"f,ls": ["小姑", "姑姐", "姑妹", "姑仔", "尕娘", "幺姑姐", "老姑"],
			"f,ls,h": ["小姑丈", "小姑夫", "恩叔"],
			"f,xs": ["姑妈", "姑母", "姑姑", "恩妈", "几姑", "姑", "嬢嬢", "娘娘"],
			"f,xs,h": ["姑丈", "姑父", "姑爸", "恩爸", "姑伯", "姑爹", "姑夫", "姑婿", "姑郎", "亘"],
			"f,f,xb,s&o": ["堂伯"],
			"f,f,xb,s&o,w": ["堂伯母"],
			"f,f,xb,s&l": ["堂叔"],
			"f,f,xb,s&l,w": ["堂婶"],
			"f,f,xb,s": ["堂伯叔父", "堂叔伯", "从父"],
			"f,f,xb,s,w": ["堂伯叔母", "从母"],
			"f,f,xb,s,s&o": ["从堂兄"],
			"f,f,xb,s,s&l": ["从堂弟"],
			"f,f,xb,s,s,s": ["从堂侄", "三从子"],
			"f,f,xb,s,s,s,s": ["从堂侄孙", "三从孙"],
			"f,f,xb,s,s,s,s,s": ["从堂侄曾孙", "三曾孙"],
			"f,f,xb,s,s,s,s,s,s": ["从堂侄玄孙", "三玄孙"],
			"f,f,xb,d": ["堂姑"],
			"f,f,xb,d,h": ["堂姑丈"],
			"f,f,f,xb": ["伯叔曾祖父"],
			"f,f,f,xb,w": ["伯叔曾祖母"],
			"f,f,f,xb,s": ["堂伯叔祖父"],
			"f,f,f,xb,s,w": ["堂伯叔祖母"],
			"f,f,f,xb,s,s&o": ["从伯父"],
			"f,f,f,xb,s,s&o,w": ["从伯母"],
			"f,f,f,xb,s,s&l": ["从叔父"],
			"f,f,f,xb,s,s&l,w": ["从叔母"],
			"f,f,f,xb,s,s": ["从伯叔父", "再从父"],
			"f,f,f,xb,s,s,w": ["从伯叔母", "再从母"],
			"f,f,f,xb,s,s,s&o": ["族兄"],
			"f,f,f,xb,s,s,s&l": ["族弟"],
			"f,f,f,xb,s,s,s,s": ["族侄", "四从子", "族子"],
			"f,f,f,xb,s,s,s,s,s": ["族侄孙", "四从孙", "族孙"],
			"f,f,f,xb,s,s,s,s,s,s": ["族侄曾孙", "四曾孙", "族曾孙"],
			"f,f,f,xb,s,s,s,s,s,s,s": ["族侄玄孙", "四玄孙", "族玄孙"],
			"f,f,f,f,xb": ["伯叔高祖父"],
			"f,f,f,f,xb,w": ["伯叔高祖母"],
			"f,f,f,f,xb,s": ["堂伯叔曾祖父"],
			"f,f,f,f,xb,s,w": ["堂伯叔曾祖母"],
			"f,f,f,f,xb,s,s": ["从伯叔祖父"],
			"f,f,f,f,xb,s,s,w": ["从伯叔祖母"],
			"f,f,f,f,xb,s,s,s&o": ["族伯父"],
			"f,f,f,f,xb,s,s,s&o,w": ["族伯母"],
			"f,f,f,f,xb,s,s,s&l": ["族叔父"],
			"f,f,f,f,xb,s,s,s&l,w": ["族叔母"],
			"f,f,f,f,xb,s,s,s": ["族伯叔父", "三从父", "族父"],
			"f,f,f,f,xb,s,s,s,w": ["族伯叔母", "三从母", "族母"],
			m: ["妈妈", "母亲", "老母亲", "老妈", "阿妈", "阿母", "阿娘", "老母", "妈咪", "依妈", "老娘", "老乸", "老妈子", "妈子", "娘老子",
				"妈", "母", "娘", "阿毑", "姆嬷", "姆妈", "娘亲"
			],
			"m,ob": ["大舅", "大舅舅", "舅伯", "元舅"],
			"m,ob,w": ["大舅妈", "大妗", "舅嬷"],
			"m,lb": ["小舅", "小舅舅", "舅仔", "舅父仔", "尕阿舅", "老舅"],
			"m,lb,w": ["小舅妈", "小妗", "细妗"],
			"m,xb": ["舅舅", "舅爸", "舅父", "舅爹", "娘舅", "母舅", "阿舅", "妗公", "舅台", "几舅", "舅"],
			"m,xb,w": ["舅妈", "舅母", "舅娘", "娘妗", "舅妻", "舅姆", "舅姆妈", "舅媳妇", "舅妇", "舅姥", "舅毑", "老妗", "妗子", "妗妗",
				"妗妗儿", "妗爹", "妗娘", "妗爸", "妗妈", "妗母", "阿妗", "妗门", "妗婆仔", "妗儿妈", "娘妗子", "妗", "嬢嬢"
			],
			"m,os": ["大姨", "姨嬷"],
			"m,os,h": ["大姨丈", "大姨父", "大姨夫", "姨伯"],
			"m,ls": ["小姨", "姨仔", "老姨"],
			"m,ls,h": ["小姨丈", "小姨父", "小姨夫", "姨叔"],
			"m,xs": ["姨妈", "姨母", "姨姨", "姨娘", "阿姨", "从母", "几姨", "姨", "嬢嬢"],
			"m,xs,h": ["姨丈", "姨父", "姨夫", "姨爸", "姨爹", "姨婿", "姨郎", "尹"],
			"m,f,xb,s": ["堂舅"],
			"m,f,xb,s,w": ["堂舅妈"],
			"m,f,xb,d": ["堂姨"],
			"m,f,xb,d,h": ["堂姨丈"],
			"h,f,f,f": ["曾祖公父", "曾祖公", "太公翁"],
			"h,f,f,m": ["曾祖婆母", "曾祖婆", "太奶亲"],
			"h,f,m,f": ["曾外祖公父", "曾外祖公"],
			"h,f,m,m": ["曾外祖婆母", "曾外祖婆"],
			"h,m,f,f": ["外曾祖公父", "外曾祖公"],
			"h,m,f,m": ["外曾祖婆母", "外曾祖婆"],
			"h,m,m,f": ["外曾外祖公父", "外曾外祖公"],
			"h,m,m,m": ["外曾外祖婆母", "外曾外祖婆"],
			"h,f,f,f,ob": ["伯曾祖公父", "伯曾祖公", "太伯翁"],
			"h,f,f,f,ob,w": ["伯曾祖婆母", "伯曾祖婆", "太姆婆"],
			"h,f,f,f,lb": ["叔曾祖公父", "叔曾祖公", "太叔翁"],
			"h,f,f,f,lb,w": ["叔曾祖婆母", "叔曾祖婆", "太婶婆"],
			"h,f,f,f,xs": ["姑曾祖婆母", "姑曾祖婆"],
			"h,f,f,f,xs,h": ["姑曾祖公父", "姑曾祖婆"],
			"h,f,f": ["祖公父", "祖公", "祖公公", "祖翁", "奶公父"],
			"h,f,m": ["祖婆母", "祖婆", "祖婆婆", "奶婆母"],
			"h,m,f": ["外祖公父", "毑公父", "外祖公", "外祖公公", "姥公父", "姥公"],
			"h,m,m": ["外祖婆母", "毑婆母", "外祖婆", "外祖婆婆", "姥婆母", "姥婆"],
			"h,f": ["公公", "公父", "家公", "家爷", "大官", "老公公", "老人公", "大人公", "公公爸", "公爹", "翁亲", "君舅", "老公爹", "家官",
				"老官", "婆父", "婆爹"
			],
			"h,m": ["婆婆", "婆母", "家婆", "家娘", "大家", "老婆婆", "老人婆", "大人婆", "婆婆妈", "婆妈", "姑亲", "君姑", "婆母娘", "婆子妈",
				"阿姑"
			],
			"h,f,ob": ["伯公父", "伯公", "伯翁", "伯公公", "伯祖", "婆婆伯"],
			"h,f,ob,w": ["伯婆母", "伯婆", "姆婆", "伯婆婆", "伯姆", "婆婆伯姆"],
			"h,f,lb": ["叔公父", "叔公", "叔翁", "叔公公", "叔祖", "婆婆叔"],
			"h,f,lb,w": ["叔婆母", "叔婆", "婶婆", "婶婆婆", "婶亲", "婆婆婶子"],
			"h,f,xs": ["姑婆母", "姑婆", "姑婆婆", "婆婆姑"],
			"h,f,xs,h": ["姑公父", "姑公", "姑公公", "婆婆姑夫"],
			"h,m,xb": ["舅公父", "舅公", "舅公公"],
			"h,m,xb,w": ["舅婆母", "舅婆", "妗婆婆", "舅婆婆"],
			"h,m,xs": ["姨婆", "姨婆母", "姨婆婆"],
			"h,m,xs,h": ["姨公父", "姨公", "姨公公"],
			h: ["老公", "丈夫", "先生", "夫", "男人", "新郎", "爱爷", "夫亲", "夫君", "官人", "汉子", "老头子", "郎君", "相公", "夫婿", "良人",
				"老公仔", "爱人", "老伴", "那口子", "配偶", "伴侣", "伉俪", "卿卿"
			],
			"h,ob": ["哥哥", "大伯儿", "大伯兄", "伯子", "伯仔", "伯兄", "阿伯", "大伯爷", "伯爷子", "婿伯"],
			"h,ob,w": ["嫂子", "大婶儿", "大叔兄妇", "伯兄妇", "伯嫂", "伯妇", "伯姆", "姒妇", "姒姆", "大伯嫂", "姆姆", "大姆", "大伯妇",
				"大伯娘", "姐妇", "阿姆"
			],
			"h,lb": ["弟弟", "小叔儿", "小叔弟", "叔子", "叔仔", "叔弟", "阿叔", "叔郎", "小郎"],
			"h,lb,w": ["弟妹", "小婶儿", "小叔弟妇", "叔弟妇", "叔嫂", "叔妇", "叔姆", "娣妇", "娣姆", "小叔妇", "婶婶", "小婶", "小婶婶"],
			"h,xb,s": ["叔侄"],
			"h,xb,d": ["叔侄女"],
			"h,os": ["大姑子", "大姑姐", "大姑儿", "大姑娘", "姑姊", "婆姐", "婆婆姐", "大娘姑"],
			"h,os,h": ["姐夫", "大姑姐夫", "大亘子", "婆姐夫", "婆婆姐夫"],
			"h,ls": ["小姑子", "小姑妹", "小姑儿", "小姑娘", "姑妹", "婆妹", "婆婆妹"],
			"h,ls,h": ["妹夫", "小姑妹夫", "小亘子", "婆妹夫", "婆婆妹夫"],
			"h,xs": ["姑子", "夫姑"],
			"h,xs,h": ["姑夫", "姑郎"],
			"h,xs,s": ["姑甥"],
			"h,xs,d": ["姑甥女"],
			"w,f,f,f": ["曾祖岳父", "曾祖丈人", "太爷丈人", "祖爷丈人"],
			"w,f,f,m": ["曾祖岳母", "曾祖丈母", "曾祖丈母娘", "祖奶丈母娘", "太奶丈母娘"],
			"w,f,m,f": ["曾外祖岳父", "曾外祖丈人", "祖姥爷丈人", "太姥爷丈"],
			"w,f,m,m": ["曾外祖岳母", "曾外祖丈母", "曾外祖丈母娘", "祖姥丈母娘", "太姥丈母娘"],
			"w,m,f,f": ["外曾祖岳父", "外曾祖丈人", "祖奶爷丈人", "太奶爷丈人", "祖姥爷丈人", "太姥爷丈人"],
			"w,m,f,m": ["外曾祖岳母", "外曾祖丈母", "太奶丈母娘", "祖姥丈母娘", "太姥丈母娘"],
			"w,m,m,f": ["外曾外祖岳父", "外曾外祖丈人", "祖姥爷丈人", "太姥爷丈人"],
			"w,m,m,m": ["外曾外祖岳母", "外曾外祖丈母", "外曾外祖丈母娘", "祖姥丈母娘", "太姥丈母娘"],
			"w,f,f": ["祖岳父", "太岳父", "奶岳父", "祖丈人", "爷丈人", "奶爷丈人", "奶丈爷", "奶丈人", "老丈爷"],
			"w,f,m": ["祖岳母", "太岳母", "奶岳母", "祖丈母", "祖丈母娘", "奶丈母娘", "奶丈姥", "奶丈母", "老丈姥"],
			"w,f,ob": ["伯岳父"],
			"w,f,ob,w": ["伯岳母"],
			"w,f,lb": ["叔岳父"],
			"w,f,lb,w": ["叔岳母"],
			"w,f,f,xb,s&o": ["姻伯丈"],
			"w,f,f,xb,s&o,w": ["姻姆"],
			"w,f,f,xb,s&l": ["姻叔丈"],
			"w,f,f,xb,s&l,w": ["姻婶"],
			"w,m,f": ["外祖岳父", "毑岳父", "外祖丈人爹", "外祖丈人", "外太岳父", "姥岳父", "姥丈爷", "姥丈人", "姥丈人爹", "老丈爷", "姥爷丈人"],
			"w,m,m": ["外祖岳母", "毑岳母", "外祖丈母娘", "外祖丈母", "外太岳母", "姥岳母", "姥丈姥", "姥丈母", "姥丈母娘", "老丈娘"],
			"w,f": ["岳父", "丈人", "老丈人", "外父", "泰山", "外舅", "老亲爷", "丈人爹", "老干爷", "丈人公", "丈母爷", "丈爷", "丈爷爹", "丈父",
				"岳老子", "老丈杆子", "岳丈", "岳翁", "妻公", "妇翁", "冰翁"
			],
			"w,m": ["岳母", "丈母", "老丈母", "外母", "泰水", "外姑", "老亲娘", "丈人娘", "老干娘", "丈人婆", "丈母娘", "丈姥", "丈姥娘", "丈姆",
				"岳母娘", "丈母婆", "丈姆婆", "丈姆娘"
			],
			w: ["老婆", "妻子", "媳妇", "媳妇儿", "媳妇子", "太太", "妻", "女人", "新娘", "爱姥", "妻亲", "娘子", "新娘子", "夫人", "婆娘",
				"老太婆", "内人", "内子", "内助", "贤内助", "爱妻", "发妻", "婆姨", "婆子", "老婆子", "老婆儿", "老婆仔", "堂客", "爱人",
				"老伴", "那口子", "配偶", "伴侣", "伉俪", "卿卿"
			],
			"w,ob": ["大舅子", "大舅哥", "大舅佬", "大阿舅", "丈人兄", "舅哥"],
			"w,ob,w": ["嫂子", "大妗子", "大妗儿", "大舅姆", "大舅兄嫂", "大舅嫂", "大舅姐", "大舅媳妇", "丈人嫂"],
			"w,lb": ["小舅子", "小舅弟", "小舅佬", "小阿舅", "丈人弟", "舅弟"],
			"w,lb,w": ["弟妹", "小妗子", "小妗儿", "小舅姆", "小舅弟妇", "小舅嫂", "舅弟媳", "小舅妹", "小舅媳妇"],
			"w,xb": ["舅子", "舅佬", "妻舅", "老婆舅", "阿舅", "亲家舅", "舅老倌"],
			"w,xb,w": ["舅嫂", "舅妇", "舅姆", "妻妗", "妗仔", "妗子", "妗儿"],
			"w,xb,s": ["舅侄"],
			"w,xb,d": ["舅侄女"],
			"w,os": ["大姨子", "大姨姐", "大姨儿", "姨姐"],
			"w,os,h": ["姐夫", "大姨姐夫", "姨姐夫", "襟兄", "大尹子"],
			"w,ls": ["小姨子", "小姨妹", "小茙儿", "姨妹", "姨仔", "姨妹子"],
			"w,ls,h": ["妹夫", "小姨妹夫", "姨妹夫", "小茙夫", "襟弟", "小尹子"],
			"w,xs": ["姨子", "妻姨"],
			"w,xs,h": ["连襟", "姨夫", "连桥", "两桥", "两乔", "姨夫爷", "老襟", "一担挑", "老挑", "挑担", "担儿挑", "连襟儿", "襟兄弟", "友婿",
				"妻尹", "娅"
			],
			"w,xs,s": ["姨甥"],
			"w,xs,d": ["姨甥女"],
			ob: ["哥哥", "哥", "胞兄", "亲哥", "兄亲", "老哥", "依哥", "阿哥", "兄台", "大佬", "家兄", "兄长", "元兄", "长兄", "几哥"],
			"ob,w": ["嫂子", "嫂", "嫂嫂", "阿嫂", "家嫂", "兄姊", "兄嫂", "兄妇", "兄妻", "几嫂"],
			"ob,s": ["侄子", "兄子"],
			"ob,d": ["侄女", "兄女"],
			lb: ["弟弟", "弟", "胞弟", "亲弟", "弟亲", "老弟", "依弟", "阿弟", "弟子", "细佬", "小弟", "几弟"],
			"lb,w": ["弟妹", "弟媳", "弟媳妇", "弟媳妇子", "弟新妇", "老弟嫂"],
			"lb,s": ["侄子", "弟子"],
			"lb,d": ["侄女", "弟女"],
			"xb,s": ["侄子", "侄男", "侄儿子", "侄小子", "嫡侄", "亲侄", "侄儿", "侄仔", "阿侄", "老侄", "侄"],
			"xb,s,w": ["侄媳妇", "侄媳", "侄嫂", "侄妇"],
			"xb,d": ["侄女", "侄囡", "侄女儿", "侄丫头", "侄闺女"],
			"xb,d,h": ["侄女婿", "侄婿", "侄郎"],
			os: ["姐姐", "姐", "胞姐", "亲姐", "姊亲", "老姐", "依姐", "阿姐", "姊台", "家姐", "长姐", "姊仔", "几姐"],
			"os,h": ["姐夫", "姐丈", "姐婿", "姐郎", "姊兄", "姐夫哥", "胞姐夫"],
			ls: ["妹妹", "妹", "胞妹", "亲妹", "妹亲", "老妹", "依妹", "阿妹", "妹子", "小妹", "妹儿", "几妹"],
			"ls,h": ["妹夫", "妹丈", "妹婿", "妹郎", "妹弟", "妹夫子", "胞妹夫"],
			"xs,s": ["外甥", "甥子", "甥男", "甥儿", "甥儿子", "甥仔", "甥"],
			"xs,s,w": ["甥媳妇", "甥媳", "甥嫂", "甥妇", "甥儿息妇儿"],
			"xs,s,s": ["甥孙", "远甥", "弥甥"],
			"xs,s,d": ["甥孙女", "远甥女", "弥甥女"],
			"xs,d": ["外甥女", "甥女", "甥囡", "甥女儿", "甥闺女"],
			"xs,d,h": ["甥女婿", "甥婿", "甥郎", "甥儿息婿儿"],
			s: ["儿子", "男儿", "息男", "闺男", "囝囝", "囝男", "囝儿", "小子", "娃子", "男亲", "伢子", "长子", "次子", "幼子", "儿", "仔",
				"囝", "子", "阿仔", "仔仔", "后生", "公子", "少爷", "一世孙"
			],
			"s,w": ["儿媳", "儿媳妇", "息妇儿", "儿媳妇儿", "新妇", "新妇囝", "心抱", "息妇", "儿妇", "子妇", "小妇", "少奶奶", "少夫人"],
			"s,w,f": ["亲家公"],
			"s,w,f,f&o": ["姻伯"],
			"s,w,f,f&l": ["姻叔"],
			"s,w,m": ["亲家母"],
			"s,w,xb": ["姻侄", "世侄"],
			"s,w,xb,w": ["姻侄媳"],
			"s,w,xb,s": ["姻侄孙"],
			"s,w,xb,d": ["姻侄孙女"],
			"s,w,xs": ["姻侄女"],
			"s,w,xs,h": ["姻侄婿"],
			"s,w,xs,s": ["姻侄外孙"],
			"s,w,xs,d": ["姻侄外孙女"],
			"s,s": ["孙子", "孙男", "孙男儿", "孙儿", "长孙", "嗣孙", "孙仔", "孙囝", "孙娃子", "孙伢子", "二世孙"],
			"s,s,w": ["孙媳妇", "孙媳", "孙妇", "孙息妇", "孙新妇"],
			"s,s,s": ["曾孙", "曾孙男", "重孙", "重孙子", "息仔", "三世孙"],
			"s,s,s,w": ["曾孙妇", "重孙媳妇"],
			"s,s,s,s": ["玄孙", "元孙", "膀孙", "重重孙", "四世孙"],
			"s,s,s,s,w": ["玄孙媳妇"],
			"s,s,s,s,s": ["来孙", "五世孙"],
			"s,s,s,s,s,w": ["来孙媳妇"],
			"s,s,s,s,s,s": ["晜孙", "昆孙", "六世孙"],
			"s,s,s,s,s,s,w": ["晜孙媳妇"],
			"s,s,s,s,s,s,s": ["仍孙", "礽孙", "七世孙"],
			"s,s,s,s,s,s,s,w": ["仍孙媳妇"],
			"s,s,s,s,s,s,s,s": ["云孙", "八世孙"],
			"s,s,s,s,s,s,s,s,w": ["云孙媳妇"],
			"s,s,s,s,s,s,s,s,s": ["耳孙", "远孙", "裔孙", "季孙", "九世孙"],
			"s,s,s,s,s,s,s,s,s,w": ["耳孙媳妇"],
			"s,s,s,s,s,s,s,s,s,s": ["弥孙", "十世孙"],
			"s,s,s,s,s,s,s,s,s,s,w": ["弥孙媳妇"],
			"s,s,s,s,s,s,s,s,s,s,s": ["胎孙", "十一世孙"],
			"s,s,s,s,s,s,s,s,s,s,s,w": ["胎孙媳妇"],
			"s,s,s,s,s,s,s,s,s,s,s,s": ["承孙", "十二世孙"],
			"s,s,s,s,s,s,s,s,s,s,s,s,w": ["承孙媳妇"],
			"s,s,s,s,s,s,s,s,s,s,s,d": ["承孙女"],
			"s,s,s,s,s,s,s,s,s,s,s,d,h": ["承孙女婿"],
			"s,s,s,s,s,s,s,s,s,s,d": ["胎孙女"],
			"s,s,s,s,s,s,s,s,s,s,d,h": ["胎孙女婿"],
			"s,s,s,s,s,s,s,s,s,s,d,s": ["承外孙"],
			"s,s,s,s,s,s,s,s,s,s,d,s,w": ["承外孙媳妇"],
			"s,s,s,s,s,s,s,s,s,s,d,d": ["承外孙女"],
			"s,s,s,s,s,s,s,s,s,s,d,d,h": ["承外孙女婿"],
			"s,s,s,s,s,s,s,s,s,d": ["弥孙女"],
			"s,s,s,s,s,s,s,s,s,d,h": ["弥孙女婿"],
			"s,s,s,s,s,s,s,s,s,d,s": ["胎外孙"],
			"s,s,s,s,s,s,s,s,s,d,s,w": ["胎外孙媳妇"],
			"s,s,s,s,s,s,s,s,s,d,d": ["胎外孙女"],
			"s,s,s,s,s,s,s,s,s,d,d,h": ["胎外孙女婿"],
			"s,s,s,s,s,s,s,s,d": ["耳孙女"],
			"s,s,s,s,s,s,s,s,d,h": ["耳孙女婿"],
			"s,s,s,s,s,s,s,s,d,s": ["弥外孙"],
			"s,s,s,s,s,s,s,s,d,s,w": ["弥外孙媳妇"],
			"s,s,s,s,s,s,s,s,d,d": ["弥外孙女"],
			"s,s,s,s,s,s,s,s,d,d,h": ["弥外孙女婿"],
			"s,s,s,s,s,s,s,d": ["云孙女"],
			"s,s,s,s,s,s,s,d,h": ["云孙女婿"],
			"s,s,s,s,s,s,s,d,s": ["耳外孙"],
			"s,s,s,s,s,s,s,d,s,w": ["耳外孙媳妇"],
			"s,s,s,s,s,s,s,d,d": ["耳外孙女"],
			"s,s,s,s,s,s,s,d,d,h": ["耳外孙女婿"],
			"s,s,s,s,s,s,d": ["仍孙女", "礽孙女"],
			"s,s,s,s,s,s,d,h": ["仍孙女婿"],
			"s,s,s,s,s,s,d,s": ["云外孙"],
			"s,s,s,s,s,s,d,s,w": ["云外孙媳妇"],
			"s,s,s,s,s,s,d,d": ["云外孙女"],
			"s,s,s,s,s,s,d,d,h": ["云外孙女婿"],
			"s,s,s,s,s,d": ["晜孙女"],
			"s,s,s,s,s,d,h": ["晜孙女婿"],
			"s,s,s,s,s,d,s": ["仍外孙"],
			"s,s,s,s,s,d,s,w": ["仍外孙媳妇"],
			"s,s,s,s,s,d,d": ["仍外孙女"],
			"s,s,s,s,s,d,d,h": ["仍外孙女婿"],
			"s,s,s,s,d": ["来孙女"],
			"s,s,s,s,d,h": ["来孙女婿"],
			"s,s,s,s,d,s": ["晜外孙"],
			"s,s,s,s,d,s,w": ["晜外孙媳妇"],
			"s,s,s,s,d,d": ["晜外孙女"],
			"s,s,s,s,d,d,h": ["晜外孙女婿"],
			"s,s,s,d": ["玄孙女", "元孙女", "膀孙女"],
			"s,s,s,d,h": ["玄孙女婿"],
			"s,s,s,d,s": ["来外孙"],
			"s,s,s,d,s,w": ["来外孙媳妇"],
			"s,s,s,d,d": ["来外孙女"],
			"s,s,s,d,d,h": ["来外孙女婿"],
			"s,s,d": ["曾孙女", "重孙女", "息女"],
			"s,s,d,h": ["曾孙女婿"],
			"s,s,d,s": ["玄外孙"],
			"s,s,d,s,w": ["玄外孙媳妇"],
			"s,s,d,d": ["玄外孙女"],
			"s,s,d,d,h": ["玄外孙女婿"],
			"s,d": ["孙女", "孙女儿", "孙囡", "孙囡儿", "女孙", "孙女子"],
			"s,d,h": ["孙女婿", "孙婿", "孙郎", "孙息婿"],
			"s,d,s": ["曾外孙", "外息仔"],
			"s,d,s,w": ["曾外孙媳妇"],
			"s,d,s,s": ["曾外曾孙"],
			"s,d,s,s,w": ["曾外曾孙媳妇"],
			"s,d,s,d": ["曾外曾孙女"],
			"s,d,s,d,h": ["曾外曾孙女婿"],
			"s,d,d": ["曾外孙女", "外息女"],
			"s,d,d,h": ["曾外孙女婿"],
			"s,d,d,s": ["曾外曾外孙"],
			"s,d,d,s,w": ["曾外曾外孙媳妇"],
			"s,d,d,d": ["曾外曾外孙女"],
			"s,d,d,d,h": ["曾外曾外孙女婿"],
			d: ["女儿", "千金", "小姐", "掌上明珠", "息女", "闺女", "囡囡", "囡女", "囡儿", "乖囡", "囡嗯", "丫头", "姑娘", "妮子", "女亲",
				"长女", "次女", "幼女", "女", "阿女", "女女"
			],
			"d,h": ["女婿", "姑爷", "姑爷儿", "女婿子", "女婿儿", "儿婿", "子婿", "息婿", "小婿", "快婿", "郎婿", "郎婿子", "息婿儿", "囝婿",
				"囡婿", "东床", "半子", "甥馆", "女夫"
			],
			"d,h,f": ["亲家公"],
			"d,h,f,f&o": ["姻伯"],
			"d,h,f,f&l": ["姻叔"],
			"d,h,m": ["亲家母"],
			"d,h,xb": ["姻侄", "世侄"],
			"d,h,xb,w": ["姻侄媳"],
			"d,h,xb,s": ["姻侄孙"],
			"d,h,xb,d": ["姻侄孙女"],
			"d,h,xs": ["姻侄女"],
			"d,h,xs,h": ["姻侄婿"],
			"d,h,xs,s": ["姻侄外孙"],
			"d,h,xs,d": ["姻侄外孙女"],
			"d,s": ["外孙", "外孙子", "外孙儿"],
			"d,s,w": ["外孙媳妇", "外孙妇", "外孙新妇"],
			"d,s,s": ["外曾孙", "重外孙", "外息仔"],
			"d,s,s,w": ["外曾孙媳妇", "外曾孙妇"],
			"d,s,s,s": ["外玄孙", "外元孙", "外膀孙"],
			"d,s,s,s,w": ["外玄孙媳妇"],
			"d,s,s,d": ["外玄孙女", "外元孙女", "外膀孙女"],
			"d,s,s,d,h": ["外玄孙女婿"],
			"d,s,d": ["外曾孙女", "重外孙女", "外息女"],
			"d,s,d,h": ["外曾孙女婿", "重外孙女婿"],
			"d,s,d,s": ["外玄外孙"],
			"d,s,d,s,w": ["外玄外孙媳妇"],
			"d,s,d,d": ["外玄外孙女"],
			"d,s,d,d,h": ["外玄外孙女婿"],
			"d,d": ["外孙女", "外孙囡", "外孙女儿"],
			"d,d,h": ["外孙女婿", "外孙婿", "外孙郎"],
			"d,d,s": ["外曾外孙", "外息仔"],
			"d,d,s,w": ["外曾外孙媳妇"],
			"d,d,s,s": ["外曾外曾孙"],
			"d,d,s,s,w": ["外曾外曾孙媳妇"],
			"d,d,s,d": ["外曾外曾孙女"],
			"d,d,s,d,h": ["外曾外曾孙女婿"],
			"d,d,d": ["外曾外孙女", "外息女"],
			"d,d,d,h": ["外曾外孙女婿"],
			"d,d,d,s": ["外曾外曾外孙"],
			"d,d,d,s,w": ["外曾外曾外孙媳妇"],
			"d,d,d,d": ["外曾外曾外孙女"],
			"d,d,d,d,h": ["外曾外曾外孙女婿"],
			"1,xb,w,xb": ["叔眷兄弟"],
			"1,xb,w,xb,s": ["叔眷舅男"],
			"1,xb,w,xb,d": ["叔眷舅女"],
			"1,xb,w,xs": ["叔眷姊妹"],
			"1,xb,w,xs,s": ["叔眷姨男"],
			"1,xb,w,xs,d": ["叔眷姨女"],
			"1,xb,s": ["从男", "从子"],
			"1,xb,s,s": ["从孙"],
			"1,xb,s,s,s": ["从曾孙"],
			"1,xb,s,s,s,s": ["从玄孙"],
			"1,xb,s,w": ["从妇"],
			"1,xb,d": ["从女", "从子"],
			"1,xb,d,h": ["从婿"],
			"1,xs,h,xb": ["姑姻兄弟"],
			"1,xs,h,xb,s": ["姑姻叔男"],
			"1,xs,h,xb,d": ["姑姻叔女"],
			"1,xs,h,xs": ["姑姻姊妹"],
			"1,xs,h,xs,s": ["姑姻姑男"],
			"1,xs,h,xs,d": ["姑姻姑女"],
			"1,xs,s,s": ["离孙男", "离孙子"],
			"1,xs,s,d": ["离孙女"],
			"0,xb,w,xb": ["舅眷兄弟"],
			"0,xb,w,xb,s": ["舅眷舅男"],
			"0,xb,w,xb,d": ["舅眷舅女"],
			"0,xb,w,xs": ["舅眷姊妹"],
			"0,xb,w,xs,s": ["舅眷姨男"],
			"0,xb,w,xs,d": ["舅眷姨女"],
			"0,xs,h,xb": ["姨姻兄弟"],
			"0,xs,h,xb,s": ["姨姻叔男"],
			"0,xs,h,xb,d": ["姨姻叔女"],
			"0,xs,h,xs": ["姨姻姊妹"],
			"0,xs,h,xs,s": ["姨姻姑男"],
			"0,xs,h,xs,d": ["姨姻姑女"],
			"0,xb,s": ["娘家侄子", "娘家侄"],
			"0,xb,s,s": ["归孙男", "归孙子"],
			"0,xb,s,d": ["归孙女"],
			"0,xb,d": ["娘家侄女"],
			"0,xs,s": ["姨甥", "姨甥男", "从男", "从子"],
			"0,xs,s,w": ["从妇"],
			"0,xs,d": ["姨甥女", "从女", "从子"],
			"0,xs,d,h": ["从婿"],
			"0,xs,s,s": ["姨甥孙", "姨孙", "姨甥孙男", "姨孙男"],
			"0,xs,s,d": ["姨甥孙女", "姨孙女"],
			"0,xs,d,s": ["姨甥外孙", "姨外孙", "姨甥外孙男", "姨外孙男"],
			"0,xs,d,d": ["姨甥外孙女", "姨外孙女"]
		};

	function p(s, f) {
		var x = Object.keys(s);
		if (Object.getOwnPropertySymbols) {
			var d = Object.getOwnPropertySymbols(s);
			f && (d = d.filter((function(f) {
				return Object.getOwnPropertyDescriptor(s, f).enumerable
			}))), x.push.apply(x, d)
		}
		return x
	}

	function G(s) {
		for (var f = 1; f < arguments.length; f++) {
			var x = null != arguments[f] ? arguments[f] : {};
			f % 2 ? p(Object(x), !0).forEach((function(f) {
				w(s, f, x[f])
			})) : Object.getOwnPropertyDescriptors ? Object.defineProperties(s, Object
				.getOwnPropertyDescriptors(x)) : p(Object(x)).forEach((function(f) {
				Object.defineProperty(s, f, Object.getOwnPropertyDescriptor(x, f))
			}))
		}
		return s
	}
	var $ = G({}, {
			"[f,f|f,m|m,f],[f,m],f": ["老太奶爷", "祖太奶爷"],
			"[f,f|f,m|m,f],[f,m],m": ["老太奶奶", "祖太奶奶"],
			"[f,m|m,f|m,m],[f,m],f": ["老太姥爷", "祖太姥爷"],
			"[f,m|m,f|m,m],[f,m],m": ["老太姥姥", "祖太姥姥"],
			"[f|m],[f|m],f": ["太老爷"],
			"[f|m],[f|m],f,ob": ["伯太老爷"],
			"[f|m],[f|m],f,ob,w": ["伯太老姥"],
			"[f|m],[f|m],f,lb": ["叔太老爷"],
			"[f|m],[f|m],f,lb,w": ["叔太老姥"],
			"[f|m],[f|m],f,xs": ["姑太老姥"],
			"[f|m],[f|m],f,xs,h": ["姑太老爷"],
			"[f|m],[f|m],m": ["太老姥"],
			"[f|m],[f|m],m,xb": ["舅太老爷"],
			"[f|m],[f|m],m,xb,w": ["舅太老姥"],
			"[f|m],[f|m],m,xs": ["姨太老姥"],
			"[f|m],[f|m],m,xs,h": ["姨太老爷"],
			"[f,f|f,m|m,f],f": ["太奶爷", "祖奶爷", "祖爷爷"],
			"[f,f|f,m|m,f],f,ob": ["伯太奶爷", "太伯奶爷"],
			"[f,f|f,m|m,f],f,ob,w": ["伯太奶奶", "太伯奶奶"],
			"[f,f|f,m|m,f],f,lb": ["叔太奶爷", "太叔奶爷"],
			"[f,f|f,m|m,f],f,lb,w": ["叔太奶奶", "太叔奶奶"],
			"[f,f|f,m|m,f],f,xs": ["姑太奶奶", "太姑奶奶"],
			"[f,f|f,m|m,f],f,xs,h": ["姑太奶爷", "太姑奶爷"],
			"[f,f|f,m|m,f],m": ["太奶奶", "祖奶奶"],
			"[f,f|f,m|m,f],m,xb": ["舅太奶爷", "太舅奶爷"],
			"[f,f|f,m|m,f],m,xb,w": ["舅太奶奶", "太舅奶奶"],
			"[f,f|f,m|m,f],m,xs": ["姨太奶奶", "太姨奶奶"],
			"[f,f|f,m|m,f],m,xs,h": ["姨太奶爷", "太姨奶爷"],
			"[f,m|m,f|m,m],f": ["太姥爷", "祖姥爷", "太毑爷"],
			"[f,m|m,f|m,m],f,ob": ["伯太姥爷", "伯叔姥爷"],
			"[f,m|m,f|m,m],f,ob,w": ["伯太姥姥", "太伯姥姥"],
			"[f,m|m,f|m,m],f,lb": ["叔太姥爷", "太叔姥爷"],
			"[f,m|m,f|m,m],f,lb,w": ["叔太姥姥", "太叔姥姥"],
			"[f,m|m,f|m,m],f,xs": ["姑太姥姥", "太姑姥姥"],
			"[f,m|m,f|m,m],f,xs,h": ["姑太姥爷", "太姑姥爷"],
			"[f,m|m,f|m,m],m": ["太姥姥", "祖姥姥", "太毑毑", "太姥"],
			"[f,m|m,f|m,m],m,xb": ["舅太姥爷", "太舅姥爷"],
			"[f,m|m,f|m,m],m,xb,w": ["舅太姥姥", "太舅姥姥"],
			"[f,m|m,f|m,m],m,xs": ["姨太姥姥", "太姨姥姥"],
			"[f,m|m,f|m,m],m,xs,h": ["姨太姥爷", "太姨姥爷"],
			"[f|m],[f|m],[f|m]": ["曾祖辈", "祖祖", "老太", "阿太"],
			"[f|m],[f|m]": ["祖辈"],
			"[f|m],f": ["老爷"],
			"[f|m],f,ob": ["伯老爷"],
			"[f|m],f,ob,w": ["伯老姥"],
			"[f|m],f,lb": ["叔老爷"],
			"[f|m],f,lb,w": ["叔老姥"],
			"[f|m],f,xs": ["姑老姥"],
			"[f|m],f,xs,h": ["姑老爷"],
			"[f|m],m": ["老姥"],
			"[f|m],m,xb": ["舅老爷"],
			"[f|m],m,xb,w": ["舅老姥"],
			"[f|m],m,xs": ["姨老姥"],
			"[f|m],m,xs,h": ["姨老爷"],
			"f,f,[f|m]": ["曾祖父母"],
			"f,f,[f,xs|m,xb],s": ["舅姑爷爷", "舅姑爷"],
			"f,[f|m]": ["祖父母", "爷爷奶奶"],
			"f,[ob|ob,w]": ["伯父母"],
			"f,[lb|lb,w]": ["叔父母"],
			"f,xb,[s|d]": ["堂兄弟姐妹", "堂姐妹兄弟", "从父兄弟姐妹"],
			"f,[xs|xs,h]": ["姑父母"],
			"f,xs,[s|d]": ["姑表兄弟姐妹"],
			"m,[f|m],f": ["老外公", "老外爷", "老姥爷"],
			"m,[f|m],m,": ["老外婆", "老外奶", "老姥姥", "老姥娘", "老嫏娘"],
			"m,[f|m]": ["外祖父母", "外公外婆", "姥姥姥爷"],
			"m,f,[f,xs|m,xb],s": ["舅姑姥爷"],
			"m,[xb|xb,w]": ["舅父母"],
			"m,xb,[s|d]": ["舅表兄弟姐妹"],
			"m,[xs|xs,h]": ["姨父母"],
			"m,xs,[s|d]": ["姨兄弟姐妹", "姨姐妹兄弟", "从母兄弟姐妹"],
			"[f|m]": ["父母", "爹娘", "爹妈", "爸妈", "爸爸妈妈", "父母亲", "双亲", "二亲", "两亲", "二老", "高堂"],
			"[f|m],[f,xs|m,xb],s": ["舅姑爸", "姑舅爸"],
			"[f|m],[f,xs|m,xb],s&o,w": ["舅姑姆", "姑舅姆"],
			"[f|m],[f,xs|m,xb],s&l,w": ["舅姑婶", "姑舅婶"],
			"[f|m],[f,xs|m,xb],d": ["姑舅娘娘"],
			"[f|m],m,xs,s": ["两姨爸"],
			"[f|m],m,xs,s&o,w": ["两姨姆"],
			"[f|m],m,xs,s&l,w": ["两姨婶"],
			"[f|m],m,xs,d": ["两姨娘娘"],
			"w,[f|m]": ["岳父母", "岳父岳母", "丈人丈母", "舅姑"],
			"w,f,[ob|ob,w]": ["伯岳父母"],
			"w,f,[lb|lb,w]": ["叔岳父母"],
			"w,f,[xs|xs,h]": ["姑岳父母"],
			"w,m,[xb|xb,w]": ["舅岳父母"],
			"w,m,[xs|xs,h]": ["姨岳父母"],
			"w,[f,xs|m,xb],d": ["姑舅姨子"],
			"w,[f,xs|m,xb],d,h": ["姑舅连襟", "姑舅连桥"],
			"h,[f|m]": ["公婆", "翁姑", "姑翁", "姑舅", "大家官", "公公婆婆", "姑章", "姑嫜"],
			"h,f,[ob|ob,w]": ["伯公婆"],
			"h,f,[lb|lb,w]": ["叔公婆"],
			"h,f,[xs|xs,h]": ["姑公婆"],
			"h,m,[xb|xb,w]": ["舅公婆"],
			"h,m,[xs|xs,h]": ["姨公婆"],
			"[xb|xs]": ["兄弟姐妹", "同胞", "同胞兄弟姐妹", "手足"],
			"[ob|os]": ["哥哥姐姐"],
			"[lb|ls]": ["弟弟妹妹"],
			"[ob|ob,w]": ["哥哥嫂嫂", "兄嫂"],
			"[f,xb|m,xs],[s|d]": ["从兄弟姐妹", "从姐妹兄弟"],
			"[f,xs|m,xb],[s|d]": ["表兄弟姐妹", "表姐妹兄弟", "老表", "阿表"],
			"[f,xs|m,xb],s": ["姑舅兄弟", "舅姑兄弟"],
			"[f,xs|m,xb],s&o": ["姑舅哥", "姑舅哥哥"],
			"[f,xs|m,xb],s&l": ["姑舅弟", "姑舅弟弟"],
			"[f,xs|m,xb],d": ["姑舅姊妹", "舅姑姊妹"],
			"[f,xs|m,xb],d&o": ["姑舅姐", "姑舅姐姐"],
			"[f,xs|m,xb],d&l": ["姑舅妹", "姑舅妹妹"],
			"[f,xs|m,xb],s,s": ["姑舅儿子"],
			"[f,xs|m,xb],s,d": ["姑舅女儿"],
			"[xb|xs],[s|d]": ["侄甥"],
			"xb,[s|d]": ["侄子女", "侄子侄女"],
			"xs,[s|d]": ["甥子女", "外甥子女"],
			"[w|s|d]": ["妻儿", "妻小"],
			"[w|d]": ["妻女"],
			"[s|d]": ["子女", "儿女", "仔女", "小孩", "孩子", "孩子们", "孩儿", "小孩儿", "宝宝", "宝贝", "娃", "娃子", "儿辈", "子辈",
				"细伢", "伢子", "子息", "子嗣", "崽", "幺儿"
			],
			"[s|d],[s|d]": ["孙辈", "孙息", "孙枝"],
			"s,[s|d]": ["孙子女"],
			"d,[s|d]": ["外孙子女"],
			"s#xb,s": ["子侄"],
			"s#s,w": ["子媳"],
			"[s|d]#[s|d],[s|d]": ["儿孙", "子孙", "孙息"],
			"[s,w|d,h],[f|m]": ["亲家", "儿女亲家"],
			"[s,w|d,h],f": ["亲家公", "亲家父", "亲家翁", "亲家世翁", "姻翁"],
			"[s,w|d,h],f,f": ["太姻翁"],
			"[s,w|d,h],f,m": ["太姻姆"],
			"[s,w|d,h],f,f,f": ["太姻翁"],
			"[s,w|d,h],f,f,m": ["太姻姆"],
			"[s,w|d,h],f,f,ob": ["姻伯翁"],
			"[s,w|d,h],f,f,ob,w": ["姻伯姆"],
			"[s,w|d,h],f,f,lb": ["姻叔翁"],
			"[s,w|d,h],f,f,lb,w": ["姻叔母"],
			"[s,w|d,h],f,f,xb,s&o": ["姻家兄"],
			"[s,w|d,h],f,f,xb,s&o,w": ["姻家兄妇"],
			"[s,w|d,h],f,f,xb,s&l": ["姻家弟"],
			"[s,w|d,h],f,f,xb,s&l,w": ["姻家弟妇"],
			"[s,w|d,h],f,f,xb,s,s": ["姻家侄"],
			"[s,w|d,h],f,f,xb,s,s,w": ["姻家侄妇"],
			"[s,w|d,h],f,ob": ["姻兄"],
			"[s,w|d,h],f,ob,w": ["姻兄妇"],
			"[s,w|d,h],f,lb": ["姻弟"],
			"[s,w|d,h],f,lb,w": ["姻弟妇"],
			"[s,w|d,h],f,xb,s": ["姻侄"],
			"[s,w|d,h],f,xb,s,w": ["姻侄妇"],
			"[s,w|d,h],m": ["亲家母", "亲家婆", "亲家姆", "亲姆", "姻姆"],
			"[s,w|d,h],m,ob": ["姻仁兄"],
			"[s,w|d,h],m,ob,w": ["姻仁兄妇"],
			"[s,w|d,h],m,lb": ["姻仁弟"],
			"[s,w|d,h],m,lb,w": ["姻仁弟妇"],
			"[s,w|d,h],[f|m],f": ["姻太翁"],
			"[s,w|d,h],[f|m],m": ["姻太姆"]
		}),
		v = {},
		W = function(s) {
			v[s] = {};
			var f = function(f) {
				fs(f).forEach((function(x) {
					v[s][x] = c[s][f]
				}))
			};
			for (var x in c[s]) f(x)
		};
	for (var y in c) W(y);
	var g = {},
		O = function(s) {
			fs(s).forEach((function(f) {
				g[f] = i[s]
			}))
		};
	for (var j in i) O(j);
	for (var S in $ = G(G({}, $), function(s, f) {
			var x = {},
				d = function() {
					var d = r.match(/\{.+?\}/)[0],
						m = f[r],
						e = function() {
							var f = s[d][o],
								e = r.replace(d, o);
							if (!["h,h", "w,w", "w,h", "h,w"].some((function(s) {
									return e.includes(s)
								}))) {
								var t = f.flatMap((function(s) {
									return m.map((function(f) {
										return f.includes("?") ? f.replace("?",
											s) : s + f
									}))
								}));
								x[e] || (x[e] = $[e] || []), x[e] = t.concat(x[e])
							}
						};
					for (var o in s[d]) e()
				};
			for (var r in f) d();
			return x
		}(v, g)), u) $[S] = [].concat(x(u[S]), x($[S] || []));
	$.o = ["passer-by.com", "作者"];
	var P = {
			w: ["妻", "内", "岳", "岳家", "丈人"],
			h: ["夫", "外", "公", "婆家", "婆婆"]
		},
		E = new Set(Object.values($).flat());
	for (var A in $)
		if (A.match(/^[fm]/) || A.match(/^[olx][bs]$|^[olx][bs],[^mf]/)) {
			var D = function() {
				var s = N + "," + A;
				if (A.match(/[fm]/)) {
					var f = s.replace(/,[ol]([sb])(,[wh])?$/, ",x$1$2").replace(/(,[sd])&[ol](,[wh])?$/,
						"$1$2");
					if (f != s && $[f]) return 1
				}
				$[s] || ($[s] = []);
				var x = P[N],
					d = $[A];
				x.forEach((function(f) {
					d.forEach((function(x) {
						var d = f + x;
						E.has(d) || $[s].push(d)
					}))
				}))
			};
			for (var N in P) D()
		} var I = $;

	function k(s, f) {
		var x = Object.keys(s);
		if (Object.getOwnPropertySymbols) {
			var d = Object.getOwnPropertySymbols(s);
			f && (d = d.filter((function(f) {
				return Object.getOwnPropertyDescriptor(s, f).enumerable
			}))), x.push.apply(x, d)
		}
		return x
	}

	function T(s) {
		for (var f = 1; f < arguments.length; f++) {
			var x = null != arguments[f] ? arguments[f] : {};
			f % 2 ? k(Object(x), !0).forEach((function(f) {
				w(s, f, x[f])
			})) : Object.getOwnPropertyDescriptors ? Object.defineProperties(s, Object
				.getOwnPropertyDescriptors(x)) : k(Object(x)).forEach((function(f) {
				Object.defineProperty(s, f, Object.getOwnPropertyDescriptor(x, f))
			}))
		}
		return s
	}
	var C = {},
		U = T({}, I);

	function q(s, f) {
		var x = Object.keys(s);
		if (Object.getOwnPropertySymbols) {
			var d = Object.getOwnPropertySymbols(s);
			f && (d = d.filter((function(f) {
				return Object.getOwnPropertyDescriptor(s, f).enumerable
			}))), x.push.apply(x, d)
		}
		return x
	}

	function z(s) {
		for (var f = 1; f < arguments.length; f++) {
			var x = null != arguments[f] ? arguments[f] : {};
			f % 2 ? q(Object(x), !0).forEach((function(f) {
				w(s, f, x[f])
			})) : Object.getOwnPropertyDescriptors ? Object.defineProperties(s, Object
				.getOwnPropertyDescriptors(x)) : q(Object(x)).forEach((function(f) {
				Object.defineProperty(s, f, Object.getOwnPropertyDescriptor(x, f))
			}))
		}
		return s
	}

	function B(s, f) {
		if (!s) return [""];
		var x = {
				f: ["d", "s"],
				m: ["d", "s"],
				h: ["w", ""],
				w: ["", "h"],
				s: ["m", "f"],
				d: ["m", "f"],
				lb: ["os", "ob"],
				ob: ["ls", "lb"],
				xb: ["xs", "xb"],
				ls: ["os", "ob"],
				os: ["ls", "lb"],
				xs: ["xs", "xb"]
			},
			d = "";
		s.match(/&o$/) ? d = "&l" : s.match(/&l$/) && (d = "&o"), s = s.replace(/&[ol\d+]/g, ""), f < 0 && (s
			.match(/^w/) ? f = 1 : s.match(/^h/) && (f = 0));
		var r = function(f) {
			var r = ("," + f + "," + s).replace(/,[fhs]|,[olx]b/g, ",1").replace(/,[mwd]|,[olx]s/g, ",0"),
				m = r.slice(0, r.length - 2).split(",").reverse(),
				e = s.split(",").reverse().map((function(s, f) {
					return x[s][m[f]]
				})).join(",");
			return e + (H(e) ? "" : d)
		};
		return f < 0 ? [r(1), r(0)] : [r(f)]
	}

	function F(s) {
		var f = s.filter((function(s) {
			return s === s.replace(/[ol](?=[s|b])/g, "x").replace(/&[ol]/, "")
		}));
		return s.filter((function(s) {
			var x = s.replace(/[ol](?=[s|b])/g, "x").replace(/&[ol]/, "");
			return f.includes(s) || s != x && !f.includes(x)
		})).filter((function(s, f, x) {
			return x.indexOf(s) === f
		}))
	}

	function H(s) {
		var f = {
				f: 1,
				m: 1,
				s: -1,
				d: -1
			},
			x = 0;
		return s.split(",").forEach((function(s) {
			var d = s.replace(/&[ol\d]+/, "");
			x += f[d] || 0
		})), x
	}

	function J(s) {
		var f = [],
			x = function(s) {
				var f = [],
					x = s.replace(/(,[sd])(,[wh])?$/, "$1&o$2"),
					d = s.replace(/(,[sd])(,[wh])?$/, "$1&l$2");
				return U[x] && U[d] ? f = [x, d] : U[s] && (f = [s]), F(f).map((function(s) {
					return U[s][0]
				}))
			};
		if (s.match(/&([\d]+)(,[hw])?$/)) {
			var d = function(s) {
				var f = "",
					x = {
						1: "大",
						99: "小"
					};
				if (x[s]) f = x[s];
				else {
					var d = ~~(s / 10),
						r = s % 10;
					f = (d ? (l[d] + "十").replace("一十", "十") : "") + l[r]
				}
				return f
			}(s.match(/&([\d]+)(,[hw])?$/)[1]);
			if (s = s.replace(/&\d+/g, ""), a[s]) f.push(a[s][0].replace("几", d));
			else if (U[s]) {
				var r = H(s),
					m = "";
				r < 3 && !s.match(/[hw],/) && (U[s].forEach((function(s) {
					!m && s.includes("几") && (m = s.replace("几", d))
				})), m || (m = (m = U[s][0]).match(/^[大小]/) ? m.replace(/^[大小]/, d) : d + m)), f.push(m)
			}
		}
		if (f.length || (f = x(s = s.replace(/&\d+/g, ""))), f.length || (f = x(s = s.replace(/&[ol]/g, ""))), f
			.length || (f = x(s = s.replace(/[ol](b|s)/g, "x$1"))), !f.length) {
			var e = s.replace(/x/g, "l"),
				o = s.replace(/x/g, "o");
			f = f.concat(x(o), x(e))
		}
		return f
	}
	var K = z(z({}, U), {}, {
		xb: ["兄弟"],
		xs: ["姐妹"]
	});

	function L(s) {
		var f = arguments.length > 1 && void 0 !== arguments[1] ? arguments[1] : -1,
			x = s.split(",").map((function(s) {
				var f = s.replace(/&[ol\d]+/, "");
				return K[f][0]
			})).join("的");
		return f > -1 && K[f + "," + s] && (0 == f ? x = "(女性)" + x : 1 == f && (x = "(男性)" + x)), x
	}

	function Q(s, f) {
		var x = Object.keys(s);
		if (Object.getOwnPropertySymbols) {
			var d = Object.getOwnPropertySymbols(s);
			f && (d = d.filter((function(f) {
				return Object.getOwnPropertyDescriptor(s, f).enumerable
			}))), x.push.apply(x, d)
		}
		return x
	}

	function R(s, f) {
		return Object.entries(f).forEach((function(f) {
			var x = b(f, 2),
				d = x[0],
				r = x[1];
			s[d] = (s[d] || []).concat(r)
		})), s
	}
	var V = R(function(s) {
		for (var f = 1; f < arguments.length; f++) {
			var x = null != arguments[f] ? arguments[f] : {};
			f % 2 ? Q(Object(x), !0).forEach((function(f) {
				w(s, f, x[f])
			})) : Object.getOwnPropertyDescriptors ? Object.defineProperties(s, Object
				.getOwnPropertyDescriptors(x)) : Q(Object(x)).forEach((function(f) {
				Object.defineProperty(s, f, Object.getOwnPropertyDescriptor(x, f))
			}))
		}
		return s
	}({}, U), {
		xb: ["兄弟", "亲兄弟", "同胞兄弟"],
		"xb,w": ["兄弟媳妇", "兄弟妇"],
		xs: ["姐妹", "亲姐妹", "同胞姐妹"],
		"xs,h": ["姐妹夫", "姊妹婿"],
		"f,xb": ["伯叔父"],
		"f,xb,w": ["伯叔母"],
		"f,f,xb": ["从祖祖父", "从祖父"],
		"f,f,xb,w": ["从祖祖母", "从祖母"],
		"m,f,xb": ["外从祖祖父"],
		"m,f,xb,w": ["外从祖祖母"],
		"h,xb": ["伯叔"],
		"h,xb,w": ["妯娌", "娣姒", "娣姒姊妹", "婶子"]
	});
	V = R(V, a);
	var X = {};

	function Y(s, f) {
		var x = "undefined" != typeof Symbol && s[Symbol.iterator] || s["@@iterator"];
		if (!x) {
			if (Array.isArray(s) || (x = function(s, f) {
					if (s) {
						if ("string" == typeof s) return Z(s, f);
						var x = {}.toString.call(s).slice(8, -1);
						return "Object" === x && s.constructor && (x = s.constructor.name), "Map" === x ||
							"Set" === x ? Array.from(s) : "Arguments" === x ||
							/^(?:Ui|I)nt(?:8|16|32)(?:Clamped)?Array$/.test(x) ? Z(s, f) : void 0
					}
				}(s)) || f && s && "number" == typeof s.length) {
				x && (s = x);
				var d = 0,
					r = function() {};
				return {
					s: r,
					n: function() {
						return d >= s.length ? {
							done: !0
						} : {
							done: !1,
							value: s[d++]
						}
					},
					e: function(s) {
						throw s
					},
					f: r
				}
			}
			throw new TypeError(
				"Invalid attempt to iterate non-iterable instance.\nIn order to be iterable, non-array objects must have a [Symbol.iterator]() method."
				)
		}
		var m, e = !0,
			o = !1;
		return {
			s: function() {
				x = x.call(s)
			},
			n: function() {
				var s = x.next();
				return e = s.done, s
			},
			e: function(s) {
				o = !0, m = s
			},
			f: function() {
				try {
					e || null == x.return || x.return()
				} finally {
					if (o) throw m
				}
			}
		}
	}

	function Z(s, f) {
		(null == f || f > s.length) && (f = s.length);
		for (var x = 0, d = Array(f); x < f; x++) d[x] = s[x];
		return d
	}
	Object.entries(V).forEach((function(s) {
		var f = b(s, 2),
			x = f[0];
		f[1].forEach((function(s) {
			X[s] || (X[s] = []), X[s].push(x)
		}))
	}));

	function _(s) {
		(s = s.replace(/之/g, "的").replace(/吾之?(.+)/, "$1").replace(/我的?(.+)/, "$1")).match(
			/[^娘婆岳亲]家的?(孩子|儿子|女儿)/) && (s = s.replace(/家的?/, "的"));
		for (var f = (s = (s = (s = s.replace(/(舅|姑)+(爸|父|丈|妈|母)?家的?(哥|姐|弟|妹)+/, "$1表$3").replace(
					/(舅|姑)+(爸|父|丈|妈|母)?家的?/, "$1表")).replace(/(伯|叔)+(父|母)?家的?(哥|姐|弟|妹)+/, "堂$3")
				.replace(/(伯|叔)+(父|母)?家的?/, "堂")).replace(/姨+(爸|父|丈|妈|母)?家的?(哥|姐|弟|妹)+/, "姨$2").replace(
				/姨+(爸|父|丈|妈|母)?家的?/, "姨")).split("的"), x = [], d = !0, r = function() {
				var s = f.shift(),
					r = [],
					m = [s],
					e = function(s) {
						for (var f in o.forEach((function(f) {
								f.arr.forEach((function(x) {
									var d = s.replace(f.exp, x);
									d != s && (m.push(d), e(d))
								}))
							})), t) {
							var x = s.replace(f, t[f]),
								d = s.replace(t[f], f);
							x != s && m.push(x), d != s && m.push(d)
						}
					};
				e(s);
				var n = [
					[],
					[],
					[]
				];
				m.forEach((function(s) {
					var f = (s = s.replace(/^[尕幺细满碎晚末尾幼]/, "小")).match(
						/^[大|小]|^[一|二|三|四|五|六|七|八|九|十]+/);
					if (f) {
						var x = s.replace(f[0], "几"),
							d = s.replace(f[0], ""),
							m = function(s) {
								var f = 0,
									x = {
										"大": 1,
										"小": 99
									};
								if (x[s]) f = x[s];
								else {
									var d = b(s.replace(/^十/, "一十").split("十").map((function(
										s) {
											return l.indexOf(s)
										})).reverse(), 2),
										r = d[0],
										m = d[1];
									f = 10 * (void 0 === m ? 0 : m) + r
								}
								return f
							}(f[0]);
						[x, d, s].forEach((function(s, f) {
							var x = X[s];
							x && x.length && x.forEach((function(x) {
								var d = x.replace(/(,[hw])$/, "&" + m +
									"$1").replace(/([^hw]+)$/,
									"$1&" + m);
								x.match(/^[mf,]+$/) || s.match(
									/^[从世]/) || n[f].push(d)
							}))
						}))
					}
					r = r.concat(X[s] || [])
				})), n.forEach((function(s) {
					r.length || (r = s)
				})), r.length || (d = !1);
				var h = [];
				x.length || (x = [""]), x.forEach((function(s) {
					r.forEach((function(f) {
						h.push(s + (f ? "," + f : ""))
					}))
				})), x = h
			}; f.length;) r();
		return d ? F(x) : []
	}

	function ss(s) {
		var f = s.from,
			x = s.to,
			d = s.sex;
		if (d < 0) {
			var r = f.match(/^,[w1]/) ? 1 : f.match(/^,[h0]/) ? 0 : -1,
				m = x.match(/^,[w1]/) ? 1 : x.match(/^,[h0]/) ? 0 : -1;
			if (-1 === r && m > -1) d = m;
			else if (r > -1 && -1 === m) d = r;
			else {
				if (r !== m) return [];
				d = r
			}
		}
		var e = xs(s.from, d),
			o = xs(s.to, d);
		if (!e.length || !o.length) return [];
		var t = [];
		return e.forEach((function(f) {
			o.forEach((function(x) {
				var r = d,
					m = "," + x;
				if (m.match(/,([fhs1](&[ol\d]+)?|[olx]b)(&[ol\d]+)?$/) && (r = 1), m
					.match(/,([mwd0](&[ol\d]+)?|[olx]s)(&[ol\d]+)?$/) && (r = 0), f && x
					) {
					var e = s.optimal;
					if ((f.match(/&\d+/) || x.match(/&\d+/)) && (e = !0), e) {
						var o = function(s) {
							for (var f = s.from, x = s.to, d = s.sex, r = f.split(
									","), m = x.split(","), e = 0; e < r.length &&
								e < m.length; e++) {
								if (r[e] != m[e]) {
									if (H(r[e]) == H(m[e]) && r[e].match(
											/^[xol][bs]|^[sd]/) && m[e].match(
											/^[xol][bs]|^[sd]/)) {
										var o, t, b, l;
										if (r[e].replace(/&([ol\d]+)/, "").replace(
												/^[xol]([bs])/, "$1") != m[e]
											.replace(/&([ol\d]+)/, "").replace(
												/^[xol]([bs])/, "$1")) break;
										var n = (null === (o = r[e].match(
													/&([ol\d]+)/)) || void 0 === o ?
												void 0 : o[1]) || (null === (t = r[
													e].match(/([ol])[bs]/)) ||
												void 0 === t ? void 0 : t[1]) || "",
											h = (null === (b = m[e].match(
													/&([ol\d]+)/)) || void 0 === b ?
												void 0 : b[1]) || (null === (l = m[
													e].match(/([ol])[bs]/)) ||
												void 0 === l ? void 0 : l[1]) || "";
										if (n && h) isNaN(n) || isNaN(h) ? !isNaN(
											n) && "o" == h || "l" == n && !isNaN(
											h) ? r[e] = r[e].replace(/^[xol]b|^s/,
												"lb").replace(/^[xol]s|^d/, "ls") :
											(!isNaN(n) && "l" == h || "o" == n && !
												isNaN(h)) && (r[e] = r[e].replace(
												/^[xol]b|^s/, "ob").replace(
												/^[xol]s|^d/, "os")) : +n > +h ? r[
												e] = r[e].replace(/^[xol]b|^s/,
												"lb").replace(/^[xol]s|^d/, "ls") :
											+n < +h && (r[e] = r[e].replace(
												/^[xol]b|^s/, "ob").replace(
												/^[xol]s|^d/, "os")), f = r.slice(e)
											.join(","), x = m.slice(e + 1).join(
											","), d = m[e].match(
												/^([fhs1](&[ol\d]+)?|[olx]b)(&[ol\d]+)?/
												) ? 1 : 0;
										else if (s.optimal) {
											var w, M;
											if (n = (null === (w = r[e].match(
														/([xol])[bs]/)) ||
													void 0 === w ? void 0 : w[1]) ||
												"", h = (null === (M = m[e].match(
														/([xol])[bs]/)) ||
													void 0 === M ? void 0 : M[1]) ||
												"", "x" == n || "x" == h) {
												f = r.slice(e + 1).join(","), x = m
													.slice(e + 1).join(","), d = r[
														e].match(
														/^([fhs1](&[ol\d]+)?|[olx]b)(&[ol\d]+)?/
														) ? 1 : 0;
												continue
											}
										}
									}
									break
								}
								f = r.slice(e + 1).join(","), x = m.slice(e + 1)
									.join(","), d = r[e].match(
										/^([fhs1](&[ol\d]+)?|[olx]b)(&[ol\d]+)?/) ?
									1 : 0
							}
							return {
								from: f,
								to: x,
								sex: d
							}
						}({
							from: f,
							to: x,
							sex: d,
							optimal: s.optimal
						});
						f = o.from, x = o.to, d = o.sex
					}
				}(x ? B(x, d) : [""]).forEach((function(s) {
					var x = (s ? "," + s : "") + (f ? "," + f : "");
					t.push({
						selector: x,
						sex: r
					})
				}))
			}))
		})), t
	}

	function fs(s) {
		var f = [],
			x = {},
			d = function(s) {
				if (!x[s]) {
					x[s] = !0;
					var r = "";
					do {
						r = s;
						var m, o = Y(e);
						try {
							for (o.s(); !(m = o.n()).done;) {
								var t = m.value;
								if ((s = s.replace(t.exp, t.str)).includes("#")) return s.split("#").forEach(d),
									!1
							}
						} catch (s) {
							o.e(s)
						} finally {
							o.f()
						}
					} while (r != s);
					if (s.match(/,[mwd0](&[ol\d+])?,w|,[hfs1](&[ol\d]+)?,h/)) return !1;
					f.push(s)
				}
			};
		return d(s), f
	}

	function xs(s, f) {
		if (s.match(/^,/) || (s = "," + s), f < 0) s.match(/^,[w1]/) ? f = 1 : s.match(/^,[h0]/) && (f = 0);
		else {
			if (1 == f && s.match(/^,[h0]/)) return [];
			if (0 == f && s.match(/^,[w1]/)) return []
		}
		if (f > -1 && !s.includes(",1") && !s.includes(",0") && (s = "," + f + s), s.match(
				/,[mwd0](&[ol\d]+)?,w|,[hfs1](&[ol\d]+)?,h/)) return [];
		var x = fs(s).map((function(s) {
			return s.replace(/,[01]/, "").substr(1)
		}));
		return F(x)
	}
	var ds = function(s) {
		"string" == typeof s && (s = function(s) {
			var f, x = r(d);
			try {
				for (x.s(); !(f = x.n()).done;) {
					var m = f.value,
						e = s.match(m.exp);
					if (e) return m.opt(e)
				}
			} catch (s) {
				x.e(s)
			} finally {
				x.f()
			}
			return {}
		}(s));
		var f = Object.assign({
			text: "",
			target: "",
			sex: -1,
			type: "default",
			reverse: !1,
			mode: "default",
			optimal: !1
		}, s);
		! function(s) {
			if (U = T({}, I), s && C[s])
				for (var f in C[s]) U[f] = [].concat(C[s][f], I[f] || [])
		}(f.mode);
		var m = _(f.text),
			e = _(f.target);
		e.length || (e = [""]);
		var o = m.flatMap((function(s) {
			return e.flatMap((function(x) {
				return ss({
					from: s,
					to: x,
					sex: f.sex,
					optimal: f.optimal
				}).flatMap((function(s) {
					return (s ? xs(s.selector, s.sex) : []).flatMap((
						function(x) {
							var d = [x],
								r = s.sex;
							return f.reverse && (d = B(x, r),
									r = x.match(
										/([fhs1](&[ol\d]+)?|[olx]b)$/
										) ? 1 : 0), "chain" ===
								f.type ? d.map((function(s) {
									return L(s, r)
								})).filter((function(s) {
									return s
								})) : "pair" === f.type ? B(x, s
									.sex).flatMap((function(s) {
									return function(s,
										f) {
										s = s
											.replace(
												/&\d+/g,
												""),
											f = f
											.replace(
												/&\d+/g,
												"");
										var x = s
											.replace(
												/([ol])([bs])/g,
												"x$2"
												),
											d = f
											.replace(
												/([ol])([bs])/g,
												"x$2"
												),
											r = s
											.replace(
												/&[ol]/g,
												""),
											m = f
											.replace(
												/&[ol]/g,
												""),
											e = [],
											o = [],
											t = [];
										for (var b in
												M) {
											var l =
												b
												.split(
													"#"
													);
											if (l
												.length >
												1) {
												var n =
													xs(l[
														0]),
													h =
													xs(l[
														1]),
													w =
													n
													.map(
														(function(
															s
															) {
															return s
																.replace(
																	/&[ol\d]+/,
																	""
																	)
																.replace(
																	/([ol])([bs])/,
																	"x$2"
																	)
														})
														),
													a =
													h
													.map(
														(function(
															s
															) {
															return s
																.replace(
																	/&[ol\d]+/,
																	""
																	)
																.replace(
																	/([ol])([bs])/,
																	"x$2"
																	)
														})
														);
												(n.includes(
														s
														) &&
													h
													.includes(
														f
														) ||
													n
													.includes(
														f
														) &&
													h
													.includes(
														s
														)
													) &&
												e.push(M[
															b]
														[
															0]
														),
													(w.includes(
															x
															) &&
														a
														.includes(
															d
															) ||
														w
														.includes(
															d
															) &&
														a
														.includes(
															x
															)
														) &&
													o
													.push(
														M[
															b]
														[
															0]
														),
													(w.includes(
															r
															) &&
														a
														.includes(
															m
															) ||
														w
														.includes(
															m
															) &&
														a
														.includes(
															r
															)
														) &&
													t
													.push(
														M[
															b]
														[
															0]
														)
											}
										}
										return e
											.length ||
											(e = o),
											e
											.length ||
											(e = t),
											e
									}(x, s)
								})) : d.flatMap((function(s) {
									var f = J(s);
									return f.length || (
										f = J(r +
											"," + s)
										), f
								}))
						}))
				}))
			}))
		}));
		return x(new Set(o))
	};
	return ds.data = U, ds.dataCount = Object.keys(U).length, ds.setMode = function(s, f) {
		C[s] = T(T({}, C[s] || {}), f)
	}, ds
}));