precision mediump float;
varying vec4 v_uvCoord0;
varying vec4 v_uvCoord1;

#ifdef VTG_TEXEL0_EXTS
uniform samplerExternalOES u_sampler0;
#else
uniform sampler2D u_sampler0;
#endif

#ifdef VTG_TEXEL1_EXTS
uniform samplerExternalOES u_sampler1;
#else
uniform sampler2D u_sampler1;
#endif

uniform vec4 u_aOpacity;

vec4 vtg_rgba_2_lcha(vec4 rgba) {
   const vec4 c_rgba_2_luma = vec4(0.299, 0.587, 0.114, 0.0);
   vec4 lcha = vec4(0.0, 0.0, 0.0, rgba.w);
   lcha.x = dot(c_rgba_2_luma, rgba);
   vec4 sort = rgba;
   if (sort.x < sort.y) sort.xy = sort.yx;
   if (sort.x < sort.z) sort.xz = sort.zx;
   if (sort.y < sort.z) sort.yz = sort.zy;
   lcha.y = sort.x - sort.z;
   if (0.0 != lcha.y) {
       vec3 delc = (sort.xxx - rgba.xyz + lcha.y * 3.0) / (lcha.y * 6.0);
       if (sort.x == rgba.x)
           lcha.z = delc.z - delc.y;
       else if (sort.x == rgba.y)
           lcha.z = delc.x - delc.z + 0.333333;
       else
           lcha.z = delc.y - delc.x + 0.666667;
       if (lcha.z < 0.0)
           lcha.z += 1.0;
       else if (lcha.z > 1.0)
           lcha.z -= 1.0;
   }
   return lcha;
}

vec4 vtg_lcha_2_rgba(vec4 lcha) {
   const vec3 c_rgb_2_luma = vec3(0.299, 0.587, 0.114);
   vec4 rgba = vec4(lcha.xxx, lcha.w);
   if (0.0 != lcha.y) {
       vec3  k = vec3(0.0);
       float h = lcha.z * 6.0;
       float x = lcha.x * (1.0 - abs(mod(h, 2.0) - 1.0));
       if (h < 1.0)
           k.xy = vec2(lcha.x, x);
       else if (h < 2.0)
           k.xy = vec2(x, lcha.x);
       else if (h < 3.0)
           k.yz = vec2(lcha.x, x);
       else if (h < 4.0)
           k.yz = vec2(x, lcha.x);
       else if (h < 5.0)
           k.xz = vec2(x, lcha.x);
       else
           k.xz = vec2(lcha.x, x);
       float m = lcha.x - dot(c_rgb_2_luma, k);
       rgba.xyz = k + m;
   }
   return rgba;
}

void main() {
   vec4 bColor = texture2D(u_sampler0, v_uvCoord0.xy);
#if defined(VTG_TEXEL0_RGBX)
   bColor.a = 1.0;
#elif defined(VTG_TEXEL0_BGRX)
   bColor = vec4(bColor.bgr, 1.0);
#elif defined(VTG_TEXEL0_BGRA)
   bColor = bColor.bgra;
#endif

   vec4 uColor = texture2D(u_sampler1, v_uvCoord1.xy);
#if defined(VTG_TEXEL1_RGBX)
   uColor.a = 1.0;
#elif defined(VTG_TEXEL1_BGRX)
   uColor = vec4(uColor.bgr, 1.0);
#elif defined(VTG_TEXEL1_BGRA)
   uColor = uColor.bgra;
#endif

    vec4 vblcha = vtg_rgba_2_lcha(bColor);
    vec4 vulcha = vtg_rgba_2_lcha(uColor);
    vec4 vtlcha = vblcha;
    vtlcha.y = vulcha.y;
    vec4 tColor = vtg_lcha_2_rgba(vtlcha);
    tColor = clamp(tColor, 0.0, 1.0);

    tColor = mix(tColor, uColor, step(bColor.a, 0.002));
    tColor = mix(bColor, tColor, uColor.a * u_aOpacity.x);
    gl_FragColor = tColor;
}