
#include <metal_stdlib>
using namespace metal;

typedef struct {
    float4 position [[position]];
    float4 uvCoord0;
    float4 uvCoord1;
} VertexOutput;

typedef struct {
    float4  aOpacity;
} PixelUniforms;


float4 vtg_rgba_2_lcha(float4 rgba) {
   const float4 c_rgba_2_luma = float4(0.299, 0.587, 0.114, 0.0);
   float4 lcha = float4(0.0, 0.0, 0.0, rgba.w);
   lcha.x = dot(c_rgba_2_luma, rgba);
   float4 sort = rgba;
   if (sort.x < sort.y) sort.xy = sort.yx;
   if (sort.x < sort.z) sort.xz = sort.zx;
   if (sort.y < sort.z) sort.yz = sort.zy;
   lcha.y = sort.x - sort.z;
   if (0.0 != lcha.y) {
       vec3 delc = (sort.xxx - rgba.xyz + lcha.y * 3.0) / (lcha.y * 6.0);
       if (sort.x == rgba.x)
           lcha.z = delc.z - delc.y;
       else if (sort.x == rgba.y)
           lcha.z = delc.x - delc.z + 0.333333;
       else
           lcha.z = delc.y - delc.x + 0.666667;
       if (lcha.z < 0.0)
           lcha.z += 1.0;
       else if (lcha.z > 1.0)
           lcha.z -= 1.0;
   }
   return lcha;
}

float4 vtg_lcha_2_rgba(float4 lcha) {
   const float3 c_rgb_2_luma = float3(0.299, 0.587, 0.114);
   float4 rgba = float4(lcha.xxx, lcha.w);
   if (0.0 != lcha.y) {
       float3  k = float3(0.0);
       float h = lcha.z * 6.0;
       float x = lcha.x * (1.0 - abs(mod(h, 2.0) - 1.0));
       if (h < 1.0)
           k.xy = vec2(lcha.x, x);
       else if (h < 2.0)
           k.xy = vec2(x, lcha.x);
       else if (h < 3.0)
           k.yz = vec2(lcha.x, x);
       else if (h < 4.0)
           k.yz = vec2(x, lcha.x);
       else if (h < 5.0)
           k.xz = vec2(x, lcha.x);
       else
           k.xz = vec2(lcha.x, x);
       float m = lcha.x - dot(c_rgb_2_luma, k);
       rgba.xyz = k + m;
   }
   return rgba;
}

fragment float4 vtaebifxBlendFS(VertexOutput vtxOut [[stage_in]], constant PixelUniforms &pxlUfm [[buffer(2)]],
    texture2d<float> srcTex0 [[texture(0)]], texture2d<float> srcTex1 [[texture(1)]])
{
    constexpr sampler smp2dLL(mag_filter::linear, min_filter::linear);
    float4 bColor = srcTex0.sample(smp2dLL, vtxOut.uvCoord0.xy);
    float4 uColor = srcTex1.sample(smp2dLL, vtxOut.uvCoord1.xy);

    float4 vblcha = vtg_rgba_2_lcha(bColor);
    float4 vulcha = vtg_rgba_2_lcha(uColor);
    float4 vtlcha = vblcha;
    vtlcha.z = vulcha.z;
    float4 tColor = vtg_lcha_2_rgba(vtlcha);
    tColor = clamp(tColor, 0.0, 1.0);

    tColor = mix(tColor, uColor, step(bColor.a, 0.002));
    tColor = mix(bColor, tColor, uColor.a * pxlUfm.aOpacity.x);

   return tColor;
}
