precision mediump float;
varying vec4 v_uvCoord0;
varying vec4 v_uvCoord1;

#ifdef VTG_TEXEL0_EXTS
uniform samplerExternalOES u_sampler0;
#else
uniform sampler2D u_sampler0;
#endif

#ifdef VTG_TEXEL1_EXTS
uniform samplerExternalOES u_sampler1;
#else
uniform sampler2D u_sampler1;
#endif

uniform vec4 u_aOpacity;
uniform vec4 u_mixRatio;
uniform vec4 u_mixParam;

void main() {
   vec4 color0 = texture2D(u_sampler0, v_uvCoord0.xy);
#if defined(VTG_TEXEL0_RGBX)
   color0.a = 1.0;
#elif defined(VTG_TEXEL0_BGRX)
   color0 = vec4(color0.bgr, 1.0);
#elif defined(VTG_TEXEL0_BGRA)
   color0 = color0.bgra;
#endif

   vec4 color1 = texture2D(u_sampler1, v_uvCoord1.xy);
#if defined(VTG_TEXEL1_RGBX)
   color1.a = 1.0;
#elif defined(VTG_TEXEL1_BGRX)
   color1 = vec4(color1.bgr, 1.0);
#elif defined(VTG_TEXEL1_BGRA)
   color1 = color1.bgra;
#endif

   float mRatio = dot(u_mixRatio, color1);
   mRatio = abs(u_mixParam.x - mRatio);
   mRatio = mRatio * u_aOpacity.x;
   gl_FragColor = color0 * mRatio;
}