
#include <metal_stdlib>
using namespace metal;

typedef struct {
    float4 position [[position]];
    float4 texCoord;
} VertexOutput;

typedef struct {
    float4      aOpacity;
    float4x4    ccMatrix;
} PixelUniforms;

fragment float4 vtaebifxYuv2FS(VertexOutput vtxOut [[stage_in]], constant PixelUniforms &pxlUfm [[buffer(2)]], 
    texture2d<float> srcTex0 [[texture(0)]], texture2d<float> srcTex1 [[texture(1)]])
{
    constexpr sampler smp2dLL(mag_filter::linear, min_filter::linear);
    float2 texuv = vtxOut.texCoord.xy;
    float4 ccYUV = float4(0.0, 0.0, 0.0, 1.0);
    ccYUV.x = srcTex0.sample(smp2dLL, texuv).r;
    ccYUV.yz = srcTex1.sample(smp2dLL, texuv).rg - float2(0.5, 0.5);
    float4 color0 = clamp(pxlUfm.ccMatrix * ccYUV, 0.0, 1.0);
    color0 *= pxlUfm.aOpacity.x;
    return color0;
}

