
#include <metal_stdlib>
using namespace metal;

typedef struct {
    float4 position [[attribute(0)]];
    float4 texCoord [[attribute(1)]];
} VertexSource;

typedef struct {
    float4 position [[position]];
    float4 uvCoord0;
    float4 uvCoord1;
} VertexOutput;

typedef struct {
    float4x4 mvpMatrix;
    float4x4 uvMatrix0;
    float4x4 uvMatrix1;
} VertexUniforms;

vertex VertexOutput vtaebifxTex2VS(VertexSource vtxSrc [[stage_in]], constant VertexUniforms &vtxUfm [[buffer(1)]])
{
    VertexOutput vtxOut;
    vtxOut.position = vtxUfm.mvpMatrix * vtxSrc.position;
    float4 tfmTexuv = float4(vtxSrc.texCoord.xy, 0.0, 1.0);
    vtxOut.uvCoord0 = vtxUfm.uvMatrix0 * tfmTexuv;
    vtxOut.uvCoord1 = vtxUfm.uvMatrix1 * tfmTexuv;
    vtxOut.uvCoord0.zw = vtxSrc.texCoord.zw;
    vtxOut.uvCoord1.zw = vtxSrc.texCoord.zw;

   return vtxOut;
}
