create Table IF NOT EXISTS  Wygl_Build_BuildInspectTask
(
	ID bigint primary key,
	PrecinctID bigint,				--项目ID
	PrecinctName nvarchar(255),		--项目
	TaskNo nvarchar(80),			--任务编号
	TaskName nvarchar(80),			--任务名称
	TaskDate datetime,				--任务日期
	BeginHour datetime,				--任务开始(时)
	EndHour datetime,				--任务结束(时)
	InspectStatus tinyint,			--巡检状态　0未完成　1巡检中　2已完成
	InspectStartDate datetime,		--实际巡检开始时间
	InspectEndDate datetime,		--实际巡检结束时间
	TaskUserID bigint,				--实际任务执行人
	TaskUserName nvarchar(20),		--实际任务执行人
	FirstUserID bigint,				--首选巡检人
	SecondUserID bigint,			--备选巡检人
	IsSend tinyint default(0),		--是否派发 0否　1是
	BuildCount int,					--总数
	CompCount int,					--已巡检数
	IsUpload tinyint,				--是否上传
    CycleCount int,                 --
    CycleTypeID int,                --频次类型
    CycleValue int,                 --
    CycleName nvarchar(80)          --频次名称
);
CREATE Index Wygl_Build_BuildInspectTask_Idx_TaskDate_TaskUserID on Wygl_Build_BuildInspectTask(TaskDate DESC,TaskUserID DESC);
create Table IF NOT EXISTS  Wygl_Build_BuildInspectPlan
(
	ID bigint  primary key,
	BuildID bigint not null,	--外键Wygl_Build_Build(ID)
	ScheduleID bigint,			--年度计划ID
	TaskID bigint,				--任务ID
	Seconds int,				--用时（秒）

	PlanStatus tinyint,			--状态　0未完成　1部分完成　2已完成
	BuildStatus tinyint,		--设备状态 0停用 1在用
	CompleteCount int,			--已完成数
	CheckItemCount int,			--巡检项总数
	CycErrBeginDate datetime,	--巡检偏差开始
	CycErrEndDate datetime,		--巡检偏差结束

	OpUserID bigint,			--实际巡检人
	OpStartTime datetime,		--实际开始时间
	OpEndTime datetime,			--实际结束时间

	ClassID bigint,			--分类
	BuildName nvarchar(100),--名称
	BuildCode nvarchar(50),	--编号
	ImageUrl varchar(100),	--设备图片
	Location nvarchar(50),	--位置
	PlanIndex int,			--第几次
	CycleTypeID int,        --周期类型
	OperationType varchar(10),	--操作权限

	DeviationBegin nvarchar(10),    --允许巡检开始时间
	DeviationEnd nvarchar(10),      --允许巡检结束时间
	Interval int,                   --时间间隔（默认：0）分钟

	ParentID bigint,			    --设备房ID

	IsUpload tinyint,				--是否上传
    CycleCount int,
    CycleValue int,
    CycleName nvarchar(80)          --频次名称
);
CREATE Index Wygl_Build_BuildInspectPlan_Idx_TaskID on Wygl_Build_BuildInspectPlan(TaskID DESC);
create table IF NOT EXISTS  Wygl_Build_BuildCheckItemInspect
(
	ClientID integer  primary key autoincrement,  	--客户端ID主键
	ID bigint,										--服务端 巡查结果ID
	BuildID bigint,									--外键Wygl_Build_Build(ID)
	InspectPlanID bigint not null,					--外键Wygl_Build_BuildInspectPlan(ID)
	CheckItemID bigint,								--外键Wygl_Build_BuildCheckItem(ID)

	ItemResult tinyint,								--1正常　2异常
	ItemValue  decimal(18,4),						--数值输入型
	ItemStrValue  nvarchar(100),					--字符输入型
	ItemRemark nvarchar(500),						--说明
	FileID bigint		,							--附件照片
	OpUserID bigint,								--巡检人
	OpDate datetime default (datetime('now', 'localtime')),   --巡检时间

    RecheckStatus tinyint default(0),	--复检状态　0未复检　1已复检
    RecheckFileID RecheckFileID bigint,
    RecheckRemark nvarchar(200),		--复检说明
	RecheckUserID bigint,				--复检人
	RecheckDate datetime,				--复检时间

	ItemName  nvarchar(100),						--点检项目
	ItemContent nvarchar(100)	,					--检查内容及标准
	InputType tinyint,								--输入类型： 1是否（正常）2数值输入型 3文本输入型
	MinValue decimal(18,4),							--最小值（数值输入型）
	MaxValue decimal(18,4),							--最大值（数值输入型）
	ValueUnit nvarchar(20) , 						--计量单位(数值输入型)

    IsReport tinyint default(0), --是否已报修
    IsUpLoad tinyint default(0), --是否上传　0未上传　1已上传
    ServicesID bigint			 --报修后对应的报事ID
);
CREATE Index Wygl_Build_BuildCheckItemInspect_Idx_InspectPlanID on Wygl_Build_BuildCheckItemInspect(InspectPlanID DESC);