create table IF NOT EXISTS  Wygl_Build_MaintainPlan
(
	ID integer  primary key ,  			--ID主键
	BuildID bigint,						--设备ID
	BuildName  nvarchar(50),			--设备名称
	BuildCode  nvarchar(50),			--设备编号
	AncestorName nvarchar(255),			--设备分类
	Location  nvarchar(255),			--安装位置
	ClassCycName nvarchar(50),			--周期
	ClassCycValue nvarchar(50),			--周期图标
	ChargeUserID bigint,				--责任人
	ChargeUserName nvarchar(50),		--责任人
	HouseID bigint,						--所在项目
	HouseName nvarchar(50),				--所在项目
	Comment nvarchar(255),				--维保方案
	Remark nvarchar(255),				--备注
	CompletedDate	datetime,			--完成时间
	BeginDate	datetime,				--开始时间（计划）
	Status bigint,						--状态
	CheckerName	nvarchar(50) ,			--验证人
	MaintainUserID bigint,
	MaintainUserName nvarchar(50) ,		--维保人
	MaintainContent nvarchar(500) ,		--维保人
	ManHour double,						--工时
	ServiceID bigint,					--报事ID
	BuildStatus tinyint,				--设备状态

	FileID bigint	default(0)	,		--附件照片
	FileCount int	default(0)	,		--附件数量
    IsUpLoad tinyint default(0),			--是否上传　0未上传　1已上传

	MonitorUserID bigint,
	MonitorUserName nvarchar(50) ,		--抽查人
	MonitorContent  nvarchar(500) ,		--抽查内容
	MonitorDate datetime,
	IsReCheckPass int ,					--0不合格 1合格
	ReCheckStatus int ,				    --0未抽查 1已抽查
	ReCheckFileID bigint,
	ReCheckFileCount int,
	TypeName nvarchar(50) 				--频次周期
);
CREATE Index IF NOT EXISTS Wygl_Build_MaintainPlan_Idx_BuildID on Wygl_Build_MaintainPlan(BuildID asc);
CREATE Index IF NOT EXISTS Wygl_Build_MaintainPlan_Idx_BeginDate_ChargeUserID on Wygl_Build_MaintainPlan(ChargeUserID DESC,BeginDate DESC);

create table IF NOT EXISTS  Wygl_Build_MaintainPlanItem
(
	ID integer  primary key,			--ID主键
    MaintainPlanID bigint,				--维保计划主键
    ItemName nvarchar(255),				--维保项
    ItemOrderID bigint,					--排序ID？
    IsChecked int						--是否已检查 0默认 1未完成 2已完成
);
CREATE Index IF NOT EXISTS Wygl_Build_MaintainPlanItem_Idx_MaintainPlanID on Wygl_Build_MaintainPlanItem(MaintainPlanID asc);

create table IF NOT EXISTS  Wygl_Build_MaintainPlanMaterial
(
    ID integer  primary key,			--ID主键
    MaintainPlanID bigint,				--维保计划主键
    MaterialID bigint,					--物料ID
    MaterialName nvarchar(255),			--用料名称
    MaterialAmount decimal(18,2),		--数量
    MaterialBalance decimal(18,2)		--金额
);
CREATE Index IF NOT EXISTS Wygl_Build_MaintainPlanMaterial_Idx_MaintainPlanID on Wygl_Build_MaintainPlanMaterial(MaintainPlanID asc);