// { "framework": "Vue" }
/******/ (function(modules) { // webpackBootstrap
/******/ 	// The module cache
/******/ 	var installedModules = {};

/******/ 	// The require function
/******/ 	function __webpack_require__(moduleId) {

/******/ 		// Check if module is in cache
/******/ 		if(installedModules[moduleId])
/******/ 			return installedModules[moduleId].exports;

/******/ 		// Create a new module (and put it into the cache)
/******/ 		var module = installedModules[moduleId] = {
/******/ 			exports: {},
/******/ 			id: moduleId,
/******/ 			loaded: false
/******/ 		};

/******/ 		// Execute the module function
/******/ 		modules[moduleId].call(module.exports, module, module.exports, __webpack_require__);

/******/ 		// Flag the module as loaded
/******/ 		module.loaded = true;

/******/ 		// Return the exports of the module
/******/ 		return module.exports;
/******/ 	}


/******/ 	// expose the modules object (__webpack_modules__)
/******/ 	__webpack_require__.m = modules;

/******/ 	// expose the module cache
/******/ 	__webpack_require__.c = installedModules;

/******/ 	// __webpack_public_path__
/******/ 	__webpack_require__.p = "";

/******/ 	// Load entry module and return exports
/******/ 	return __webpack_require__(0);
/******/ })
/************************************************************************/
/******/ ([
/* 0 */
/***/ (function(module, exports) {

	'use strict';

	/**
	 * Created by admin on 2017/6/30.
	 */

	/**
	 * 格式化日期
	 * @param dateStr 时间字符串，如：'2017-06-30'
	 * @param separate 分隔符，如：'-'
	 * @param formatStr 转换后的格式，如：'yyyy/MM/dd'
	 * @returns {string}
	 */
	exports.getFormatDate = function (dateStr, separate, formatStr) {
	  if (dateStr === null || dateStr === undefined) {
	    return '';
	  }
	  var dateArr = dateStr.split(separate);
	  var date = new Date(dateArr[0], dateArr[1] - 1, dateArr[2]);
	  var todayDate = new Date();
	  todayDate.setHours(0);
	  todayDate.setMinutes(0);
	  todayDate.setSeconds(0);
	  var dateToToday = parseInt(Math.abs(todayDate - date) / 1000 / 60 / 60 / 24);

	  var result = '';
	  switch (dateToToday) {
	    case -2:
	      result = '后天';
	      break;
	    case -1:
	      result = '明天';
	      break;
	    case 0:
	      result = '今天';
	      break;
	    case 1:
	      result = '昨天';
	      break;
	    case 2:
	      result = '前天';
	      break;
	    default:
	      result = formatStr.replace('yyyy', dateArr[0]).replace('MM', dateArr[1]).replace('dd', dateArr[2]);
	      break;
	  }
	  return result;
	};

	//时间戳转成具体日期 yyyy-mm-dd
	exports.getDateToDay = function (obj) {
	  var d;
	  try {
	    d = new Date(obj.replace(/-/g, '/'));
	  } catch (e) {
	    d = new Date(obj);
	  }

	  var md = d.getMonth() + 1;
	  if (md < 10) {
	    md = "0" + md;
	  }
	  var dd = d.getDate();
	  if (dd < 10) {
	    dd = "0" + dd;
	  }
	  var df = d.getFullYear() + '-' + md + '-' + dd;
	  return df;
	};

	//时间戳 /Date(1500954304000+0800)/ 转成具体日期 yyyy-mm-dd
	exports.getDateToDayWithPrefix = function (obj) {
	  var time = obj.toString().substring(6, obj.toString().length - 7);
	  return this.getDateToDay(parseInt(time));
	};

	//时间戳转成具体日期 hh-mm-ss
	exports.getDateToHours = function (obj) {
	  var d = new Date(obj);
	  var h = d.getHours();
	  h = h < 10 ? '0' + h : h;
	  var m = d.getMinutes();
	  m = m < 10 ? '0' + m : m;
	  var s = d.getSeconds();
	  s = s < 10 ? '0' + s : s;
	  return h + ':' + m + ':' + s;
	};

	//时间戳 /Date(1500954304000+0800)/ 转成具体日期 hh-mm-ss
	exports.getDateToHoursWithPrefix = function (obj) {
	  var time = obj.toString().substring(6, obj.toString().length - 7);
	  return this.getDateToHours(parseInt(time));
	};

	//时间戳获取月份 八月
	exports.getMonthName = function (obj) {
	  var monthName = ['一', '二', '三', '四', '五', '六', '七', '八', '九', '十', '十一', '十二'];
	  var d = new Date(obj);
	  return monthName[d.getMonth()];
	};

	// 获取友好提示的时间(仿微信朋友圈)
	exports.getFriendlyTime = function (obj) {
	  var d = new Date(obj);
	  var delta = (new Date().getTime() - d.getTime()) / 1000;
	  if (delta <= 0) return this.getDateToDay(obj) + " " + this.getDateToHours(obj);
	  if (delta / (60 * 60 * 24 * 365) >= 1) return parseInt(delta / (60 * 60 * 24 * 365)) + "年前";
	  if (delta / (60 * 60 * 24 * 30) >= 1) return parseInt(delta / (60 * 60 * 24 * 30)) + "个月前";
	  // if (delta / (60 * 60 * 24 * 7) >= 1) return parseInt(delta / (60 * 60 * 24 * 7)) + "周前";
	  if (delta / (60 * 60 * 24) >= 1) return parseInt(delta / (60 * 60 * 24)) + "天前";
	  if (delta / (60 * 60) >= 1) return parseInt(delta / (60 * 60)) + "小时前";
	  if (delta / 60 >= 1) return parseInt(delta / 60) + "分钟前";
	  return "刚刚";
	};
	//判断几秒前 今天 昨天 一周 类似微信
	exports.getTimeWx = function (dateStr) {
	  var publishTime = Date.parse(dateStr.replace(/-/gi, "/")) / 1000,
	      d_seconds,
	      d_minutes,
	      d_hours,
	      d_days,
	      timeNow = parseInt(new Date().getTime() / 1000),
	      d,
	      date = new Date(publishTime * 1000),
	      Y = date.getFullYear(),
	      M = date.getMonth() + 1,
	      D = date.getDate(),
	      H = date.getHours(),
	      m = date.getMinutes(),
	      s = date.getSeconds();
	  //小于10的在前面补0
	  if (M < 10) {
	    M = '0' + M;
	  }
	  if (D < 10) {
	    D = '0' + D;
	  }
	  if (H < 10) {
	    H = '0' + H;
	  }
	  if (m < 10) {
	    m = '0' + m;
	  }
	  if (s < 10) {
	    s = '0' + s;
	  }

	  d = timeNow - publishTime;
	  d_days = parseInt(d / 86400);
	  d_hours = parseInt(d / 3600);
	  d_minutes = parseInt(d / 60);
	  d_seconds = parseInt(d);

	  if (d_days > 0 && d_days < 3) {
	    return d_days + '天前';
	  } else if (d_days <= 0 && d_hours > 0) {
	    return d_hours + '小时前';
	  } else if (d_hours <= 0 && d_minutes > 0) {
	    return d_minutes + '分钟前';
	  } else if (d_seconds < 60) {
	    if (d_seconds <= 0) {
	      return '刚刚';
	    } else {
	      return d_seconds + '秒前';
	    }
	  } else if (d_days >= 3 && d_days < 30) {
	    return M + '-' + D;
	  } else if (d_days >= 30 && d_days < 365) {
	    return Y + '-' + M + '-' + D;
	  } else if (d_days >= 365) {
	    return Y + '年';
	  }
	};

/***/ })
/******/ ]);