// { "framework": "Vue" }
/******/ (function(modules) { // webpackBootstrap
/******/ 	// The module cache
/******/ 	var installedModules = {};

/******/ 	// The require function
/******/ 	function __webpack_require__(moduleId) {

/******/ 		// Check if module is in cache
/******/ 		if(installedModules[moduleId])
/******/ 			return installedModules[moduleId].exports;

/******/ 		// Create a new module (and put it into the cache)
/******/ 		var module = installedModules[moduleId] = {
/******/ 			exports: {},
/******/ 			id: moduleId,
/******/ 			loaded: false
/******/ 		};

/******/ 		// Execute the module function
/******/ 		modules[moduleId].call(module.exports, module, module.exports, __webpack_require__);

/******/ 		// Flag the module as loaded
/******/ 		module.loaded = true;

/******/ 		// Return the exports of the module
/******/ 		return module.exports;
/******/ 	}


/******/ 	// expose the modules object (__webpack_modules__)
/******/ 	__webpack_require__.m = modules;

/******/ 	// expose the module cache
/******/ 	__webpack_require__.c = installedModules;

/******/ 	// __webpack_public_path__
/******/ 	__webpack_require__.p = "";

/******/ 	// Load entry module and return exports
/******/ 	return __webpack_require__(0);
/******/ })
/************************************************************************/
/******/ ([
/* 0 */
/***/ (function(module, exports) {

	'use strict';

	/**
	 * Created by Young on 2017/5/26.
	 */

	// ----------------------------- 雅助手接口实现类 ------------------------------------

	// 获取访客记录
	exports.getVisitorHistory = function (pageSize, pageIndex) {
	  var apiCode = 'property.steward.visitorAuthService.visitorHistory';
	  var reqData = {
	    pageSize: pageSize,
	    pageIndex: pageIndex
	  };
	  return [apiCode, reqData];
	};

	// 根据二维码信息获取访客证Id
	exports.getAuthorizationId = function (qrCode) {
	  var apiCode = 'property.qrCode.parse';
	  var reqData = {
	    qrCode: qrCode
	  };
	  return [apiCode, reqData];
	};

	// 获取访客信息
	exports.getVisitorInfo = function (key1) {
	  var apiCode = 'property.steward.visitorAuthService.visitorInfo';
	  var reqData = {
	    key1: key1
	  };
	  return [apiCode, reqData];
	};

	// 登记激活访客证
	exports.doRegisterVisitor = function (visitorId) {
	  var apiCode = 'property.steward.visitorAuthService.register';
	  var reqData = {
	    visitorId: visitorId
	  };
	  return [apiCode, reqData];
	};

	// 获取投诉建议列表
	exports.getSuggestionList = function (type, pageSize, pageIndex) {
	  var apiCode = 'property.steward.suggestionService.suggestions';
	  var reqData = {
	    type: type,
	    pageSize: pageSize,
	    pageIndex: pageIndex
	  };
	  return [apiCode, reqData];
	};

	// 获取投诉建议详情
	exports.getSuggestionDetail = function (suggestionId) {
	  var apiCode = 'property.steward.suggestionService.detail';
	  var reqData = {
	    suggestionId: suggestionId
	  };
	  return [apiCode, reqData];
	};

	// 回复投诉建议
	exports.doSuggestionReply = function (suggestionId, content, imageUrls) {
	  var images = [];
	  if (imageUrls !== null) {
	    for (var i = 0; i < imageUrls.length; i++) {
	      images.push({ imageUrl: imageUrls[i] });
	    }
	  }

	  var apiCode = 'property.steward.suggestionService.saveReply';
	  var reqData = {
	    suggestionId: suggestionId,
	    content: content,
	    images: images
	  };
	  return [apiCode, reqData];
	};

	// 获取上传到七牛的token
	exports.getQiniuToken = function () {
	  var apiCode = 'base.QiniuService.getToken';
	  var reqData = {};
	  return [apiCode, reqData];
	};

	// 获取问题列表
	exports.getQuestionsList = function (isReply, pageSize, pageIndex) {
	  var apiCode = 'property.steward.majordomoQuestion.findQuestions';
	  var reqData = {
	    isReply: isReply,
	    pageSize: pageSize,
	    pageIndex: pageIndex
	  };
	  return [apiCode, reqData];
	};

	// 回复问题
	exports.doQuestionsReply = function (questionId, content, imageUrls) {
	  var images = [];
	  if (imageUrls !== null) {
	    for (var i = 0; i < imageUrls.length; i++) {
	      images.push({ imageUrl: imageUrls[i] });
	    }
	  }

	  var apiCode = 'property.steward.majordomoQuestion.reply';
	  var reqData = {
	    questionId: questionId,
	    content: content,
	    images: images
	  };
	  return [apiCode, reqData];
	};

	// 获取住户认证信息
	exports.getUserInfo = function (uid) {
	  var apiCode = 'property.steward.majordomoQuestion.residentCertificationInfo';
	  var reqData = {
	    uid: uid
	  };
	  return [apiCode, reqData];
	};

/***/ })
/******/ ]);