create table IF NOT EXISTS  Wygl_EmptyHouse_Inspect
(
	ID int primary key,  		    --ID主键
	OpStartTime nvarchar(80),		--巡查开始时间
	OpEndTime nvarchar(80),			--巡查结束时间
    ItemNames nvarchar(80),			--装修阶段
    CycErrSpanName nvarchar(80),	--可巡查时间
    HouseID bigint,					--房号ID
    HouseName nvarchar(80),			--房号
    PlanStatus int,					--计划状态 0未巡检 1部分巡检 2已完成
    PlanStatusName nvarchar(80),	--计划状态名
    OpUserID int,					--巡查人ID
    OpUserName nvarchar(80),		--巡查人
    CycleTypeID int,				--周期ID
    CycleTypeName nvarchar(80),		--周期
    PrecinctID int,                 --房产项目
    IsUpload tinyint 				--是否上传
);
CREATE Index IF NOT EXISTS Wygl_EmptyHouse_Inspect_Idx_ID on Wygl_EmptyHouse_Inspect(ID DESC);

create table IF NOT EXISTS  Wygl_EmptyHouse_Inspect_Item
(
	ID int primary key,  		    --ID主键
    EmptyHouseInspectPlanID int,	--计划ID
    ItemName nvarchar(80),          --检查项目
    ItemResult int,					--巡查结果 1正常 2异常
    ItemContent	nvarchar(180),		--巡查项描述
    ItemRemark nvarchar(180),       --问题描述
    OrderID int,                    --排序
    FileID bigint,                  --照片附件
    FileCount int,                  --服务器附件数
    IsUpload tinyint 				--是否上传
);
CREATE Index IF NOT EXISTS  Wygl_EmptyHouse_Inspect_Idx_EmptyHouseInspectPlanID on Wygl_EmptyHouse_Inspect_Item(EmptyHouseInspectPlanID DESC);