create table IF NOT EXISTS  Wygl_Fitment_Inspect
(	
	ID int primary key ,  		    --ID主键
	OpStartTime nvarchar(80),		--巡查开始时间
	OpEndTime nvarchar(80),			--巡查结束时间
    ItemNames nvarchar(80),			--装修阶段
    CycErrSpanName nvarchar(80),	--可巡查时间
    HouseID bigint,					--房号ID
    HouseName nvarchar(80),			--房号
    PlanStatus int,					--计划状态 0未巡检 1部分巡检 2已完成
    PlanStatusName nvarchar(80),	--计划状态名
    OpUserID int,					--巡查人ID
    OpUserName nvarchar(80),		--巡查人
    CycleTypeID int,				--周期ID
    CycleTypeName nvarchar(80),		--周期
    ResPrecinctIDs nvarchar(80),    --细化的房产项目
    IsUpload tinyint, 				--是否上传
    IsAuto int,                     --是否自动生成计划
    NextStepFlag int                --下次装修阶段 1保持当前 2下步阶段 3完成装修 4取消装修
);
CREATE Index IF NOT EXISTS Wygl_Fitment_Inspect_Idx_ID on Wygl_Fitment_Inspect(ID DESC);

create table IF NOT EXISTS  Wygl_Fitment_Inspect_Item
(	
	ID int primary key ,  		    --ID主键
    FitmentInspectPlanID int,		--计划ID
    ItemName nvarchar(80),          --装修阶段
    ItemResult int,					--巡查结果 1正常 2异常
    ItemContent	nvarchar(180),		--巡查项描述
    ReworkRequest nvarchar(180),	--整改要求
    ReworkLimit	nvarchar(80),		--整改期限
    ReworkMode int,					--整改方式 1劝说制止 书面温馨提示 3整改通知书 4报告相关部门
    Content nvarchar(180),          --问题描述
    OrderID int,                    --排序
    StageOrderID int,               --装修阶段排序
    PhotoAnnex bigint,              --照片附件
    FileCount int,                  --服务器上附件数
    IsUpload tinyint, 				--是否上传
    IsReorganize int,               --是否整改
    ReorganizeCount int             --违规整改数
);
CREATE Index IF NOT EXISTS  Wygl_Fitment_Inspect_Item_Idx_FitmentInspectPlanID on Wygl_Fitment_Inspect_Item(FitmentInspectPlanID DESC);