create table IF NOT EXISTS  Hx_Quality_Check --主表
(	
	ID int  primary key ,  		--ID主键
	IsChecked tinyint,				--是否已检查
	ItemCount int,					--检查总数(检查标准数)
	CheckCount int,				    --已检查数量
	NoPassCount int,				    --mei通过数量
	ReviseCount int,				    --整改数量

	PlanStartDate datetime,				--计划检查开始日期
	PlanEndDate   datetime,			--计划检查截止日期
	PlanUserID    bigint,				--计划检查人

    CheckStart datetime,			--实际检查时间
    UpdateDate datetime,				--最近修改
    CheckEnd   datetime,				--检查结束
    ItemCode   nvarchar(50),		    -- 编号
    ItemID     bigint,					--检查项ID
    ClassType  bigint,				--模版分类
    ItemName   nvarchar(50) ,		--检查项（第二级：检查项目）
    ClassTypeName  nvarchar(50) ,				--模版分类,安全类
    PrecinctID     bigint,				--受检项目ID
    HouseName	   nvarchar(50) ,		--受检项目
    CycleCount int,					    --频次数
    CycleType int,					    --周期类型
    CycleValue int,					    --频次值
    CycleName nvarchar(50),			    --频次
    IsUpload tinyint default(0),		--是否上传//0否 1是
    IsDelay tinyint,				    --是否超时
    PassRate decimal(5,2),				--合格率
    CoverRate decimal(5,2),			--覆盖率
    SchduleRule nvarchar(50)		--控制必填
);

create table IF NOT EXISTS  Hx_Quality_CheckPoint
(
    rowid INTEGER primary key,
	ItemID int  ,  	--外键 Hx_Quality_Check(ItemID)
	CheckPointID integer,					--样本
	TaskID integer,					--
	CheckPointName nvarchar(255),		--样本名字
	PointType int,
	PointGuid nvarchar(50)
);

create table IF NOT EXISTS  Hx_Quality_CheckContent
(
    TaskID integer,					--
	ItemID int   ,  	--外键 Hx_Quality_Check(ItemID)
	CheckContentID integer,					--检查内容
	CheckContent nvarchar(255),		   --标准详细
	CheckMethodDetail nvarchar(255),		   --标准详细
	CheckMethod nvarchar(255),		   --标准
	IsMustItem tinyint		                --是否必检
);
create table IF NOT EXISTS  Hx_Quality_ItemProblem
(
    TaskID integer,					--
	ID bigint   ,
	ProblemID  bigint,					--问题ID
	ItemID   bigint,					--外键 Hx_Quality_Check(ItemID)
	OrderID   int,		                --标准详细
	CheckContentID int,		            --检查内容ID
	ProblemName nvarchar(255)           --问题详细
);
create table IF NOT EXISTS  Hx_Quality_CheckPointType
(
    PointType integer,					--
	PointTypeName nvarchar(255)         --
);

create table IF NOT EXISTS  Hx_Quality_Check_Item
(
	ID int ,  		--ID主键
	PlanID  int,					    --计划ID
	QualityTaskID     int,
	ItemID     int,
    ItemName   nvarchar(50) ,
    CheckScore     int,				    --检查得分
    IsPass          tinyint ,				    --审核是否通过
    CheckRemark	   nvarchar(50) ,
    FileID   bigint,
    UpdateUserID   int,
    UpdateDate   nvarchar(50),
    LocationTime  nvarchar(50),
    LocationID  int,				    --定位ID
    IsImprove  int,
     IsDelay          tinyint ,
     CheckStateStr  nvarchar(50),
     ReviseStateStr  nvarchar(50),
     AddrStr  nvarchar(50),

     Pointlat nvarchar(50),		            --精度
     Pointlng nvarchar(50),		            --维度
      CheckContentID    int,
     ItemPlanID    int,
     FileCount    int,
     CheckContent  nvarchar(50),
     SchduleRule  nvarchar(50),
     CheckMethodDetail  nvarchar(50),
     CheckMethod  nvarchar(50),
     CheckStart  nvarchar(50),
     IsRevise    int,
     CheckEnd  nvarchar(50),
     DeadlineDays    int,
     ReviseLimit    nvarchar(50),		--整改期限
     ReviseType    int,
     IsChecked    int,
     ReviseUserID    int,
     ReviewUserID    int,
     ReviseUserName nvarchar(50),	    --整改人v
     ReviewUserName nvarchar(50),		--复核人
     PlanProblemList nvarchar(50),		--问题列表
     UserIDMac  nvarchar(50),
     Guid varchar(50)  primary key,
     IsDelete    int,

     PointID int,
     PointName nvarchar(50),
     PointGuid varchar(50),
     PointType int
);

CREATE Index IF NOT EXISTS Hx_Quality_Check_Item_Idx_ID on Hx_Quality_Check_Item(QualityTaskID DESC);
