create table IF NOT EXISTS  Wygl_Meter_Read
(
	ID bigint primary key,  		--ID主键
	MeterID nvarchar(80),		    --仪表编号
	MeterTypeID int,			    --仪表类型
    MeterTypeName nvarchar(80),		--仪表类型名称
    HouseID bigint,					--所在房产
    HouseName nvarchar(80),			--所在房产名称
    MaxDegree double,               --仪表回程
    CurrentReadDate nvarchar(80),	--本期抄表时间
    CurrentReadDegree double,	    --本期读数
    UseDegrees double,				--本期用量
    IsClosing int,		            --是否审核 1是0否
    ReaderID bigint,				--抄表人UserID
    ReaderUserName nvarchar(80),	--抄表人
    LastReadDate nvarchar(80),      --上期抄表时间
    LastReadDegree double,          --上期读数
    LastUseDegrees double,          --上期用量
    FileID bigint,                  --附件组id
    FileCount int,                  --附件数量
    ServerID bigint,                --附件上传时绑定的记录主键
    PrecinctID int,                 --房产项目
    IsUpload tinyint, 				--是否上传
    Unit nvarchar(80) 				--单位
);
CREATE Index IF NOT EXISTS Wygl_Meter_Read_Idx_ID on Wygl_Meter_Read(ID DESC);

-- 工程抄表
create table IF NOT EXISTS  Wygl_Project_Meter_Read
(
	ID bigint primary key,  		--ID主键
	MeterID nvarchar(80),		    --仪表编号
	MeterTypeID int,			    --仪表类型
    MeterTypeName nvarchar(80),		--仪表类型名称
    HouseID bigint,					--所在房产
    HouseName nvarchar(80),			--所在房产名称
    MaxDegree double,               --仪表回程
    CurrentReadDate nvarchar(80),	--本期抄表时间
    CurrentReadDegree double,	    --本期读数
    UseDegrees double,				--本期用量
    IsClosing int,		            --是否审核 1是0否
    ReaderID bigint,				--抄表人UserID
    ReaderUserName nvarchar(80),	--抄表人
    LastReadDate nvarchar(80),      --上期抄表时间
    LastReadDegree double,          --上期读数
    LastUseDegrees double,          --上期用量
    FileID bigint,                  --附件组id
    FileCount int,                  --附件数量
    ServerID bigint,                --附件上传时绑定的记录主键
    PrecinctID int,                 --房产项目
    IsUpload tinyint, 				--是否上传
    Unit nvarchar(80) 				--单位
);
CREATE Index IF NOT EXISTS Wygl_Project_Meter_Read_Idx_ID on Wygl_Project_Meter_Read(ID DESC);