create table IF NOT EXISTS  Wygl_Parking_Inspect
(
	ID bigint primary key,  		--ID主键
	OpStartTime nvarchar(80),		--巡查开始时间
	OpEndTime nvarchar(80),			--巡查结束时间
    CycErrSpanName nvarchar(80),	--可巡查时间
    ParkingID bigint,				--园区ID
    ParkingName nvarchar(80),		--园区
    PlanStatus int,					--计划状态 0未巡检 1部分巡检 2已完成
    PlanStatusName nvarchar(80),	--计划状态名
    OpUserID int,					--巡查人ID
    OpUserName nvarchar(80),		--巡查人
    CycleTypeID int,				--周期ID
    CycleTypeName nvarchar(80),		--周期
    PrecinctID int,                 --房产项目
    IsUpload tinyint 				--是否上传
);
CREATE Index IF NOT EXISTS Wygl_Parking_Inspect_Idx_ID on Wygl_Parking_Inspect(ID DESC);

create table IF NOT EXISTS  Wygl_Parking_Inspect_Item
(
	ID bigint primary key,  		--ID主键
    ParkingInspectPlanID bigint,	--计划ID
    ItemName nvarchar(80),          --检查项目
    ItemContent  nvarchar(180),     --巡查项描述
    ItemResult int,					--巡查结果 1正常 2异常
    ItemRemark nvarchar(180),       --问题描述
    FileID bigint,                  --照片附件
    FileCount int,                  --服务器附件数
    IsUpload tinyint 				--是否上传
);
CREATE Index IF NOT EXISTS  Wygl_Parking_Inspect_Idx_ParkingInspectPlanID on Wygl_Parking_Inspect_Item(ParkingInspectPlanID DESC);