create table IF NOT EXISTS  Wygl_Quality_QualityPlan
(	
	ID integer  primary key ,  		--ID主键
	NoPassCount int,				--不合格数
	ItemCount int,					--检查总数(检查标准数)
	PlanDate datetime,				--计划日期
	PlanEndDate datetime,			--计划日期结束
	PlanUserID bigint,				--计划检查人
	IsChecked tinyint,				--是否已检查
	IsImprove tinyint,				--是否已发起整改
	CheckUserID bigint,				--实际检查人
	CheckUserName nvarchar(10),		--实际检查人
	CheckDate datetime,				--检查时间（实际）
	CheckStart datetime,			--检查开始
	CheckEnd datetime,				--检查结束
	CheckRemark nvarchar(255),		--检查备注
	ItemScore	decimal(18,4),		--总分
	CheckScore	decimal(18,4),		--得分
	ItemID bigint,					--检查项ID
	ItemName	nvarchar(50) ,		--检查项（第二级：检查项目）
	PointID bigint,					--检查点ID
	PointName   nvarchar(50) ,		--检查点
	PrecinctID bigint,				--受检项目ID
	HouseName	nvarchar(50) ,		--受检项目
	IsExamin tinyint,				--是否必查
	CycleType int,					--周期
	CycleCount int,					--周期数
	CycleValue int,					--周期值
	CycleName nvarchar(50),			--周期名称
	IsUpload tinyint,				--是否上传
	SchduleRule char(10) default('0011'),	--是否必须描述拍照
	ItemStatus tinyint default(1),	--检查时设备状态：1运行(默认) 2待机 3备用
	Pointlat nvarchar(50),
    Pointlng nvarchar(50),
    UserIDMac nvarchar(50),
    AddrStr nvarchar(50),
    LocationID bigint
);
CREATE Index IF NOT EXISTS Quality_QualityPlan_Idx_PlanDate_PlanUserID on Wygl_Quality_QualityPlan(PlanUserID DESC,PlanDate DESC);
CREATE Index IF NOT EXISTS Quality_QualityPlan_Idx_PlanDate_PlanUserID_PointID on Wygl_Quality_QualityPlan(PlanUserID DESC,PointID Desc,PlanDate DESC);

create table IF NOT EXISTS  Wygl_Quality_QualityPlanDetail
(	
	ID integer  primary key ,  		--ID主键
	PlanID bigint,					--外键 Quality_QualityPlan(ID)
	IsPass tinyint,					--是否合格
	IsChecked tinyint,				--是否已检查
	CheckScore decimal(18,4),		--检查得分
	CheckRemark nvarchar(255),		--检查备注
	
	ItemName nvarchar(255),			--检查标准（第三级 检查标准）
	ItemScore decimal(18,4),		--检查标准分数
	CheckMethod	nvarchar(255),		--检查方法

	InputType tinyint default(1),	--1选项（合格 不合格） 2数值
	MinValue decimal(18,2),			--最小值
	MaxValue decimal(18,2),			--最大值
	ItemStatus tinyint default(1),	--设备状态：1运行(默认) 2待机 3备用 
	CheckValue decimal(18,2),		--检查值

	FileID bigint,					--附件照片
    IsUpLoad tinyint default(0)		--是否上传　0未上传　1已上传
);
CREATE Index IF NOT EXISTS  Quality_QualityPlanDetail_Idx_PlanID on Wygl_Quality_QualityPlanDetail(PlanID DESC);