create table IF NOT EXISTS  Quality_QualityReCheck
(
	ID integer  primary key ,  				--ID主键
	DepartmentID varchar(50),				--部門ID
	DepartmentAncestorName nvarchar(100),	--部門名称
	DepartmentName nvarchar(100),			--部門名称

	QualityCheckStandardID bigint,			--模板ID
	QualityCheckStandardName nvarchar(255),	--模板名称

	CheckUserID bigint,						--检查人UserID
	CheckUserName	nvarchar(255),			--检查人
	CheckDate datetime,						--检查时间

    ReCheckUserID bigint,
    ReCheckUserName nvarchar(255),
	ReCheckDate datetime,
    IsReChecked int
);
create table IF NOT EXISTS  Quality_QualityReCheck_Parent
(
	ID integer  primary key autoincrement ,  --ID主键
	ReCheckID bigint,						--抽查ID　	外键 Quality_QualityReCheck(ID)
	ParentID bigint ,  						--核查项父级ID
	ParentItemName nvarchar(255),			--父级名称
	ParentAncestorName nvarchar(255),		--父级名称
	ItemCount int,							--核查项数
	PassCount int,							--核查总数
	ConformCount int,						--核查得数
    IsReChecked  tinyint default(0),			--是否已核查
    IsUpLoad tinyint default(0)				--是否上传　0未上传　1已上传
);
CREATE Index IF NOT EXISTS  Quality_QualityReCheck_Parent_Idx_ReCheckID on Quality_QualityReCheck_Parent(ReCheckID DESC);
create table IF NOT EXISTS  Quality_QualityReCheck_Detail
(
	ID integer  primary key ,  			--ID主键
	ReCheckID bigint,					--抽查ID　		  外键 Quality_QualityReCheck(ID)
	ParentID bigint,  					--核查项父级ID

	ItemID bigint,						--核查项ID
	ItemName nvarchar(255),				--核查项名称
	AncestorName nvarchar(255),			--核查项名称
	ItemScore decimal(18,2),			--核查项分数

	IsPass int,							--是否合格
	CheckRemark nvarchar(500),			--核查备注
	CheckDate datetime,
	CheckFileID bigint	default(0)	,	--核查附件照片

	IsReChecked int,
	IsConform int,
	ConformCause int,
	ReCheckRemark nvarchar(500),
	ReCheckDate  datetime,

	FileID bigint	default(0)	,		--附件照片
	FileCount int ,
    IsUpLoad tinyint default(0)			--是否上传　0未上传　1已上传
);
CREATE Index IF NOT EXISTS Quality_QualityReCheck_Detail_Idx_ReCheckID_ParentID	on Quality_QualityReCheck_Detail(ReCheckID DESC,ParentID DESC);